/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.spi.viewmodel.ModelListener;

public final class GdbThread
extends Thread {
    private final String line;
    private final String file;
    private final String tid;
    private final String name;

    GdbThread(NativeDebugger debugger, ModelChangeDelegator updater, String tid, String name, Frame frame) {
        super(debugger, (ModelListener)updater);
        this.tid = tid;
        this.line = frame.getLineNo();
        this.file = frame.getSource();
        this.current_function = frame.getFunc();
        this.address = frame.getCurrentPC();
        this.name = name;
    }

    GdbThread(NativeDebugger debugger, ModelChangeDelegator updater, String consoleLine) {
        super(debugger, (ModelListener)updater);
        if (consoleLine.startsWith("* ")) {
            consoleLine = consoleLine.substring(2);
        }
        assert (Character.isDigit(consoleLine.charAt(0))) : "invalid thread line: " + consoleLine;
        int pos = 0;
        while (Character.isDigit(consoleLine.charAt(pos))) {
            ++pos;
        }
        this.tid = consoleLine.substring(0, pos);
        this.name = consoleLine.substring(pos);
        this.line = "";
        this.file = "";
        this.current_function = "";
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.tid;
    }

    public String getFile() {
        return this.file;
    }

    public String getLine() {
        return this.line;
    }

    public boolean hasEvent() {
        return false;
    }

    public String getLWP() {
        return null;
    }

    public Integer getPriority() {
        return null;
    }

    public Integer getStackSize() {
        return null;
    }

    public String getStartFunction() {
        return null;
    }

    public String getStartupFlags() {
        return null;
    }

    public String getState() {
        return null;
    }

    public boolean getSuspended() {
        return false;
    }
}

