/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class RepositoryPreferences {
    private static final Logger LOG = Logger.getLogger(RepositoryPreferences.class.getName());
    private static RepositoryPreferences instance;
    public static final String LOCAL_REPO_ID = "local";
    public static final String REPO_CENTRAL = "http://repo1.maven.org/maven2/";
    public static final String TYPE_NEXUS = "nexus";
    static final String KEY_TYPE = "provider";
    static final String KEY_DISPLAY_NAME = "displayName";
    static final String KEY_PATH = "path";
    static final String KEY_INDEX_URL = "repoIndexUrl";
    static final String KEY_REPO_URL = "repoUrl";
    public static final String PROP_INDEX_FREQ = "indexUpdateFrequency";
    public static final String PROP_LAST_INDEX_UPDATE = "lastIndexUpdate";
    public static final String PROP_SNAPSHOTS = "includeSnapshots";
    public static final int FREQ_ONCE_WEEK = 0;
    public static final int FREQ_ONCE_DAY = 1;
    public static final int FREQ_STARTUP = 2;
    public static final int FREQ_NEVER = 3;
    private final Map<FileObject, RepositoryInfo> infoCache = new HashMap<FileObject, RepositoryInfo>();
    private static final String REPO_FOLDER = "Projects/org-netbeans-modules-maven/Repositories";
    private static final char[] forbiddenChars;
    private static final char replaceChar = '-';

    private RepositoryPreferences() {
    }

    private Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/nexus/indexing");
    }

    private FileObject getRepoFolder() {
        FileObject repo = FileUtil.getConfigFile((String)REPO_FOLDER);
        if (repo == null) {
            LOG.warning("Maven Repository root folder Projects/org-netbeans-modules-maven/Repositories was deleted somehow, creating dummy (empty) one.");
            try {
                repo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)REPO_FOLDER);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return repo;
    }

    public static synchronized RepositoryPreferences getInstance() {
        if (instance == null) {
            instance = new RepositoryPreferences();
        }
        return instance;
    }

    public RepositoryInfo getRepositoryInfoById(String id) {
        for (RepositoryInfo ri : this.getRepositoryInfos()) {
            if (!ri.getId().equals(id)) continue;
            return ri;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getRepositoryInfos() {
        FileObject repoFolder = this.getRepoFolder();
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        if (repoFolder != null) {
            Map<FileObject, RepositoryInfo> map = this.infoCache;
            synchronized (map) {
                List repos = FileUtil.getOrder(Arrays.asList(repoFolder.getChildren()), (boolean)false);
                HashSet<FileObject> gone = new HashSet<FileObject>(this.infoCache.keySet());
                for (FileObject fo : repos) {
                    RepositoryInfo ri = this.infoCache.get(fo);
                    if (ri == null) {
                        try {
                            ri = RepositoryInfo.createRepositoryInfo(fo);
                            this.infoCache.put(fo, ri);
                        }
                        catch (Exception x) {
                            LOG.log(Level.INFO, fo.getPath(), x);
                            try {
                                fo.delete();
                            }
                            catch (IOException x2) {
                                LOG.log(Level.INFO, null, x2);
                            }
                            continue;
                        }
                    }
                    toRet.add(ri);
                    gone.remove(fo);
                }
                for (FileObject g : gone) {
                    this.infoCache.remove(g);
                }
            }
        }
        return toRet;
    }

    public synchronized void addOrModifyRepositoryInfo(RepositoryInfo info) {
        try {
            FileObject fo = this.getRepoFolder().getFileObject(this.getFileObjectName(info.getId()));
            if (fo == null) {
                ArrayList<FileObject> kids = new ArrayList<FileObject>(FileUtil.getOrder(Arrays.asList(this.getRepoFolder().getChildren()), (boolean)true));
                fo = this.getRepoFolder().createData(this.getFileObjectName(info.getId()));
                kids.add(fo);
                FileUtil.setOrder(kids);
            } else if (this.infoCache.containsKey(fo)) {
                this.infoCache.put(fo, info);
            }
            fo.setAttribute(KEY_TYPE, (Object)info.getType());
            fo.setAttribute(KEY_DISPLAY_NAME, (Object)info.getName());
            fo.setAttribute(KEY_PATH, (Object)info.getRepositoryPath());
            fo.setAttribute(KEY_REPO_URL, (Object)info.getRepositoryUrl());
            if (info.getRepositoryUrl() != null) {
                fo.setAttribute(KEY_INDEX_URL, (Object)(info.getIndexUpdateUrl().equals(info.getRepositoryUrl() + ".index/") ? null : info.getIndexUpdateUrl()));
            }
        }
        catch (SyncFailedException x) {
            LOG.log(Level.INFO, "#185147: possible race condition updating " + info.getId(), x);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getFileObjectName(String id) {
        char[] chars = id.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            for (int j = 0; j < forbiddenChars.length; ++j) {
                if (chars[i] != forbiddenChars[j]) continue;
                chars[i] = 45;
            }
        }
        String toRet = String.valueOf(chars);
        if (toRet.contains(".")) {
            toRet = toRet + ".ext";
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryInfo(RepositoryInfo info) {
        FileObject fo = this.getRepoFolder().getFileObject(this.getFileObjectName(info.getId()));
        if (fo != null) {
            Map<FileObject, RepositoryInfo> map = this.infoCache;
            synchronized (map) {
                this.infoCache.remove(fo);
            }
            try {
                fo.delete();
            }
            catch (IOException x) {
                LOG.log(Level.FINE, "Cannot delete repository in system filesystem", x);
            }
        }
    }

    public void setIndexUpdateFrequency(int fr) {
        this.getPreferences().putInt(PROP_INDEX_FREQ, fr);
    }

    public int getIndexUpdateFrequency() {
        return this.getPreferences().getInt(PROP_INDEX_FREQ, Boolean.getBoolean("netbeans.full.hack") ? 3 : 0);
    }

    public Date getLastIndexUpdate(String repoId) {
        return new Date(this.getPreferences().getLong("lastIndexUpdate." + repoId, 0L));
    }

    public void setLastIndexUpdate(String repoId, Date date) {
        this.getPreferences().putLong("lastIndexUpdate." + repoId, date.getTime());
    }

    public boolean isIncludeSnapshots() {
        return this.getPreferences().getBoolean(PROP_SNAPSHOTS, true);
    }

    public void setIncludeSnapshots(boolean includeSnapshots) {
        this.getPreferences().putBoolean(PROP_SNAPSHOTS, includeSnapshots);
    }

    static {
        forbiddenChars = new char[]{'/', '\\', '?', '%', '*', ':', '|', '\"', '<', '>'};
    }
}

