/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.spi.gototest.TestLocator;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class GoToOppositeAction
implements TestLocator {
    public boolean asynchronous() {
        return true;
    }

    public TestLocator.LocationResult findOpposite(FileObject fileObj, int caretOffset) {
        throw new UnsupportedOperationException("JUnit's GoToOppositeAction is asynchronous");
    }

    public void findOpposite(FileObject fileObj, int caretOffset, TestLocator.LocationListener callback) {
        Project project;
        boolean sourceToTest;
        block6: {
            block5: {
                FileObject fileObjRoot;
                ClassPath srcCP;
                boolean isJavaFile = false;
                sourceToTest = true;
                if (fileObj == null || !fileObj.isFolder() && !(isJavaFile = TestUtil.isJavaFile(fileObj)) || (srcCP = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null || (fileObjRoot = srcCP.findOwnerRoot(fileObj)) == null || (project = FileOwnerQuery.getOwner((FileObject)fileObjRoot)) == null) break block5;
                if (UnitTestForSourceQuery.findUnitTests((FileObject)fileObjRoot).length != 0) break block6;
                sourceToTest = false;
                if (false || isJavaFile && UnitTestForSourceQuery.findSources((FileObject)fileObjRoot).length != 0) break block6;
            }
            callback.foundLocation(fileObj, new TestLocator.LocationResult(null));
            return;
        }
        JUnitPlugin plugin = TestUtil.getPluginForProject(project);
        assert (plugin != null);
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject[] srcRoots = new FileObject[srcGroups.length];
        for (int i = 0; i < srcGroups.length; ++i) {
            srcRoots[i] = srcGroups[i].getRootFolder();
        }
        ClassPath srcClassPath = ClassPathSupport.createClassPath((FileObject[])srcRoots);
        RequestProcessor.getDefault().post((Runnable)new ActionImpl(plugin, callback, new JUnitPlugin.Location(fileObj), sourceToTest, srcClassPath));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean checkDirection(FileObject fileObj) {
        ClassPath srcCP;
        boolean isJavaFile = false;
        boolean sourceToTest = true;
        if (fileObj == null) return null;
        if (!fileObj.isFolder()) {
            isJavaFile = TestUtil.isJavaFile(fileObj);
            if (!isJavaFile) return null;
        }
        if ((srcCP = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null) return null;
        FileObject fileObjRoot = srcCP.findOwnerRoot(fileObj);
        if (fileObjRoot == null) return null;
        if (UnitTestForSourceQuery.findUnitTests((FileObject)fileObjRoot).length == 0) {
            sourceToTest = false;
            if (!false) {
                if (!isJavaFile) return null;
                if (UnitTestForSourceQuery.findSources((FileObject)fileObjRoot).length == 0) return null;
            }
        }
        boolean bl = true;
        boolean enabled = bl;
        if (!enabled) return null;
        Boolean bl2 = sourceToTest;
        return bl2;
    }

    public boolean appliesTo(FileObject fo) {
        return TestUtil.isJavaFile(fo);
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        Boolean b = this.checkDirection(fo);
        if (b == null) {
            return TestLocator.FileType.NEITHER;
        }
        if (b.booleanValue()) {
            return TestLocator.FileType.TESTED;
        }
        return TestLocator.FileType.TEST;
    }

    private class ActionImpl
    implements Runnable {
        private final JUnitPlugin plugin;
        private final JUnitPlugin.Location currLocation;
        private final boolean sourceToTest;
        private final ClassPath srcClassPath;
        private final TestLocator.LocationListener callback;
        private JUnitPlugin.Location oppoLocation;

        ActionImpl(JUnitPlugin plugin, TestLocator.LocationListener callback, JUnitPlugin.Location currLocation, boolean sourceToTest, ClassPath srcClassPath) {
            this.plugin = plugin;
            this.currLocation = currLocation;
            this.sourceToTest = sourceToTest;
            this.srcClassPath = srcClassPath;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                this.findOppositeLocation();
                if (this.oppoLocation != null || this.sourceToTest) {
                    EventQueue.invokeLater(this);
                }
            } else if (this.oppoLocation != null) {
                this.goToOppositeLocation();
            } else if (this.sourceToTest) {
                this.displayNoOppositeLocationFound();
            }
        }

        private void findOppositeLocation() {
            this.oppoLocation = this.sourceToTest ? JUnitPluginTrampoline.DEFAULT.getTestLocation(this.plugin, this.currLocation) : JUnitPluginTrampoline.DEFAULT.getTestedLocation(this.plugin, this.currLocation);
        }

        private void goToOppositeLocation() {
            assert (this.oppoLocation != null);
            assert (this.oppoLocation.getFileObject() != null);
            FileObject oppoFile = this.oppoLocation.getFileObject();
            this.callback.foundLocation(this.currLocation.getFileObject(), new TestLocator.LocationResult(oppoFile, -1));
        }

        private void displayNoOppositeLocationFound() {
            FileObject fileObj = this.currLocation.getFileObject();
            String sourceClsName = this.srcClassPath.getResourceName(fileObj, '.', false);
            String msgKey = !fileObj.isFolder() ? "MSG_test_class_not_found" : (sourceClsName.length() != 0 ? "MSG_testsuite_class_not_found" : "MSG_testsuite_class_not_found_def_pkg");
            this.callback.foundLocation(this.currLocation.getFileObject(), new TestLocator.LocationResult(NbBundle.getMessage(this.getClass(), (String)msgKey, (Object)sourceClsName)));
        }
    }

    private class ElementFinder
    implements CancellableTask<CompilationController> {
        private final int caretPosition;
        private volatile boolean cancelled;
        private Element element = null;

        private ElementFinder(int caretPosition) {
            this.caretPosition = caretPosition;
        }

        public void run(CompilationController controller) throws IOException {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            if (this.cancelled) {
                return;
            }
            TreePath treePath = controller.getTreeUtilities().pathFor(this.caretPosition);
            if (treePath != null) {
                Tree.Kind parentKind;
                if (this.cancelled) {
                    return;
                }
                TreePath parent = treePath.getParentPath();
                while (parent != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)(parentKind = parent.getLeaf().getKind())) && parentKind != Tree.Kind.COMPILATION_UNIT) {
                    treePath = parent;
                    parent = treePath.getParentPath();
                }
            }
            if (treePath != null) {
                if (this.cancelled) {
                    return;
                }
                try {
                    this.element = controller.getTrees().getElement(treePath);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger("global").log(Level.WARNING, null, ex);
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        Element getElement() {
            return this.element;
        }
    }
}

