/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityConstraintPanel;
import org.openide.util.NbBundle;

public class SecurityRolesEditorPanel
extends JPanel {
    private JButton addButton;
    private JTable allRolesTable;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton removeButton;
    private JTable selectedRolesTable;

    public SecurityRolesEditorPanel(String[] allRoles, String[] selectedRoles) {
        this.initComponents();
        this.initTable(this.allRolesTable, this.getRemainingRoles(allRoles, selectedRoles), NbBundle.getMessage(SecurityConstraintPanel.class, (String)"LBL_AllSecurityRoles"));
        this.initTable(this.selectedRolesTable, selectedRoles, NbBundle.getMessage(SecurityConstraintPanel.class, (String)"LBL_AllSecurityRoles"));
    }

    public String[] getSelectedRoles() {
        DefaultTableModel model = (DefaultTableModel)this.selectedRolesTable.getModel();
        int rowCount = model.getRowCount();
        String[] selectedRoles = new String[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            selectedRoles[i] = (String)model.getValueAt(i, 0);
        }
        return selectedRoles;
    }

    private void initTable(JTable table, String[] data, String columnName) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn(columnName);
        for (int i = 0; i < data.length; ++i) {
            model.addRow(new Object[]{data[i]});
        }
        table.setModel(model);
    }

    private String[] getRemainingRoles(String[] allRoles, String[] selectedRoles) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < allRoles.length; ++i) {
            String roleName = allRoles[i];
            boolean found = false;
            for (int j = 0; j < selectedRoles.length; ++j) {
                if (!roleName.equals(selectedRoles[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(roleName);
        }
        String[] remainingRoles = new String[result.size()];
        return result.toArray(remainingRoles);
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.allRolesTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.selectedRolesTable = new JTable();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle");
        this.addButton.setText(bundle.getString("LBL_AddSecurityRole"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityRolesEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(bundle.getString("LBL_RemoveSecurityRole"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityRolesEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.allRolesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.allRolesTable);
        this.selectedRolesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.selectedRolesTable);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 211, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.addButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 227, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 281, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 281, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(85, 85, 85).add((Component)this.addButton).add(35, 35, 35).add((Component)this.removeButton))).addContainerGap()));
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int i;
        int[] selectedRows = this.selectedRolesTable.getSelectedRows();
        DefaultTableModel allRolesTableModel = (DefaultTableModel)this.allRolesTable.getModel();
        DefaultTableModel selectedRolesTableModel = (DefaultTableModel)this.selectedRolesTable.getModel();
        for (i = 0; i < selectedRows.length; ++i) {
            String roleName = (String)selectedRolesTableModel.getValueAt(selectedRows[i], 0);
            allRolesTableModel.addRow(new Object[]{roleName});
        }
        for (i = selectedRows.length - 1; i >= 0; --i) {
            selectedRolesTableModel.removeRow(selectedRows[i]);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int i;
        int[] selectedRows = this.allRolesTable.getSelectedRows();
        DefaultTableModel allRolesTableModel = (DefaultTableModel)this.allRolesTable.getModel();
        DefaultTableModel selectedRolesTableModel = (DefaultTableModel)this.selectedRolesTable.getModel();
        for (i = 0; i < selectedRows.length; ++i) {
            String roleName = (String)allRolesTableModel.getValueAt(selectedRows[i], 0);
            selectedRolesTableModel.addRow(new Object[]{roleName});
        }
        for (i = selectedRows.length - 1; i >= 0; --i) {
            allRolesTableModel.removeRow(selectedRows[i]);
        }
    }
}

