/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import javax.lang.model.element.ExecutableElement;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;

public class Methods {
    public static boolean isSameMethod(ExecutableElement javaMethod, MethodCallExpression methodCall) {
        ConstantExpression methodName = (ConstantExpression)methodCall.getMethod();
        return javaMethod.getSimpleName().contentEquals(methodName.getText()) && Methods.getParameterCount(methodCall) == javaMethod.getParameters().size();
    }

    public static boolean isSameMethod(MethodNode methodNode, MethodCallExpression methodCall) {
        return methodNode.getName().equals(methodCall.getMethodAsString()) && Methods.getParameterCount(methodCall) == methodNode.getParameters().length;
    }

    public static boolean isSameMethod(MethodNode methodNode1, MethodNode methodNode2) {
        return methodNode1.getName().equals(methodNode2.getName()) && methodNode1.getParameters().length == methodNode2.getParameters().length;
    }

    public static boolean isSameMethod(MethodCallExpression methodCall1, MethodCallExpression methodCall2) {
        String method1 = methodCall1.getMethodAsString();
        if (method1 != null && method1.equals(methodCall2.getMethodAsString())) {
            int size1 = Methods.getParameterCount(methodCall1);
            int size2 = Methods.getParameterCount(methodCall2);
            if (size1 >= 0 && size1 == size2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSameConstructor(ConstructorNode constructor, ConstructorCallExpression call) {
        return constructor.getDeclaringClass().getNameWithoutPackage().equals(call.getType().getNameWithoutPackage()) && Methods.getParameterCount(call) == constructor.getParameters().length;
    }

    public static boolean isSameConstuctor(ConstructorCallExpression call1, ConstructorCallExpression call2) {
        String constructor1 = call1.getType().getNameWithoutPackage();
        if (constructor1 != null && constructor1.equals(call2.getType().getNameWithoutPackage())) {
            int size1 = Methods.getParameterCount(call1);
            int size2 = Methods.getParameterCount(call2);
            if (size1 >= 0 && size1 == size2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSameConstructor(ConstructorNode constructor1, ConstructorNode constructor2) {
        return Methods.isSameMethod((MethodNode)constructor1, constructor2);
    }

    private static int getParameterCount(MethodCallExpression methodCall) {
        Expression expression = methodCall.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }

    private static int getParameterCount(ConstructorCallExpression constructorCall) {
        Expression expression = constructorCall.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }
}

