/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.websvc.design.multiview.MultiViewSupport;
import org.netbeans.modules.websvc.design.navigator.WSDesignNavigatorHint;
import org.netbeans.modules.websvc.design.view.DesignView;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class DesignMultiViewElement
extends TopComponent
implements MultiViewElement {
    private static final long serialVersionUID = 1L;
    private transient MultiViewElementCallback multiViewCallback;
    private transient DesignView designView;
    private transient DataObject dataObject;
    private transient Lookup myLookup;

    public DesignMultiViewElement(DataObject dataObject) {
        this.dataObject = dataObject;
        this.initialize();
    }

    private void initialize() {
        this.myLookup = Lookups.fixed((Object[])new Object[]{new WSDesignNavigatorHint()});
    }

    public int getPersistenceType() {
        return 2;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewCallback = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void initUI() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        MultiViewSupport multiViewSupport = (MultiViewSupport)this.dataObject.getCookie(MultiViewSupport.class);
        if (multiViewSupport != null && multiViewSupport.getService() != null) {
            this.designView = new DesignView(multiViewSupport.getService(), multiViewSupport.getImplementationBean());
            this.add(this.designView);
        } else {
            JLabel jLabel = new JLabel("The design view can not be rendered. Please switch to source view.");
            this.add(jLabel, "Center");
        }
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentOpened() {
        super.componentOpened();
        this.initUI();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentShowing() {
        Node[] nodeArray;
        super.componentShowing();
        if (this.dataObject.isValid()) {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = this.dataObject.getNodeDelegate();
        } else {
            nodeArray = new Node[]{};
        }
        this.setActivatedNodes(nodeArray);
    }

    public void componentHidden() {
        super.componentHidden();
        this.setActivatedNodes(new Node[0]);
    }

    public JComponent getToolbarRepresentation() {
        if (this.designView != null) {
            return this.designView.getToolbarRepresentation();
        }
        return new JPanel();
    }

    public UndoRedo getUndoRedo() {
        return super.getUndoRedo();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public Lookup getLookup() {
        return new ProxyLookup(new Lookup[]{super.getLookup(), this.myLookup});
    }
}

