/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.multiview.DesignMultiViewDesc;
import org.netbeans.modules.websvc.design.multiview.ShowComponentCookie;
import org.netbeans.modules.websvc.design.multiview.SourceMultiViewDesc;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class MultiViewSupport
implements OpenCookie,
EditCookie {
    static final long serialVersionUID = 1L;
    private DataObject dataObject;
    private Service service;
    private DataObject wsdlDo;
    public static String SOURCE_UNSAFE_CLOSE = "SOURCE_UNSAFE_CLOSE";
    private static String DESIGN_UNSAFE_CLOSE = "DESIGN_UNSAFE_CLOSE";
    static Logger l = Logger.getLogger(MultiViewSupport.class.getName());

    public MultiViewSupport() {
    }

    public MultiViewSupport(Service service, DataObject dataObject) {
        this.dataObject = dataObject;
        this.service = service;
        this.initWsdlDO();
    }

    public void open() {
        this.view(View.DESIGN, new Object[0]);
    }

    public void edit() {
        this.view(View.SOURCE, new Object[0]);
    }

    public void preview() {
        this.view(View.PREVIEW, new Object[0]);
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class);
    }

    Service getService() {
        return this.service;
    }

    FileObject getImplementationBean() {
        return this.getDataObject().getPrimaryFile();
    }

    public CloneableTopComponent createMultiView() {
        MultiViewDescription[] multiViewDescriptionArray = this.service != null && this.service.getLocalWsdlFile() != null ? new MultiViewDescription[]{new SourceMultiViewDesc(this.getDataObject()), new DesignMultiViewDesc(this.getDataObject())} : new MultiViewDescription[]{new SourceMultiViewDesc(this.getDataObject()), new DesignMultiViewDesc(this.getDataObject())};
        CloneableTopComponent cloneableTopComponent = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])multiViewDescriptionArray, (MultiViewDescription)multiViewDescriptionArray[0], (CloseOperationHandler)new CloseHandler(this.getDataObject()));
        String string = this.getDataObject().getNodeDelegate().getDisplayName();
        cloneableTopComponent.setDisplayName(string);
        cloneableTopComponent.setName(string);
        return cloneableTopComponent;
    }

    public void view(final View view, final Object ... objectArray) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiViewSupport.this.viewInSwingThread(view, objectArray);
                }
            });
        } else {
            this.viewInSwingThread(view, objectArray);
        }
    }

    private void viewInSwingThread(View view, Object ... objectArray) {
        TopComponent topComponent;
        ShowComponentCookie showComponentCookie;
        this.getEditorSupport().open();
        switch (view) {
            case SOURCE: {
                MultiViewSupport.requestMultiviewActive("webservice-sourceview");
                break;
            }
            case DESIGN: {
                MultiViewSupport.requestMultiviewActive("webservice-designview");
                break;
            }
            case PREVIEW: {
                MultiViewSupport.requestMultiviewActive("webservice-wsdlpreview");
            }
        }
        if (objectArray != null && objectArray.length > 0 && (showComponentCookie = (ShowComponentCookie)(topComponent = TopComponent.getRegistry().getActivated()).getLookup().lookup(ShowComponentCookie.class)) != null) {
            showComponentCookie.show(objectArray[0]);
        }
    }

    private static void requestMultiviewActive(String string) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            MultiViewPerspective[] multiViewPerspectiveArray;
            for (MultiViewPerspective multiViewPerspective : multiViewPerspectiveArray = multiViewHandler.getPerspectives()) {
                if (!multiViewPerspective.preferredID().equals(string)) continue;
                multiViewHandler.requestActive(multiViewPerspective);
            }
        }
    }

    public static int getNumberOfClones(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return -1;
        }
        return Collections.list(((CloneableTopComponent)topComponent).getReference().getComponents()).size();
    }

    private void initWsdlDO() {
        JAXWSSupport jAXWSSupport;
        FileObject fileObject;
        if (this.service == null) {
            return;
        }
        DataObject dataObject = null;
        FileObject fileObject2 = null;
        FileObject fileObject3 = this.getImplementationBean();
        String string = this.service.getLocalWsdlFile();
        if (string != null && (fileObject2 = (fileObject = (jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject3)).getLocalWsdlFolderForService(this.service.getName(), false)).getFileObject(string)) != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        this.wsdlDo = dataObject;
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3838395157610633251L;
        private DataObject sourceDataObject;

        private CloseHandler() {
        }

        public CloseHandler(DataObject dataObject) {
            this.sourceDataObject = dataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] confirmation) {
            StringBuffer stringBuffer = new StringBuffer();
            for (CloseOperationState closeOperationState : confirmation) {
                if (!closeOperationState.getCloseWarningID().equals(SOURCE_UNSAFE_CLOSE)) continue;
                stringBuffer.append(NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.sourceDataObject.getPrimaryFile().getNameExt()));
                stringBuffer.append("\n");
            }
            NotifyDescriptor.Confirmation confirmation2 = new NotifyDescriptor.Confirmation((Object)stringBuffer.toString().trim());
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation2);
            for (NotifyDescriptor.Confirmation confirmation3 : confirmation) {
                Action action = null;
                if (object == NotifyDescriptor.YES_OPTION) {
                    action = confirmation3.getProceedAction();
                } else if (object == NotifyDescriptor.NO_OPTION) {
                    action = confirmation3.getDiscardAction();
                } else {
                    return false;
                }
                if (action == null) continue;
                action.actionPerformed(new ActionEvent(this, 1001, ""));
            }
            return true;
        }
    }

    public static enum View {
        SOURCE,
        DESIGN,
        PREVIEW;

    }
}

