/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class AbstractRefactoringPlugin
implements RefactoringPlugin {
    protected AbstractRefactoring refactoring;
    protected Pattern orderingLayerAttrPattern = Pattern.compile("([\\S]+)/([\\S]+)");

    public AbstractRefactoringPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int checkContentOfFile(FileObject fo, String classToLookFor) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fo.getInputStream(), "UTF-8"));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                if (line.indexOf(classToLookFor) != -1) {
                    int n = counter;
                    return n;
                }
                ++counter;
                line = reader.readLine();
            }
        }
        catch (IOException exc) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException x) {}
            }
        }
        return -1;
    }

    protected final InfoHolder examineLookup(Lookup lkp) throws IOException {
        final TreePathHandle handle = (TreePathHandle)lkp.lookup(TreePathHandle.class);
        final InfoHolder infoholder = new InfoHolder();
        CancellableTask<CompilationController> info = new CancellableTask<CompilationController>(){

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element neco = handle.resolveElement((CompilationInfo)info);
                if (neco == null) {
                    return;
                }
                infoholder.name = neco.getSimpleName().toString();
                if (neco.getKind() == ElementKind.CLASS) {
                    infoholder.isClass = true;
                    TypeElement te = (TypeElement)neco;
                    infoholder.fullName = te.getQualifiedName().toString();
                } else if (neco.getKind() == ElementKind.METHOD) {
                    infoholder.isMethod = true;
                    ExecutableElement ee = (ExecutableElement)neco;
                    TypeElement te = (TypeElement)ee.getEnclosingElement();
                    infoholder.fullName = te.getQualifiedName().toString();
                    infoholder.isPublic = ee.getModifiers().contains((Object)Modifier.PUBLIC);
                    infoholder.isStatic = ee.getModifiers().contains((Object)Modifier.STATIC);
                    List<? extends VariableElement> lst = ee.getParameters();
                    if (lst.size() > 1) {
                        infoholder.hasFileObjectParam = false;
                    } else {
                        if (lst.size() == 0) {
                            infoholder.hasNoParams = true;
                        }
                        for (VariableElement variableElement : lst) {
                            TypeElement vare;
                            String fqn;
                            TypeMirror tm = variableElement.asType();
                            if (tm.getKind() != TypeKind.DECLARED || !"org.openide.filesystems.FileObject".equals(fqn = (vare = (TypeElement)((DeclaredType)tm).asElement()).getQualifiedName().toString())) continue;
                            infoholder.hasFileObjectParam = true;
                        }
                    }
                } else if (neco.getKind() == ElementKind.CONSTRUCTOR) {
                    infoholder.isConstructor = true;
                    ExecutableElement ee = (ExecutableElement)neco;
                    TypeElement te = (TypeElement)ee.getEnclosingElement();
                    infoholder.fullName = te.getQualifiedName().toString();
                    infoholder.isPublic = ee.getModifiers().contains((Object)Modifier.PUBLIC);
                    List<? extends VariableElement> lst = ee.getParameters();
                    if (lst.size() == 0) {
                        infoholder.hasNoParams = true;
                    }
                }
            }

            public void cancel() {
            }
        };
        JavaSource source = JavaSource.forFileObject((FileObject)handle.getFileObject());
        if (source != null) {
            source.runUserActionTask((Task)info, true);
        }
        return infoholder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(FileObject manifestFO) {
        if (manifestFO != null) {
            Manifest manifest;
            InputStream is = manifestFO.getInputStream();
            try {
                manifest = new Manifest(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getLogger(AbstractRefactoringPlugin.class.getName()).log(Level.INFO, null, e);
                }
            }
            is.close();
            return manifest;
        }
        return null;
    }

    protected final void checkManifest(Project project, String fqClassName, RefactoringElementsBag refactoringElements) {
        String name = fqClassName;
        NbModuleProvider prov = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (prov == null) {
            return;
        }
        String pathName = name.replace('.', '/') + ".class";
        Manifest mf = AbstractRefactoringPlugin.getManifest(prov.getManifestFile());
        if (mf == null) {
            return;
        }
        Attributes attrs = mf.getMainAttributes();
        for (Map.Entry<Object, Object> entry : attrs.entrySet()) {
            RefactoringElementImplementation elem;
            String string = (String)entry.getValue();
            if (string.indexOf(name) == -1 && string.indexOf(pathName) == -1 || (elem = this.createManifestRefactoring(name, prov.getManifestFile(), ((Attributes.Name)entry.getKey()).toString(), string, null)) == null) continue;
            refactoringElements.add(this.refactoring, elem);
        }
        Map<String, Attributes> entries = mf.getEntries();
        if (entries != null) {
            for (Map.Entry<Object, Object> entry : entries.entrySet()) {
                attrs = (Attributes)entry.getValue();
                String val = (String)entry.getKey();
                if (val.indexOf(name) == -1 && val.indexOf(pathName) == -1) continue;
                String section = attrs.getValue("OpenIDE-Module-Class");
                RefactoringElementImplementation elem = this.createManifestRefactoring(name, prov.getManifestFile(), null, val, section);
                if (elem == null) continue;
                refactoringElements.add(this.refactoring, elem);
            }
        }
    }

    protected final void checkLayer(Project project, String fqname, RefactoringElementsBag refactoringElements) {
        LayerHandle handle = LayerHandle.forProject((Project)project);
        FileSystem fs = handle.layer(false);
        if (fs != null) {
            this.checkFileObject(fs.getRoot(), fqname, refactoringElements, handle);
        }
    }

    private void checkFileObject(FileObject fo, String fqname, RefactoringElementsBag refactoringElements, LayerHandle handle) {
        if (fo.isFolder()) {
            FileObject[] childs = fo.getChildren();
            for (int i = 0; i < childs.length; ++i) {
                this.checkFileObject(childs[i], fqname, refactoringElements, handle);
            }
            Enumeration en = fo.getAttributes();
            while (en.hasMoreElements()) {
                RefactoringElementImplementation elem;
                String name;
                String second;
                RefactoringElementImplementation elem2;
                String name2;
                String attrKey = (String)en.nextElement();
                Matcher match = this.orderingLayerAttrPattern.matcher(attrKey);
                if (!match.matches()) continue;
                String first = match.group(1);
                if (first.endsWith(".instance") && (name2 = first.substring(0, first.length() - ".instance".length()).replace('-', '.')).equals(fqname) && (elem2 = this.createLayerRefactoring(fqname, handle, fo, attrKey)) != null) {
                    refactoringElements.add(this.refactoring, elem2);
                }
                if (!(second = match.group(2)).endsWith(".instance") || !(name = second.substring(0, second.length() - ".instance".length()).replace('-', '.')).equals(fqname) || (elem = this.createLayerRefactoring(fqname, handle, fo, attrKey)) == null) continue;
                refactoringElements.add(this.refactoring, elem);
            }
        } else if (fo.isData()) {
            RefactoringElementImplementation elem;
            String name;
            Enumeration en = fo.getAttributes();
            while (en.hasMoreElements()) {
                RefactoringElementImplementation elem3;
                int index;
                String attrValue;
                String attrKey = (String)en.nextElement();
                Object val = fo.getAttribute("literal:" + attrKey);
                if (!(val instanceof String)) continue;
                String value = attrValue = (String)val;
                if (attrValue.startsWith("new:")) {
                    value = attrValue.substring("new:".length());
                }
                if (attrValue.startsWith("method:") && (index = (value = attrValue.substring("method:".length())).lastIndexOf(46)) > 0) {
                    value = value.substring(0, index);
                }
                String pattern1 = fqname.replaceAll("\\.", "\\.");
                String pattern2 = "[a-zA-Z0-9/-]*" + fqname.replaceAll("\\.", "-") + "\\.instance";
                if (!value.matches(pattern1) && !value.matches(pattern2) || (elem3 = this.createLayerRefactoring(fqname, handle, fo, attrKey)) == null) continue;
                refactoringElements.add(this.refactoring, elem3);
            }
            if ("instance".equals(fo.getExt()) && (name = fo.getName().replace('-', '.')).equals(fqname) && (elem = this.createLayerRefactoring(fqname, handle, fo, null)) != null) {
                refactoringElements.add(this.refactoring, elem);
            }
            if ("settings".equals(fo.getExt())) {
                // empty if block
            }
        }
    }

    protected final Problem checkMethodLayer(InfoHolder info, FileObject fo, RefactoringElementsBag refactoringElements) {
        LayerHandle handle;
        FileSystem fs;
        Problem problem = null;
        if (!info.isStatic) {
            return problem;
        }
        if (!info.hasFileObjectParam && !info.hasNoParams) {
            return problem;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null && (fs = (handle = LayerHandle.forProject((Project)project)).layer(false)) != null) {
            this.checkFileObject(fs.getRoot(), info.name, null, info.fullName, refactoringElements, handle);
        }
        return problem;
    }

    protected final Problem checkConstructorLayer(InfoHolder info, FileObject fo, RefactoringElementsBag refactoringElements) {
        LayerHandle handle;
        FileSystem fs;
        Problem problem = null;
        if (!info.isPublic || !info.hasNoParams) {
            return problem;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null && (fs = (handle = LayerHandle.forProject((Project)project)).layer(false)) != null) {
            this.checkFileObject(fs.getRoot(), null, info.name, info.fullName, refactoringElements, handle);
        }
        return problem;
    }

    private void checkFileObject(FileObject fo, String method, String constructor, String fqname, RefactoringElementsBag refactoringElements, LayerHandle handle) {
        block7: {
            block6: {
                if (!fo.isFolder()) break block6;
                FileObject[] childs = fo.getChildren();
                for (int i = 0; i < childs.length; ++i) {
                    this.checkFileObject(childs[i], method, constructor, fqname, refactoringElements, handle);
                }
                break block7;
            }
            if (!fo.isData()) break block7;
            if ("settings".equals(fo.getExt())) {
                // empty if block
            }
            Enumeration en = fo.getAttributes();
            while (en.hasMoreElements()) {
                RefactoringElementImplementation elem;
                String clazz;
                String attrKey = (String)en.nextElement();
                Object val = fo.getAttribute("literal:" + attrKey);
                if (!(val instanceof String)) continue;
                String attrValue = (String)val;
                if (method != null && attrValue.startsWith("method:") && attrValue.endsWith(method)) {
                    RefactoringElementImplementation elem2;
                    clazz = attrValue.substring("method:".length());
                    String methodString = null;
                    int index = clazz.lastIndexOf(46);
                    if (index > 0) {
                        methodString = clazz.substring(index + 1);
                        clazz = clazz.substring(0, index);
                    }
                    if (methodString != null && methodString.equals(method) && clazz.equals(fqname) && (elem2 = this.createLayerRefactoring(method, handle, fo, attrKey)) != null) {
                        refactoringElements.add(this.refactoring, elem2);
                    }
                }
                if (constructor == null || !attrValue.startsWith("new:") || !(clazz = attrValue.substring("new:".length())).equals(fqname) || (elem = this.createLayerRefactoring(constructor, handle, fo, attrKey)) == null) continue;
                refactoringElements.add(this.refactoring, elem);
            }
        }
    }

    protected abstract RefactoringElementImplementation createManifestRefactoring(String var1, FileObject var2, String var3, String var4, String var5);

    protected RefactoringElementImplementation createLayerRefactoring(String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected RefactoringElementImplementation createMethodLayerRefactoring(String method, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected RefactoringElementImplementation createConstructorLayerRefactoring(String constructor, String fqname, LayerHandle handle, FileObject layerFileObject, String layerAttribute) {
        throw new AssertionError((Object)"if you call checkLayer(), you need to implement this method");
    }

    protected static class InfoHolder {
        public String name = null;
        public String fullName = null;
        public boolean isClass = false;
        public boolean isMethod = false;
        public boolean isConstructor = false;
        public boolean isPublic = false;
        public boolean isStatic = false;
        public boolean hasFileObjectParam = false;
        public boolean hasNoParams = false;

        protected InfoHolder() {
        }
    }
}

