/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.java.JavaUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class BeanClassFinder {
    private FileObject fileObject;
    private Set<String> walkedBeanNames;
    private String startBeanName;
    private SpringBean startBean;

    public BeanClassFinder(Map<String, String> beanAttribs, FileObject fileObject) {
        this(fileObject, SpringXMLConfigEditorUtils.getMergedBean(beanAttribs, fileObject), BeanClassFinder.getBeanIdOrName(beanAttribs));
    }

    public BeanClassFinder(SpringBean bean, FileObject fileObject) {
        this(fileObject, SpringXMLConfigEditorUtils.getMergedBean(bean, fileObject), BeanClassFinder.getBeanIdOrName(bean));
    }

    private BeanClassFinder(FileObject fileObject, SpringBean startBean, String startBeanName) {
        this.fileObject = fileObject;
        this.startBean = startBean;
        this.startBeanName = startBeanName;
        this.walkedBeanNames = new HashSet<String>();
    }

    public String findImplementationClass() {
        this.walkedBeanNames.add(this.startBeanName);
        return this.findImplementationClass(this.startBean);
    }

    private String findImplementationClass(SpringBean logicalBean) {
        String implClass = null;
        if (logicalBean == null) {
            return null;
        }
        boolean staticFlag = false;
        if (StringUtils.hasText(logicalBean.getFactoryBean())) {
            implClass = this.findImplementationClass(logicalBean.getFactoryBean());
            staticFlag = false;
        } else if (StringUtils.hasText(logicalBean.getClassName())) {
            implClass = logicalBean.getClassName();
            staticFlag = true;
        }
        if (logicalBean.getFactoryMethod() != null && implClass != null) {
            implClass = this.getFactoryMethodReturnTypeName(implClass, logicalBean.getFactoryMethod(), staticFlag);
        }
        return implClass;
    }

    private String findImplementationClass(final String beanName) {
        if (this.walkedBeanNames.contains(beanName)) {
            return null;
        }
        final String[] clazz = new String[]{null};
        try {
            SpringConfigModel model = SpringConfigModel.forFileObject(this.fileObject);
            if (model == null) {
                return null;
            }
            model.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans springBeans) {
                    SpringBean bean = springBeans.findBean(beanName);
                    if ((bean = SpringXMLConfigEditorUtils.getMergedBean(bean, BeanClassFinder.this.fileObject)) == null) {
                        return;
                    }
                    String beanName2 = BeanClassFinder.getBeanIdOrName(bean);
                    BeanClassFinder.this.walkedBeanNames.add(beanName2);
                    clazz[0] = BeanClassFinder.this.findImplementationClass(bean);
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return clazz[0];
    }

    private String getFactoryMethodReturnTypeName(final String implClass, final String factoryMethodName, final boolean staticFlag) {
        final String[] retVal = new String[]{null};
        if (!StringUtils.hasText(factoryMethodName)) {
            return null;
        }
        try {
            JavaSource js = JavaUtils.getJavaSource(this.fileObject);
            if (js == null) {
                return null;
            }
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    if (implClass == null) {
                        return;
                    }
                    TypeElement te = JavaUtils.findClassElementByBinaryName(implClass, cc);
                    if (te == null) {
                        return;
                    }
                    FactoryMethodFinder factoryMethodFinder = new FactoryMethodFinder(te, factoryMethodName, staticFlag, cc.getElementUtilities());
                    List<ExecutableElement> methods = factoryMethodFinder.findMethods();
                    if (methods.size() != 1) {
                        return;
                    }
                    ExecutableElement method = methods.get(0);
                    if (method.getReturnType().getKind() != TypeKind.DECLARED) {
                        return;
                    }
                    DeclaredType dt = (DeclaredType)method.getReturnType();
                    retVal[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)dt.asElement()));
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return retVal[0];
    }

    private static String getBeanIdOrName(SpringBean bean) {
        if (bean.getId() != null) {
            return bean.getId();
        }
        if (bean.getNames().size() > 0) {
            return bean.getNames().get(0);
        }
        return null;
    }

    private static String getBeanIdOrName(Map<String, String> beanAttribs) {
        String name = beanAttribs.get("id");
        if (name != null) {
            return name;
        }
        name = beanAttribs.get("name");
        if (StringUtils.hasText(name)) {
            name = StringUtils.tokenize(name, ",; ").get(0);
        }
        return name;
    }

    private static class FactoryMethodFinder {
        private TypeElement te;
        private String factoryMethodName;
        private boolean staticFlag;
        private ElementUtilities eu;

        public FactoryMethodFinder(TypeElement te, String factoryMethodName, boolean staticFlag, ElementUtilities eu) {
            this.te = te;
            this.factoryMethodName = factoryMethodName;
            this.staticFlag = staticFlag;
            this.eu = eu;
        }

        public List<ExecutableElement> findMethods() {
            Iterable list = this.eu.getMembers(this.te.asType(), new ElementUtilities.ElementAcceptor(){

                public boolean accept(Element e, TypeMirror type) {
                    if (e.getKind() == ElementKind.METHOD) {
                        TypeElement te = (TypeElement)e.getEnclosingElement();
                        if (te.getQualifiedName().contentEquals("java.lang.Object")) {
                            return false;
                        }
                        if (!e.getSimpleName().toString().equals(FactoryMethodFinder.this.factoryMethodName)) {
                            return false;
                        }
                        ExecutableElement method = (ExecutableElement)e;
                        boolean isStatic = method.getModifiers().contains((Object)Modifier.STATIC);
                        return isStatic == FactoryMethodFinder.this.staticFlag;
                    }
                    return false;
                }
            });
            ArrayList<ExecutableElement> retList = new ArrayList<ExecutableElement>();
            for (Element e : list) {
                ExecutableElement ee = (ExecutableElement)e;
                retList.add(ee);
            }
            return retList;
        }
    }
}

