/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.EditRootAction;
import org.netbeans.modules.java.api.common.project.ui.RemoveClassPathRootAction;
import org.netbeans.modules.java.api.common.project.ui.ShowJavadocAction;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.support.ui.EditJarSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class ActionFilterNode
extends FilterNode {
    private static final RequestProcessor RP = new RequestProcessor(ActionFilterNode.class);
    private final Mode mode;
    private Action[] actionCache;

    static FilterNode forRoot(@NonNull Node original, @NonNull UpdateHelper helper, @NonNull String classPathId, @NonNull String entryId, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NonNull ReferenceHelper rh) {
        Parameters.notNull((CharSequence)"original", (Object)original);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"classPathId", (Object)classPathId);
        Parameters.notNull((CharSequence)"entryId", (Object)entryId);
        Parameters.notNull((CharSequence)"cs", (Object)cs);
        Parameters.notNull((CharSequence)"rh", (Object)rh);
        FileObject root = ActionFilterNode.getFolder(original);
        return new ActionFilterNode(original, Mode.ROOT, root, ActionFilterNode.createLookup(original, new Removable(helper, classPathId, entryId, webModuleElementName, cs, rh), new JavadocProvider(root, root)));
    }

    static FilterNode forLibrary(@NonNull Node original, @NonNull UpdateHelper helper, @NonNull String classPathId, @NonNull String entryId, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NonNull ReferenceHelper rh) {
        Parameters.notNull((CharSequence)"original", (Object)original);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"classPathId", (Object)classPathId);
        Parameters.notNull((CharSequence)"entryId", (Object)entryId);
        Parameters.notNull((CharSequence)"cs", (Object)cs);
        Parameters.notNull((CharSequence)"rh", (Object)rh);
        FileObject root = ActionFilterNode.getFolder(original);
        return new ActionFilterNode(original, Mode.EDITABLE_ROOT, root, ActionFilterNode.createLookup(original, new Removable(helper, classPathId, entryId, webModuleElementName, cs, rh), new LibraryEditable(entryId, rh), new JavadocProvider(root, root)));
    }

    static FilterNode forArchive(@NonNull Node original, @NonNull UpdateHelper helper, @NonNull PropertyEvaluator eval, @NonNull String classPathId, @NonNull String entryId, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NonNull ReferenceHelper rh) {
        Parameters.notNull((CharSequence)"original", (Object)original);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"eval", (Object)eval);
        Parameters.notNull((CharSequence)"classPathId", (Object)classPathId);
        Parameters.notNull((CharSequence)"entryId", (Object)entryId);
        Parameters.notNull((CharSequence)"cs", (Object)cs);
        Parameters.notNull((CharSequence)"rh", (Object)rh);
        FileObject root = ActionFilterNode.getFolder(original);
        return new ActionFilterNode(original, Mode.EDITABLE_ROOT, root, ActionFilterNode.createLookup(original, new Removable(helper, classPathId, entryId, webModuleElementName, cs, rh), new ArchiveEditable(entryId, helper, eval, rh), new JavadocProvider(root, root)));
    }

    static FilterNode forPackage(@NonNull Node original) {
        Parameters.notNull((CharSequence)"original", (Object)original);
        FileObject root = ActionFilterNode.getFolder(original);
        return new ActionFilterNode(original, Mode.PACKAGE, root, ActionFilterNode.createLookup(original, new JavadocProvider(root, root)));
    }

    private static FileObject getFolder(Node original) {
        DataObject dobj = (DataObject)original.getLookup().lookup(DataObject.class);
        assert (dobj != null);
        return dobj.getPrimaryFile();
    }

    private static Lookup createLookup(Node original, Object ... toAdd) {
        ProxyLookup lkp = new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.fixed((Object[])toAdd)});
        return lkp;
    }

    private ActionFilterNode(Node original, Mode mode, FileObject cpRoot, FileObject resource) {
        this(original, mode, cpRoot, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)new JavadocProvider(cpRoot, resource))}));
    }

    private ActionFilterNode(Node original, Mode mode) {
        super(original, (Children)(original.isLeaf() ? FilterNode.Children.LEAF : new ActionFilterChildren(original, mode, null)));
        this.mode = mode;
    }

    private ActionFilterNode(Node original, Mode mode, FileObject root, Lookup lkp) {
        super(original, (Children)(original.isLeaf() ? FilterNode.Children.LEAF : new ActionFilterChildren(original, mode, root)), lkp);
        this.mode = mode;
    }

    public Action[] getActions(boolean context) {
        Action[] result = this.initActions();
        return result;
    }

    public String getShortDescription() {
        FileObject pf;
        DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
        if (dobj != null && (pf = dobj.getPrimaryFile()) != null) {
            return FileUtil.getFileDisplayName((FileObject)pf);
        }
        return super.getShortDescription();
    }

    public Action getPreferredAction() {
        Action[] actions;
        if (this.mode == Mode.FILE && (actions = this.initActions()).length > 0 && ActionFilterNode.isOpenAction(actions[0])) {
            return actions[0];
        }
        return null;
    }

    private Action[] initActions() {
        if (this.actionCache == null) {
            ArrayList<Action> result = new ArrayList<Action>(2);
            if (this.mode == Mode.FILE) {
                for (Action superAction : super.getActions(false)) {
                    if (!ActionFilterNode.isOpenAction(superAction)) continue;
                    result.add(superAction);
                }
                result.add((Action)SystemAction.get(ShowJavadocAction.class));
            } else if (this.mode.isFolder()) {
                result.add((Action)SystemAction.get(ShowJavadocAction.class));
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof FindAction)) continue;
                    result.add(superActions[i]);
                }
                if (this.mode.isRoot()) {
                    result.add((Action)SystemAction.get(RemoveClassPathRootAction.class));
                }
                if (this.mode == Mode.EDITABLE_ROOT) {
                    result.add((Action)SystemAction.get(EditRootAction.class));
                }
            }
            this.actionCache = result.toArray(new Action[result.size()]);
        }
        return this.actionCache;
    }

    private static boolean isOpenAction(Action action) {
        if (action == null) {
            return false;
        }
        if (action instanceof OpenAction || action instanceof EditAction) {
            return true;
        }
        return "org.netbeans.api.actions.Openable".equals(action.getValue("type"));
    }

    private static class ArchiveEditable
    implements EditRootAction.Editable {
        private static final String FILE_REF = "file.reference.";
        private static final String SRC_REF = "source.reference.";
        private static final String JDOC_REF = "javadoc.reference.";
        private final UpdateHelper updateHelper;
        private final PropertyEvaluator eval;
        private final ReferenceHelper refHelper;
        private final String entryId;

        private ArchiveEditable(@NonNull String entryId, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper) {
            Parameters.notNull((CharSequence)"entryId", (Object)entryId);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
            if (!entryId.startsWith(FILE_REF)) {
                throw new IllegalArgumentException(entryId);
            }
            this.entryId = entryId;
            this.updateHelper = updateHelper;
            this.eval = eval;
            this.refHelper = refHelper;
        }

        @Override
        public boolean canEdit() {
            String propValue = this.eval.getProperty(this.entryId);
            return propValue != null;
        }

        @Override
        public void edit() {
            final String[] propValue = new String[1];
            final String[] oldSource = new String[1];
            final String[] oldJavadoc = new String[1];
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    propValue[0] = ArchiveEditable.this.eval.getProperty(ArchiveEditable.this.entryId);
                    assert (propValue[0] != null);
                    oldSource[0] = ArchiveEditable.this.getSource();
                    oldJavadoc[0] = ArchiveEditable.this.getJavadoc();
                }
            });
            EditJarSupport.Item oldItem = new EditJarSupport.Item();
            oldItem.setJarFile(propValue[0]);
            oldItem.setSourceFile(oldSource[0]);
            oldItem.setJavadocFile(oldJavadoc[0]);
            final EditJarSupport.Item newItem = EditJarSupport.showEditDialog((AntProjectHelper)this.updateHelper.getAntProjectHelper(), (EditJarSupport.Item)oldItem);
            if (newItem != null) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        ProjectManager.mutex().writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                ArchiveEditable.this.store(ArchiveEditable.this.getSourceProperty(), oldSource[0], newItem.getSourceFile());
                                ArchiveEditable.this.store(ArchiveEditable.this.getJavadocProperty(), oldJavadoc[0], newItem.getJavadocFile());
                            }
                        });
                    }
                });
            }
        }

        private String getSource() {
            return this.eval.getProperty(this.getSourceProperty());
        }

        private String getJavadoc() {
            return this.eval.getProperty(this.getJavadocProperty());
        }

        private String getSourceProperty() {
            return SRC_REF + this.entryId.substring(FILE_REF.length());
        }

        private String getJavadocProperty() {
            return JDOC_REF + this.entryId.substring(FILE_REF.length());
        }

        private void store(@NonNull String property, @NullAllowed String oldValue, @NullAllowed String newValue) {
            Parameters.notNull((CharSequence)"property", (Object)property);
            if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
                if (newValue != null) {
                    this.refHelper.createExtraForeignFileReferenceAsIs(newValue, property);
                } else {
                    EditableProperties ep = this.updateHelper.getProperties("nbproject/project.properties");
                    ep.remove((Object)property);
                    this.updateHelper.putProperties("nbproject/project.properties", ep);
                }
                try {
                    Project prj = FileOwnerQuery.getOwner((FileObject)this.updateHelper.getAntProjectHelper().getProjectDirectory());
                    ProjectManager.getDefault().saveProject(prj);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class LibraryEditable
    implements EditRootAction.Editable {
        private final ReferenceHelper refHelper;
        private final String entryId;

        private LibraryEditable(@NonNull String entryId, @NonNull ReferenceHelper refHelper) {
            Parameters.notNull((CharSequence)"entryId", (Object)entryId);
            Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
            if (!entryId.startsWith("libs.") || entryId.lastIndexOf(46) <= 4) {
                throw new IllegalArgumentException(entryId);
            }
            this.entryId = entryId;
            this.refHelper = refHelper;
        }

        @Override
        public boolean canEdit() {
            return this.getLibrary() != null;
        }

        @Override
        public void edit() {
            Library lib = this.getLibrary();
            assert (lib != null);
            LibrariesCustomizer.showSingleLibraryCustomizer((Library)lib);
        }

        private Library getLibrary() {
            String libName = this.entryId.substring(5, this.entryId.lastIndexOf(46));
            return this.refHelper.findLibrary(libName);
        }
    }

    static class Removable
    implements RemoveClassPathRootAction.Removable {
        private final UpdateHelper helper;
        private final String classPathId;
        private final String entryId;
        private final String webModuleElementName;
        private final ClassPathSupport cs;
        private ReferenceHelper rh;

        Removable(UpdateHelper helper, String classPathId, String entryId, String webModuleElementName, ClassPathSupport cs, ReferenceHelper rh) {
            this.helper = helper;
            this.classPathId = classPathId;
            this.entryId = entryId;
            this.webModuleElementName = webModuleElementName;
            this.cs = cs;
            this.rh = rh;
        }

        @Override
        public boolean canRemove() {
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            return props.getProperty(this.classPathId) != null;
        }

        @Override
        public Project remove() {
            boolean removed = false;
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            String raw = props.getProperty(this.classPathId);
            List<ClassPathSupport.Item> resources = this.cs.itemsList(raw, this.webModuleElementName);
            Iterator<ClassPathSupport.Item> i = resources.iterator();
            while (i.hasNext()) {
                ClassPathSupport.Item item = i.next();
                if (!this.entryId.equals(CommonProjectUtils.getAntPropertyName(item.getReference()))) continue;
                i.remove();
                if (Removable.isLastReference(this.entryId, props, this.classPathId)) {
                    Removable.destroyReference(this.rh, this.helper, item);
                }
                removed = true;
            }
            if (removed) {
                String[] itemRefs = this.cs.encodeToStrings(resources, this.webModuleElementName);
                props = this.helper.getProperties("nbproject/project.properties");
                props.setProperty(this.classPathId, itemRefs);
                this.helper.putProperties("nbproject/project.properties", props);
                return FileOwnerQuery.getOwner((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
            }
            return null;
        }

        private static boolean isLastReference(String property, EditableProperties props, String ignoreProperty) {
            for (Map.Entry entry : props.entrySet()) {
                if (ignoreProperty.equals(entry.getKey()) || !((String)entry.getValue()).contains(property)) continue;
                return false;
            }
            return true;
        }

        private static void destroyReference(ReferenceHelper rh, UpdateHelper uh, ClassPathSupport.Item item) {
            if (item.getType() == 2 || item.getType() == 0) {
                rh.destroyReference(item.getReference());
                if (item.getType() == 0) {
                    item.removeSourceAndJavadoc(uh);
                }
            }
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private static final AtomicBoolean initialized = new AtomicBoolean();
        private final FileObject cpRoot;
        private final FileObject resource;

        JavadocProvider(final @NonNull FileObject cpRoot, @NullAllowed FileObject resource) {
            this.cpRoot = cpRoot;
            this.resource = resource;
            if (!initialized.getAndSet(true)) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JavadocForBinaryQuery.findJavadoc((URL)cpRoot.getURL());
                        }
                        catch (FileStateInvalidException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }

        @Override
        public boolean hasJavadoc() {
            try {
                return this.resource != null && JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots().length > 0;
            }
            catch (FileStateInvalidException fsi) {
                return false;
            }
        }

        @Override
        public void showJavadoc() {
            try {
                URL pageURL;
                String relativeName = FileUtil.getRelativePath((FileObject)this.cpRoot, (FileObject)this.resource);
                URL[] urls = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots();
                if (relativeName.length() == 0) {
                    pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
                    if (pageURL == null) {
                        pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
                    }
                } else if (this.resource.isFolder()) {
                    pageURL = ShowJavadocAction.findJavadoc(relativeName + "/package-summary.html", urls);
                } else {
                    String javadocFileName = relativeName.substring(0, relativeName.lastIndexOf(46)) + ".html";
                    pageURL = ShowJavadocAction.findJavadoc(javadocFileName, urls);
                }
                ShowJavadocAction.showJavaDoc(pageURL, relativeName.replace('/', '.'));
            }
            catch (FileStateInvalidException fsi) {
                Exceptions.printStackTrace((Throwable)fsi);
            }
        }
    }

    private static class ActionFilterChildren
    extends FilterNode.Children {
        private final Mode mode;
        private final FileObject cpRoot;

        ActionFilterChildren(@NonNull Node original, @NonNull Mode mode, @NonNull FileObject cpRooot) {
            super(original);
            this.mode = mode;
            this.cpRoot = cpRooot;
        }

        protected Node[] createNodes(Node n) {
            if (this.mode.isFolder()) {
                DataObject dobj = (DataObject)n.getCookie(DataObject.class);
                if (dobj == null) {
                    assert (false) : "DataNode without DataObject in Lookup";
                    return new Node[0];
                }
                if (dobj.getPrimaryFile().isFolder()) {
                    return new Node[]{new ActionFilterNode(n, Mode.PACKAGE, this.cpRoot, dobj.getPrimaryFile())};
                }
                return new Node[]{new ActionFilterNode(n, Mode.FILE, this.cpRoot, dobj.getPrimaryFile())};
            }
            return new Node[]{new ActionFilterNode(n, Mode.FILE_CONTENT)};
        }
    }

    private static enum Mode {
        ROOT{

            @Override
            public boolean isFolder() {
                return true;
            }

            @Override
            public boolean isRoot() {
                return true;
            }
        }
        ,
        EDITABLE_ROOT{

            @Override
            public boolean isFolder() {
                return true;
            }

            @Override
            public boolean isRoot() {
                return true;
            }
        }
        ,
        PACKAGE{

            @Override
            public boolean isFolder() {
                return true;
            }

            @Override
            public boolean isRoot() {
                return false;
            }
        }
        ,
        FILE{

            @Override
            public boolean isFolder() {
                return false;
            }

            @Override
            public boolean isRoot() {
                return false;
            }
        }
        ,
        FILE_CONTENT{

            @Override
            public boolean isFolder() {
                return false;
            }

            @Override
            public boolean isRoot() {
                return false;
            }
        };


        public abstract boolean isFolder();

        public abstract boolean isRoot();
    }
}

