/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.exceptions.BadAttributeValueException;
import com.thaiopensource.relaxng.exceptions.ImpossibleAttributeIgnoredException;
import com.thaiopensource.relaxng.exceptions.OnlyTextNotAllowedException;
import com.thaiopensource.relaxng.exceptions.OutOfContextElementException;
import com.thaiopensource.relaxng.exceptions.RequiredAttributesMissingException;
import com.thaiopensource.relaxng.exceptions.RequiredElementsMissingException;
import com.thaiopensource.relaxng.exceptions.StringNotAllowedException;
import com.thaiopensource.relaxng.exceptions.TextNotAllowedException;
import com.thaiopensource.relaxng.exceptions.UnfinishedElementException;
import com.thaiopensource.relaxng.exceptions.UnknownElementException;
import com.thaiopensource.relaxng.impl.ApplyAfterFunction;
import com.thaiopensource.relaxng.impl.FindElementFunction;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import java.util.HashMap;
import java.util.Map;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext2;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternValidator
extends DtdContext
implements Validator,
ContentHandler,
DTDHandler,
ValidationContext2 {
    private final ValidatorPatternBuilder builder;
    private final Pattern start;
    private final ErrorHandler eh;
    private Map recoverPatternTable;
    private PatternMemo memo;
    private boolean hadError;
    private boolean collectingCharacters;
    private final StringBuffer charBuf = new StringBuffer();
    private PrefixMapping prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
    private Locator locator;
    private final Map datatypeErrors = new HashMap();
    private Name[] stack = null;
    private int stackLen = 0;
    private int suppressDepth = 0;

    private void startCollectingCharacters() {
        if (!this.collectingCharacters) {
            this.collectingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    private void flushCharacters() throws SAXException {
        this.collectingCharacters = false;
        int len = this.charBuf.length();
        block3: for (int i = 0; i < len; ++i) {
            switch (this.charBuf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Name name;
        if (this.collectingCharacters) {
            this.flushCharacters();
        }
        if (this.suppressDepth > 0) {
            ++this.suppressDepth;
        }
        if (!this.setMemo(this.memo.startTagOpenDeriv(name = new Name(namespaceURI, localName)))) {
            PatternMemo next = this.memo.startTagOpenRecoverDeriv(name);
            if (!next.isNotAllowed()) {
                this.error(new RequiredElementsMissingException(this.locator, name, this.peek()));
            } else {
                next = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()));
                if (next.isNotAllowed()) {
                    this.error(new UnknownElementException(this.locator, name, this.peek()));
                } else {
                    this.error(new OutOfContextElementException(this.locator, name, this.peek()));
                }
                if (this.suppressDepth == 0) {
                    this.suppressDepth = 1;
                }
            }
            this.memo = next;
        }
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            Name attName = new Name(atts.getURI(i), atts.getLocalName(i));
            String value = atts.getValue(i);
            this.datatypeErrors.clear();
            if (!this.setMemo(this.memo.startAttributeDeriv(attName))) {
                this.error(new ImpossibleAttributeIgnoredException(this.locator, name, this.peek(), attName));
                continue;
            }
            if (this.setMemo(this.memo.dataDeriv(value, this))) continue;
            this.error(new BadAttributeValueException(this.locator, name, this.peek(), attName, value, this.datatypeErrors));
            this.memo = this.memo.recoverAfter();
        }
        if (!this.setMemo(this.memo.endAttributes())) {
            this.error(new RequiredAttributesMissingException(this.locator, name, this.peek()));
            this.memo = this.memo.ignoreMissingAttributes();
        }
        if (this.memo.getPattern().getContentType() == 3) {
            this.startCollectingCharacters();
        }
        this.push(name);
    }

    private PatternMemo fixAfter(PatternMemo p) {
        return this.builder.getPatternMemo(p.getPattern().applyForPattern(new ApplyAfterFunction(this.builder){

            Pattern apply(Pattern p) {
                return PatternValidator.this.builder.makeEmpty();
            }
        }));
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Name name = this.pop();
        if (this.collectingCharacters) {
            this.collectingCharacters = false;
            if (!this.setMemo(this.memo.textOnly())) {
                this.error(new OnlyTextNotAllowedException(this.locator, name, this.peek()));
                this.memo = this.memo.recoverAfter();
                return;
            }
            String data = this.charBuf.toString();
            if (!this.setMemo(this.memo.dataDeriv(data, this))) {
                PatternMemo next = this.memo.recoverAfter();
                this.datatypeErrors.clear();
                if (!(this.memo.isNotAllowed() || next.isNotAllowed() && !this.fixAfter(this.memo).dataDeriv(data, this).isNotAllowed())) {
                    this.error(new StringNotAllowedException(this.locator, name, this.peek(), data, this.datatypeErrors));
                }
                this.memo = next;
            }
        } else if (!this.setMemo(this.memo.endTagDeriv())) {
            PatternMemo next = this.memo.recoverAfter();
            if (!(this.memo.isNotAllowed() || next.isNotAllowed() && !this.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
                this.error(new UnfinishedElementException(this.locator, name, this.peek()));
            }
            this.memo = next;
        }
        if (this.suppressDepth > 0) {
            --this.suppressDepth;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectingCharacters) {
            this.charBuf.append(ch, start, length);
            return;
        }
        block3: for (int i = 0; i < length; ++i) {
            switch (ch[start + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.text();
                    return;
                }
            }
        }
    }

    private void text() throws SAXException {
        if (!this.setMemo(this.memo.mixedTextDeriv())) {
            this.error(new TextNotAllowedException(this.locator, this.peek()));
        }
    }

    public void endDocument() {
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    public void startDocument() throws SAXException {
        this.stack = new Name[48];
        this.stackLen = 0;
        this.suppressDepth = 0;
        if (this.memo.isNotAllowed()) {
            this.error("schema_allows_nothing");
        }
    }

    public void processingInstruction(String target, String date) {
    }

    public void skippedEntity(String name) {
    }

    public void ignorableWhitespace(char[] ch, int start, int len) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMapping = new PrefixMapping(prefix, uri, this.prefixMapping);
    }

    public void endPrefixMapping(String prefix) {
        this.prefixMapping = this.prefixMapping.getPrevious();
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder builder, ErrorHandler eh) {
        this.start = pattern;
        this.builder = builder;
        this.eh = eh;
        this.reset();
    }

    public void reset() {
        this.hadError = false;
        this.collectingCharacters = false;
        this.locator = null;
        this.memo = this.builder.getPatternMemo(this.start);
        this.prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
        this.clearDtdContext();
        this.charBuf.setLength(0);
        this.datatypeErrors.clear();
        this.stack = null;
        this.recoverPatternTable = null;
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    private void error(String key) throws SAXException {
        if (this.suppressDepth > 0 || this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key), this.locator));
    }

    private void error(SAXParseException e) throws SAXException {
        if (this.suppressDepth > 0 || this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(e);
    }

    private boolean setMemo(PatternMemo m) {
        if (m.isNotAllowed()) {
            return false;
        }
        this.memo = m;
        return true;
    }

    private Pattern findElement(Name name) {
        Pattern p;
        if (this.recoverPatternTable == null) {
            this.recoverPatternTable = new HashMap();
        }
        if ((p = (Pattern)this.recoverPatternTable.get(name)) == null) {
            p = FindElementFunction.findElement(this.builder, name, this.start);
            this.recoverPatternTable.put(name, p);
        }
        return p;
    }

    public String resolveNamespacePrefix(String prefix) {
        PrefixMapping tem = this.prefixMapping;
        do {
            if (!tem.prefix.equals(prefix)) continue;
            return tem.namespaceURI;
        } while ((tem = tem.previous) != null);
        return null;
    }

    public String getBaseUri() {
        return null;
    }

    public final void addDatatypeError(String message, DatatypeException exception) {
        this.datatypeErrors.put(message, exception);
    }

    private final void push(Name name) {
        if (this.stackLen == this.stack.length) {
            Name[] newStack = new Name[this.stackLen + (this.stackLen >> 1)];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackLen);
            this.stack = newStack;
        }
        this.stack[this.stackLen] = name;
        ++this.stackLen;
    }

    private final Name pop() {
        --this.stackLen;
        return this.stack[this.stackLen];
    }

    private final Name peek() {
        if (this.stackLen == 0) {
            return null;
        }
        return this.stack[this.stackLen - 1];
    }

    public Locator getLocator() {
        return this.locator;
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String namespaceURI;
        private final PrefixMapping previous;

        PrefixMapping(String prefix, String namespaceURI, PrefixMapping prev) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
            this.previous = prev;
        }

        PrefixMapping getPrevious() {
            return this.previous;
        }
    }
}

