/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.RecentIssue;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class BugtrackingManager
implements LookupListener {
    private static final BugtrackingManager instance = new BugtrackingManager();
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugracking.BugtrackingManager");
    private RequestProcessor rp = new RequestProcessor("Bugtracking manager");
    private final Collection<BugtrackingConnector> connectors = new ArrayList<BugtrackingConnector>(2);
    private Lookup.Result<BugtrackingConnector> connectorsLookup;
    private Map<String, List<RecentIssue>> recentIssues;
    private KenaiAccessor kenaiAccessor;

    public static BugtrackingManager getInstance() {
        return instance;
    }

    private BugtrackingManager() {
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)new ActivatedTCListener());
    }

    public Repository[] getKnownRepositories(boolean pingOpenProjects) {
        Repository[] kenaiRepos = KenaiUtil.getRepositories(pingOpenProjects);
        Repository[] otherRepos = this.getRepositories();
        Repository[] ret = new Repository[kenaiRepos.length + otherRepos.length];
        System.arraycopy(kenaiRepos, 0, ret, 0, kenaiRepos.length);
        System.arraycopy(otherRepos, 0, ret, kenaiRepos.length, otherRepos.length);
        return ret;
    }

    public Repository[] getRepositories() {
        BugtrackingConnector[] conns;
        ArrayList<Repository> repos = new ArrayList<Repository>(10);
        for (BugtrackingConnector bc : conns = this.getConnectors()) {
            Repository[] rs = bc.getRepositories();
            if (rs == null) continue;
            repos.addAll(Arrays.asList(rs));
        }
        return repos.toArray(new Repository[repos.size()]);
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugtrackingConnector[] getConnectors() {
        Collection<BugtrackingConnector> collection = this.connectors;
        synchronized (collection) {
            if (this.connectorsLookup == null) {
                this.refreshConnectors();
            }
            return this.connectors.toArray(new BugtrackingConnector[this.connectors.size()]);
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshConnectors();
    }

    public List<Issue> getRecentIssues(Repository repo) {
        assert (repo != null);
        List<RecentIssue> l = this.getRecentIssues().get(repo.getID());
        if (l == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Issue> ret = new ArrayList<Issue>(l.size());
        for (RecentIssue recentIssue : l) {
            ret.add(recentIssue.getIssue());
        }
        return ret;
    }

    public void addRecentIssue(Repository repo, Issue issue) {
        assert (repo != null && issue != null);
        if (issue.getID() == null) {
            return;
        }
        List<RecentIssue> l = this.getRecentIssues().get(repo.getID());
        if (l == null) {
            l = new LinkedList<RecentIssue>();
            this.getRecentIssues().put(repo.getID(), l);
        }
        for (RecentIssue i : l) {
            if (!i.getIssue().getID().equals(issue.getID())) continue;
            l.remove(i);
            break;
        }
        l.add(0, new RecentIssue(issue, System.currentTimeMillis()));
        if (LOG.isLoggable(Level.FINE)) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (RecentIssue ri : l) {
                LOG.log(Level.FINE, "recent issue: [{0}, {1}, {2}]", new Object[]{ri.getIssue().getRepository().getDisplayName(), ri.getIssue().getID(), f.format(new Date(ri.getTimestamp()))});
            }
        }
    }

    public Map<String, List<RecentIssue>> getAllRecentIssues() {
        return Collections.unmodifiableMap(this.getRecentIssues());
    }

    public KenaiAccessor getKenaiAccessor() {
        if (this.kenaiAccessor == null) {
            this.kenaiAccessor = (KenaiAccessor)Lookup.getDefault().lookup(KenaiAccessor.class);
        }
        return this.kenaiAccessor;
    }

    private Map<String, List<RecentIssue>> getRecentIssues() {
        if (this.recentIssues == null) {
            this.recentIssues = new HashMap<String, List<RecentIssue>>();
        }
        return this.recentIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConnectors() {
        Collection<BugtrackingConnector> collection = this.connectors;
        synchronized (collection) {
            if (this.connectorsLookup == null) {
                this.connectorsLookup = Lookup.getDefault().lookup(new Lookup.Template(BugtrackingConnector.class));
                this.connectorsLookup.addLookupListener((LookupListener)this);
            }
            Collection conns = this.connectorsLookup.allInstances();
            if (LOG.isLoggable(Level.FINER)) {
                for (BugtrackingConnector repository : conns) {
                    LOG.log(Level.FINER, "registered provider: {0}", repository.getDisplayName());
                }
            }
            this.connectors.clear();
            this.connectors.addAll(conns);
        }
    }

    private class ActivatedTCListener
    implements PropertyChangeListener {
        private ActivatedTCListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
            if ("activated".equals(evt.getPropertyName())) {
                TopComponent tc = registry.getActivated();
                LOG.log(Level.FINER, "activated TC : {0}", tc);
                if (!(tc instanceof IssueTopComponent)) {
                    return;
                }
                IssueTopComponent itc = (IssueTopComponent)tc;
                Issue issue = itc.getIssue();
                LOG.log(Level.FINE, "activated issue : {0}", issue);
                if (issue == null || issue.isNew()) {
                    return;
                }
                BugtrackingManager.this.addRecentIssue(issue.getRepository(), issue);
            }
        }
    }
}

