/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.libs.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.DLightLibsCommonLogger;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;

public class InvalidFileObjectSupport {
    private final FileSystem fileSystem;
    private final WeakSet<FileObject> fileObjects = new WeakSet();
    private static final Map<FileSystem, InvalidFileObjectSupport> instances = new WeakHashMap<FileSystem, InvalidFileObjectSupport>();
    private static final DummyFileSystem dummyFileSystem = new DummyFileSystem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject getInvalidFileObject(FileSystem fileSystem, CharSequence path) {
        InvalidFileObjectSupport instance;
        Map<FileSystem, InvalidFileObjectSupport> map = instances;
        synchronized (map) {
            instance = instances.get(fileSystem);
            if (instance == null) {
                instance = new InvalidFileObjectSupport(fileSystem);
                instances.put(fileSystem, instance);
            }
        }
        return instance.getInvalidFileObject(path);
    }

    public static FileObject getInvalidFileObject(File file) {
        return InvalidFileObjectSupport.getInvalidFileObject(InvalidFileObjectSupport.getFileSystem(file), file.getAbsolutePath());
    }

    private static FileSystem getFileSystem(File file) {
        FileObject fo = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
        if (fo != null) {
            try {
                return fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return InvalidFileObjectSupport.getDummyFileSystem();
            }
        }
        return InvalidFileObjectSupport.getDummyFileSystem();
    }

    public static FileSystem getDummyFileSystem() {
        return dummyFileSystem;
    }

    private InvalidFileObjectSupport(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getInvalidFileObject(CharSequence path) {
        InvalidFileObjectSupport invalidFileObjectSupport = this;
        synchronized (invalidFileObjectSupport) {
            if (DLightLibsCommonLogger.isDebugMode() && new File(((Object)path).toString()).exists()) {
                DLightLibsCommonLogger.getInstance().log(Level.INFO, "Creating an invalid file object for existing file {0}", path);
            }
            FileObject fo = (FileObject)this.fileObjects.putIfAbsent((Object)new InvalidFileObject(this.fileSystem, path));
            return fo;
        }
    }

    private static class InvalidFileObject
    extends FileObject {
        private final FileSystem fileSystem;
        private final String path;
        private static Date lastModifiedDate = new Date();

        public InvalidFileObject(FileSystem fileSystem, CharSequence path) {
            this.fileSystem = fileSystem == null ? dummyFileSystem : fileSystem;
            this.path = ((Object)path).toString();
        }

        public String getPath() {
            return this.path;
        }

        private String fileNotFoundExceptionMessage() {
            return "File not found: " + this.path;
        }

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public FileObject createFolder(String name) throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public void delete(FileLock lock) throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public Object getAttribute(String attrName) {
            return null;
        }

        public Enumeration<String> getAttributes() {
            return Collections.enumeration(Collections.emptyList());
        }

        public FileObject[] getChildren() {
            return new FileObject[0];
        }

        public String getExt() {
            int pos = this.path.lastIndexOf(46);
            if (pos == 0 || pos == -1) {
                return "";
            }
            return ((Object)this.path.subSequence(pos + 1, this.path.length())).toString();
        }

        public FileObject getFileObject(String name, String ext) {
            return null;
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileSystem;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public String getName() {
            String nameExt = this.getNameExt();
            int pos = nameExt.lastIndexOf(46);
            if (pos == 0 || pos == -1) {
                return nameExt;
            }
            return nameExt.substring(0, pos);
        }

        public String getNameExt() {
            return PathUtilities.getBaseName(this.path.toString());
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public FileObject getParent() {
            if (this.path.length() > 0) {
                if (this.isRoot()) {
                    return null;
                }
                String parentPath = PathUtilities.getDirName(this.path);
                if (parentPath == null) {
                    return null;
                }
                return InvalidFileObjectSupport.getInvalidFileObject(this.fileSystem, parentPath);
            }
            return null;
        }

        public long getSize() {
            return 0L;
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        @Deprecated
        public boolean isReadOnly() {
            return true;
        }

        public boolean isRoot() {
            return this.path.length() == 0;
        }

        public boolean isValid() {
            return false;
        }

        public Date lastModified() {
            return lastModifiedDate;
        }

        public FileLock lock() throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new FileNotFoundException(this.fileNotFoundExceptionMessage());
        }

        @Deprecated
        public void setImportant(boolean b) {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            InvalidFileObject other = (InvalidFileObject)((Object)obj);
            if (!(this.fileSystem == other.fileSystem || this.fileSystem != null && this.fileSystem.equals(other.fileSystem))) {
                return false;
            }
            return this.path == other.path || this.path != null && this.path.equals(other.path);
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.fileSystem != null ? this.fileSystem.hashCode() : 0);
            hash = 11 * hash + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }
    }

    private static class DummyFileSystem
    extends FileSystem {
        private DummyFileSystem() {
        }

        public FileObject findResource(String name) {
            return InvalidFileObjectSupport.getInvalidFileObject(this, name);
        }

        public SystemAction[] getActions() {
            return new SystemAction[0];
        }

        public String getDisplayName() {
            return "Dummy";
        }

        public FileObject getRoot() {
            return InvalidFileObjectSupport.getInvalidFileObject(this, "");
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

