/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerDisplay;
import org.netbeans.modules.apisupport.project.ui.customizer.EditClusterPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.netbeans.swing.outline.Outline;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public final class SuiteCustomizerLibraries
extends NbPropertyPanel.Suite
implements ExplorerManager.Provider,
ChangeListener {
    private final ExplorerManager manager;
    private ModuleEntry[] platformModules;
    Set<ModuleEntry> extraBinaryModules = new HashSet<ModuleEntry>();
    static boolean TEST = false;
    private LibrariesChildren libChildren;
    private boolean extClustersLoaded;
    private AbstractNode realRoot;
    private AbstractNode waitRoot;
    public static final String WAIT_ICON_PATH = "org/netbeans/modules/apisupport/project/suite/resources/wait.png";
    private RequestProcessor.Task refreshTask;
    private JButton addClusterButton;
    private JButton addProjectButton;
    private JButton editButton;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel platform;
    private JComboBox platformValue;
    private JButton removeButton;
    private JButton resolveButton;
    private OutlineView view;
    private JLabel viewLabel;
    private static final Comparator<Node> MODULES_COMPARATOR = new Comparator<Node>(){
        Collator COLL = Collator.getInstance();

        @Override
        public int compare(Node n1, Node n2) {
            return this.COLL.compare(n1.getDisplayName(), n2.getDisplayName());
        }
    };
    public static final Set<String> DISABLED_PLATFORM_MODULES = new TreeSet<String>();
    private static final SystemAction[] NO_ACTIONS;
    private static final EnabledProp ENABLED_PROP_TEMPLATE;
    private static final OriginProp ORIGIN_PROP_TEMPLATE;
    private RequestProcessor.Task updateDependencyWarningsTask;
    private RequestProcessor RP = new RequestProcessor(SuiteCustomizerLibraries.class.getName(), 1);
    private static final Comparator<UniverseModule> UNIVERSE_MODULE_COMPARATOR;
    private Set<UniverseModule> universe;
    private final Object lock = new Object();
    private FixInfo resolveFixInfo;

    public SuiteCustomizerLibraries(SuiteProperties suiteProps, ProjectCustomizer.Category cat) {
        super(suiteProps, SuiteCustomizerLibraries.class, cat);
        this.initComponents();
        this.resolveButton.setVisible(false);
        this.manager = new ExplorerManager();
        this.waitRoot = new AbstractNode((Children)new Children.Array(){

            protected Collection<Node> initCollection() {
                return Collections.singleton(new WaitNode());
            }
        });
        this.waitRoot.setName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClusters"));
        this.waitRoot.setDisplayName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClustersModules"));
        this.manager.setRootContext((Node)this.waitRoot);
        this.refresh();
        this.view.setProperties(new Node.Property[]{ENABLED_PROP_TEMPLATE, ORIGIN_PROP_TEMPLATE});
        Outline outline = this.view.getOutline();
        outline.setRootVisible(false);
        outline.setSelectionMode(0);
        TableColumn col = outline.getColumnModel().getColumn(1);
        col.setMinWidth(25);
        col.setMaxWidth(200);
        col.setPreferredWidth(70);
        col = outline.getColumnModel().getColumn(2);
        col.setMinWidth(25);
        col.setMaxWidth(300);
        col.setPreferredWidth(130);
        suiteProps.getBrandingModel().addChangeListener(this);
        suiteProps.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("nbPlatform".equals(evt.getPropertyName())) {
                    SuiteCustomizerLibraries.this.refresh();
                }
            }
        });
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] nodes = (Node[])evt.getNewValue();
                    SuiteCustomizerLibraries.this.updateButtons(nodes);
                }
            }
        });
        this.updateButtons(this.manager.getSelectedNodes());
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProjectCluster(ClusterInfo ci, boolean showMessages) throws MissingResourceException, IllegalArgumentException {
        ClusterNode cnode;
        Project project = ci.getProject();
        assert (project != null);
        SuiteProject thisPrj = this.getProperties().getProject();
        if (thisPrj.getProjectDirectory().equals(project.getProjectDirectory())) {
            if (showMessages) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_TryingToAddMyself", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
            return;
        }
        if (this.libChildren.findCluster(ci.getClusterDir()) != null) {
            if (showMessages) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_AlreadyOnClusterPath", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            }
            return;
        }
        this.initNodes();
        NbModuleProvider nmtp = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (nmtp != null) {
            assert (nmtp.getModuleType() == NbModuleProvider.STANDALONE);
            cnode = new ClusterNode(ci, Children.LEAF);
        } else {
            SuiteProvider sprv = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
            assert (sprv != null);
            cnode = this.createSuiteNode(ci);
        }
        List list = this.libChildren.extraNodes;
        synchronized (list) {
            this.libChildren.extraNodes.add(cnode);
        }
        this.libChildren.setMergedKeys();
    }

    private boolean isExternalCluster(Enabled en) {
        return !en.isLeaf() && en.getProject() == null && !en.isPlatformNode();
    }

    private void updateButtons(Node[] nodes) {
        boolean canRemove = nodes.length > 0;
        boolean canEdit = nodes.length == 1;
        for (Node node : nodes) {
            if (!(node instanceof Enabled)) {
                canEdit = false;
                canRemove = false;
                break;
            }
            Enabled en = (Enabled)node;
            canRemove &= en instanceof ClusterNode && !en.isPlatformNode();
            canEdit &= this.isExternalCluster(en);
        }
        this.removeButton.setEnabled(canRemove);
        this.editButton.setEnabled(canEdit);
    }

    @Override
    protected void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        if (this.refreshTask == null) {
            this.refreshTask = this.RP.create(new Runnable(){

                @Override
                public void run() {
                    SuiteCustomizerLibraries.this.refreshModules();
                    SuiteCustomizerLibraries.this.updateDependencyWarnings(true);
                }
            });
        }
        if (TEST) {
            this.refreshTask.run();
        } else {
            this.refreshTask.schedule(0);
        }
        this.updateJavaPlatformEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtCluster(ClusterInfo ci) {
        HashSet<String> disabledModuleCNB = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledModules()));
        Children.SortedArray moduleCh = new Children.SortedArray();
        try {
            ModuleList ml = ModuleList.scanCluster(ci.getClusterDir(), null, false, ci);
            moduleCh.setComparator(MODULES_COMPARATOR);
            for (ModuleEntry entry : ml.getAllEntries()) {
                moduleCh.add(new Node[]{new BinaryModuleNode(entry, !disabledModuleCNB.contains(entry.getCodeNameBase()) && ci.isEnabled())});
                this.extraBinaryModules.add(entry);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        this.initNodes();
        List list = this.libChildren.extraNodes;
        synchronized (list) {
            this.libChildren.extraNodes.add(new ClusterNode(ci, (Children)moduleCh));
        }
        this.libChildren.setMergedKeys();
    }

    private ClusterNode createSuiteNode(ClusterInfo ci) {
        assert (ci.getProject() != null);
        assert (ci.getProject().getLookup().lookup(SuiteProvider.class) != null);
        HashSet<String> disabledModuleCNB = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledModules()));
        Children.SortedArray moduleCh = new Children.SortedArray();
        moduleCh.setComparator(MODULES_COMPARATOR);
        Set<NbModuleProject> modules = SuiteUtils.getSubProjects(ci.getProject());
        for (NbModuleProject modPrj : modules) {
            NbModuleProvider nbmp = (NbModuleProvider)modPrj.getLookup().lookup(NbModuleProvider.class);
            if (nbmp == null || nbmp.getModuleType() != NbModuleProvider.SUITE_COMPONENT) continue;
            moduleCh.add(new Node[]{new SuiteComponentNode(modPrj, nbmp, !disabledModuleCNB.contains(modPrj.getCodeNameBase()) && ci.isEnabled())});
        }
        return new ClusterNode(ci, (Children)moduleCh);
    }

    private void initNodes() {
        if (this.libChildren == null) {
            this.libChildren = new LibrariesChildren();
            this.realRoot = new AbstractNode((Children)this.libChildren);
            this.realRoot.setName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClusters"));
            this.realRoot.setDisplayName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClustersModules"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void refreshModules() {
        void var7_11;
        this.platformModules = this.getProperties().getActivePlatform().getSortedModules();
        this.initNodes();
        HashSet<String> disabledModuleCNB = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledModules()));
        HashSet<String> enabledClusters = new HashSet<String>(Arrays.asList(this.getProperties().getEnabledClusters()));
        HashMap<File, ClusterNode> clusterToNode = new HashMap<File, ClusterNode>();
        SortedSet sortedSet = this.libChildren.platformNodes;
        synchronized (sortedSet) {
            this.libChildren.platformNodes.clear();
        }
        boolean newPlaf = ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion().compareTo(HarnessVersion.V67) >= 0;
        ModuleEntry[] arr$ = this.platformModules;
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_11 < len$) {
            ModuleEntry platformModule = arr$[var7_11];
            File clusterDirectory = platformModule.getClusterDirectory();
            ClusterNode cluster = (ClusterNode)((Object)clusterToNode.get(clusterDirectory));
            if (cluster == null) {
                Children.SortedArray modules = new Children.SortedArray();
                modules.setComparator(MODULES_COMPARATOR);
                boolean enabled = newPlaf && enabledClusters.isEmpty() || SingleModuleProperties.clusterMatch(enabledClusters, clusterDirectory.getName());
                ClusterInfo ci = ClusterInfo.create(clusterDirectory, true, enabled);
                cluster = new ClusterNode(ci, (Children)modules);
                clusterToNode.put(clusterDirectory, cluster);
                SortedSet sortedSet2 = this.libChildren.platformNodes;
                synchronized (sortedSet2) {
                    this.libChildren.platformNodes.add(cluster);
                }
            }
            BinaryModuleNode module = new BinaryModuleNode(platformModule, !disabledModuleCNB.contains(platformModule.getCodeNameBase()) && cluster.isEnabled());
            cluster.getChildren().add(new Node[]{module});
            ++var7_11;
        }
        Set<ClusterInfo> clusterPath = this.getProperties().getClusterPath();
        if (clusterPath.size() > 0) {
            for (ClusterNode clusterNode : this.libChildren.platformNodes()) {
                if (clusterPath.contains(clusterNode.getClusterInfo())) continue;
                clusterNode.setEnabled(false);
            }
            if (!this.extClustersLoaded) {
                for (ClusterInfo clusterInfo : clusterPath) {
                    if (clusterInfo.isPlatformCluster()) continue;
                    if (clusterInfo.getProject() != null) {
                        this.addProjectCluster(clusterInfo, false);
                        continue;
                    }
                    this.addExtCluster(clusterInfo);
                }
                this.extClustersLoaded = true;
            }
        } else {
            this.extClustersLoaded = true;
        }
        this.libChildren.setMergedKeys();
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        Logger logger = Logger.getLogger(SuiteCustomizerLibraries.class.getName());
        NbPlatform plaf = this.getProperties().getActivePlatform();
        if (plaf == null) {
            return;
        }
        logger.log(Level.FINE, "refreshPlatforms --> {0}", plaf.getLabel());
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel(plaf));
        this.platformValue.requestFocus();
    }

    @Override
    public void store() {
        Enabled m;
        boolean oldPlaf;
        TreeSet<String> enabledClusters = new TreeSet<String>();
        TreeSet<String> disabledModules = new TreeSet<String>();
        ArrayList<ClusterInfo> clusterPath = new ArrayList<ClusterInfo>();
        boolean bl = oldPlaf = this.getProperties().getActivePlatform().getHarnessVersion().compareTo(HarnessVersion.V67) < 0;
        assert (this.refreshTask != null);
        if (!this.refreshTask.isFinished()) {
            return;
        }
        for (ClusterNode clusterNode : this.libChildren.platformNodes()) {
            if (!clusterNode.isEnabled()) continue;
            if (oldPlaf) {
                enabledClusters.add(clusterNode.getName());
            } else {
                clusterPath.add(clusterNode.getClusterInfo());
            }
            for (Node module : clusterNode.getChildren().getNodes()) {
                m = (Enabled)module;
                if (m.isEnabled()) continue;
                disabledModules.add(m.getName());
            }
        }
        if (oldPlaf) {
            this.getProperties().setEnabledClusters(enabledClusters.toArray(new String[enabledClusters.size()]));
        } else {
            for (ClusterNode clusterNode : this.libChildren.extraNodes()) {
                clusterPath.add(clusterNode.getClusterInfo());
                if (!clusterNode.isEnabled()) continue;
                for (Node module : clusterNode.getChildren().getNodes()) {
                    m = (Enabled)module;
                    if (m.isEnabled()) continue;
                    disabledModules.add(m.getName());
                }
            }
            this.getProperties().setClusterPath(clusterPath);
        }
        this.getProperties().setDisabledModules(disabledModules.toArray(new String[disabledModules.size()]));
    }

    private void initComponents() {
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.platform = new JLabel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.managePlafsButton = new JButton();
        this.viewLabel = new JLabel();
        this.view = new OutlineView();
        this.resolveButton = new JButton();
        this.addProjectButton = new JButton();
        this.addClusterButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_Java_Platform"));
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SuiteCustomizerLibraries.this.javaPlatformComboItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.javaPlatformButtonActionPerformed(evt);
            }
        });
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        this.platformValue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SuiteCustomizerLibraries.this.platformValueItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"CTL_ManagePlatform_a"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.managePlatforms(evt);
            }
        });
        this.viewLabel.setLabelFor((Component)this.view);
        Mnemonics.setLocalizedText((JLabel)this.viewLabel, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_PlatformModules"));
        this.view.setBorder(UIManager.getBorder("ScrollPane.border"));
        this.resolveButton.setForeground(Color.red);
        Mnemonics.setLocalizedText((AbstractButton)this.resolveButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_ResolveButton"));
        this.resolveButton.setToolTipText(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_ResolveButtonTooltip"));
        this.resolveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.resolveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addProjectButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_AddProject"));
        this.addProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.addProjectButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addClusterButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"LBL_AddCluster"));
        this.addClusterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.addClusterButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.editButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaPlatformLabel).addComponent(this.platform)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaPlatformCombo, GroupLayout.Alignment.TRAILING, 0, 259, Short.MAX_VALUE).addComponent(this.platformValue, GroupLayout.Alignment.TRAILING, 0, 259, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.managePlafsButton, -1, -1, Short.MAX_VALUE).addComponent(this.javaPlatformButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(74, Short.MAX_VALUE).addComponent(this.resolveButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addProjectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addClusterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton)).addGroup(layout.createSequentialGroup().addComponent(this.viewLabel).addContainerGap()).addComponent((Component)this.view, -1, 626, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaPlatformLabel).addComponent(this.javaPlatformCombo, -2, -1, -2).addComponent(this.javaPlatformButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.platform).addComponent(this.platformValue, -2, -1, -2).addComponent(this.managePlafsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.viewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.view, -1, 425, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editButton).addComponent(this.removeButton).addComponent(this.addClusterButton).addComponent(this.addProjectButton).addComponent(this.resolveButton))));
        this.javaPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"ACSD_JavaPlatformLbl"));
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"ACSD_JavaPlatformCombo"));
        this.javaPlatformButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"ACSD_JavaPlatformButton"));
        this.platform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"ACSD_PlatformLbl"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"ACSD_PlatformValue"));
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"ACSD_ManagePlafsButton"));
    }

    private void javaPlatformButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
    }

    private void javaPlatformComboItemStateChanged(ItemEvent evt) {
        this.getProperties().setActiveJavaPlatform((JavaPlatform)this.javaPlatformCombo.getSelectedItem());
    }

    private void platformValueItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.manager.setRootContext((Node)this.waitRoot);
            this.store();
            Logger logger = Logger.getLogger(SuiteCustomizerLibraries.class.getName());
            logger.log(Level.FINE, "platformValueItemStateChanged, setting plaf -->" + ((NbPlatform)this.platformValue.getSelectedItem()).getLabel());
            this.getProperties().setActivePlatform((NbPlatform)this.platformValue.getSelectedItem());
            this.updateJavaPlatformEnabled();
        }
    }

    private void managePlatforms(ActionEvent evt) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private void addProjectButtonActionPerformed(ActionEvent evt) {
        Project project = UIUtil.chooseProject(this);
        if (project != null) {
            ClusterInfo.QueryResult res = ClusterInfo.canCreate(project);
            String bundleKey = null;
            switch (res) {
                case NOT_A_NBM_PROJECT: {
                    bundleKey = "MSG_TryingToAddNonNBModuleOnClusterPath";
                    break;
                }
                case NBORG_PROJECT_NOT_ALLOWED: {
                    bundleKey = "MSG_TryingToAddNBORGModuleOnClusterPath";
                    break;
                }
                case SUITE_COMP_NOT_ALLOWED: {
                    SuiteProvider sprv = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
                    FileObject otherSuiteDir = FileUtil.toFileObject((File)sprv.getSuiteDirectory());
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_AddSuiteInstead", (Object)ProjectUtils.getInformation((Project)project).getDisplayName(), (Object)Util.getDisplayName(otherSuiteDir)), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() == NotifyDescriptor.YES_OPTION) {
                        try {
                            project = ProjectManager.getDefault().findProject(otherSuiteDir);
                            assert (ClusterInfo.canCreate(project) == ClusterInfo.QueryResult.OK);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(16, (Throwable)e);
                        }
                        break;
                    }
                    return;
                }
            }
            if (bundleKey != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)bundleKey, (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
            } else {
                this.addProjectCluster(ClusterInfo.create(project, true), true);
            }
        }
    }

    private void addClusterButtonActionPerformed(ActionEvent evt) {
        ClusterInfo ci = EditClusterPanel.showAddDialog(this.getProperties().getProject());
        if (ci != null) {
            if (this.libChildren.findCluster(ci.getClusterDir()) != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_ClusterAlreadyOnClusterPath", (Object)ci.getClusterDir())));
                return;
            }
            this.addExtCluster(ci);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.libChildren.removeClusters(this.manager.getSelectedNodes());
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.manager.getSelectedNodes();
        assert (nodes.length == 1);
        ClusterNode node = (ClusterNode)nodes[0];
        assert (this.isExternalCluster(node));
        ClusterInfo ci = EditClusterPanel.showEditDialog(node.getClusterInfo(), this.getProperties().getProject());
        if (ci != null) {
            node.setClusterInfo(ci);
        }
    }

    private void resolveButtonActionPerformed(ActionEvent evt) {
        if (this.resolveFixInfo == null || !this.resolveFixInfo.fixable) {
            return;
        }
        for (Node node : this.libChildren.getNodes()) {
            NbModuleProvider nbmp;
            ClusterNode cn = (ClusterNode)node;
            for (Node modNode : cn.getChildren().getNodes()) {
                String cnb = modNode.getName();
                if (!this.resolveFixInfo.toAdd.contains(cnb)) continue;
                Enabled en = (Enabled)modNode;
                en.setState(EnabledState.FULL_ENABLED, false);
            }
            if (cn.getProject() == null || (nbmp = (NbModuleProvider)cn.getProject().getLookup().lookup(NbModuleProvider.class)) == null || nbmp.getModuleType() != NbModuleProvider.STANDALONE || !this.resolveFixInfo.toAdd.contains(nbmp.getCodeNameBase())) continue;
            assert (!cn.isEnabled());
            ((Enabled)cn).setState(EnabledState.FULL_ENABLED, false);
        }
        this.libChildren.setMergedKeys();
        this.resolveButton.setEnabled(false);
        this.updateDependencyWarnings(false);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        if (this.getProperties().getBrandingModel().isBrandingEnabled()) {
            Enabled m;
            Enabled e;
            Node[] clusters;
            for (Node cluster : clusters = this.getExplorerManager().getRootContext().getChildren().getNodes()) {
                if (!(cluster instanceof Enabled)) continue;
                e = (Enabled)cluster;
                if (!e.isEnabled()) {
                    return;
                }
                for (Node module : e.getChildren().getNodes()) {
                    if (!(module instanceof Enabled) || (m = (Enabled)module).isEnabled()) continue;
                    return;
                }
            }
            if (!UIUtil.showAcceptCancelDialog(SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.title.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.text.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.exclude"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.skip"), 3)) {
                return;
            }
            for (Node cluster : clusters) {
                if (!(cluster instanceof Enabled)) continue;
                e = (Enabled)cluster;
                if (e.getName().startsWith("platform")) {
                    for (Node module : e.getChildren().getNodes()) {
                        if (!(module instanceof Enabled) || !DISABLED_PLATFORM_MODULES.contains((m = (Enabled)module).getName())) continue;
                        m.setEnabled(false);
                    }
                    continue;
                }
                e.setEnabled(false);
            }
        }
    }

    private String formatEntryDesc(String cnb, @NullAllowed String desc) throws MissingResourceException {
        String tooltip = desc != null ? (desc.startsWith("<html>") ? "<html>" + NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)cnb, (Object)desc.substring(6)) : NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)cnb, (Object)desc)) : NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"SuiteCustomizerLibraries.HINT_module_no_desc", (Object)cnb);
        return tooltip;
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(CustomizerDisplay.class, (String)key);
    }

    private void updateDependencyWarnings(final boolean refreshUniverse) {
        if (TEST || !this.extClustersLoaded) {
            return;
        }
        if (this.updateDependencyWarningsTask == null) {
            this.updateDependencyWarningsTask = this.RP.create(new Runnable(){

                @Override
                public void run() {
                    if (refreshUniverse) {
                        SuiteCustomizerLibraries.this.universe = null;
                    }
                    SuiteCustomizerLibraries.this.doUpdateDependencyWarnings();
                }
            });
        }
        this.updateDependencyWarningsTask.schedule(0);
    }

    static Set<UniverseModule> loadUniverseModules(ModuleEntry[] platformModules, Set<NbModuleProject> suiteModules, Set<ModuleEntry> extraBinaryModules) throws IOException {
        LinkedHashSet<UniverseModule> universeModules = new LinkedHashSet<UniverseModule>();
        for (NbModuleProject p : suiteModules) {
            universeModules.add(new SuiteModule(p));
        }
        for (ModuleEntry e : platformModules) {
            universeModules.add(new PlatformModule(e));
        }
        for (ModuleEntry e : extraBinaryModules) {
            universeModules.add(new PlatformModule(e));
        }
        return universeModules;
    }

    FixInfo findWarning(Set<UniverseModule> universeModules, Set<File> enabledClusters, Set<String> disabledModules) {
        TreeMap<String, UniverseModule> sortedModules = new TreeMap<String, UniverseModule>();
        HashSet<UniverseModule> excluded = new HashSet<UniverseModule>();
        HashMap<String, Set<UniverseModule>> providers = new HashMap<String, Set<UniverseModule>>();
        for (UniverseModule m : universeModules) {
            String cnb = m.getCodeNameBase();
            File cluster = m.getCluster();
            assert (cluster != null);
            if (!enabledClusters.contains(cluster) || disabledModules.contains(cnb)) {
                excluded.add(m);
            }
            sortedModules.put(cnb, m);
            this.addProviders(m, providers);
        }
        FixInfo fixInfo = new FixInfo();
        Collection scannedModules = sortedModules.values();
        block1: while (true) {
            Iterator it = scannedModules.iterator();
            while (it.hasNext()) {
                UniverseModule m = (UniverseModule)it.next();
                if (excluded.contains(m)) continue;
                fixInfo.resetCurrentAdditions();
                boolean warningFound = this.findWarning(m, sortedModules, providers, excluded, fixInfo);
                if (!warningFound) continue;
                if (!fixInfo.fixable) {
                    return fixInfo;
                }
                if (fixInfo.isEmpty()) continue;
                assert (fixInfo.fixable);
                String additionCNB = (it.hasNext() ? (UniverseModule)it.next() : m).getCodeNameBase();
                scannedModules = sortedModules.tailMap(fixInfo.getRestartPointFor(additionCNB)).values();
                continue block1;
            }
            break;
        }
        return fixInfo;
    }

    private void addProviders(UniverseModule m, Map<String, Set<UniverseModule>> providers) {
        for (String tok : m.getProvidedTokens()) {
            Set<UniverseModule> providersOf = providers.get(tok);
            if (providersOf == null) {
                providersOf = new TreeSet<UniverseModule>(UNIVERSE_MODULE_COMPARATOR);
                providers.put(tok, providersOf);
            }
            providersOf.add(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateDependencyWarnings() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.universe == null) {
                    HashSet<NbModuleProject> suiteModules = new HashSet<NbModuleProject>(this.getProperties().getSubModules());
                    this.libChildren.getProjectModules(suiteModules);
                    this.universe = SuiteCustomizerLibraries.loadUniverseModules(this.platformModules, suiteModules, this.extraBinaryModules);
                }
                TreeSet<File> enabledClusters = new TreeSet<File>();
                TreeSet<String> disabledModules = new TreeSet<String>();
                enabledClusters.add(ClusterUtils.getClusterDirectory(this.getProperties().getProject()));
                for (Node cluster : this.libChildren.getNodes()) {
                    ClusterNode e;
                    if (!(cluster instanceof ClusterNode) || !(e = (ClusterNode)cluster).isEnabled()) continue;
                    enabledClusters.add(e.getClusterInfo().getClusterDir());
                    for (Node module : e.getChildren().getNodes()) {
                        Enabled m;
                        if (!(module instanceof Enabled) || (m = (Enabled)module).isEnabled()) continue;
                        disabledModules.add(m.getName());
                    }
                }
                final FixInfo fi = this.findWarning(this.universe, enabledClusters, disabledModules);
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (!fi.isEmpty()) {
                                String key = fi.warning[0];
                                Object[] args = new String[fi.warning.length - 1];
                                System.arraycopy(fi.warning, 1, args, 0, args.length);
                                SuiteCustomizerLibraries.this.category.setErrorMessage(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)key, (Object[])args));
                                SuiteCustomizerLibraries.this.resolveFixInfo = fi;
                                SuiteCustomizerLibraries.this.resolveButton.setEnabled(fi.fixable);
                                SuiteCustomizerLibraries.this.resolveButton.setVisible(true);
                            } else {
                                SuiteCustomizerLibraries.this.category.setErrorMessage(null);
                                SuiteCustomizerLibraries.this.resolveButton.setVisible(false);
                            }
                        }
                        finally {
                            SuiteCustomizerLibraries.this.manager.setRootContext((Node)SuiteCustomizerLibraries.this.realRoot);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Util.err.notify(1, (Throwable)e);
            this.category.setErrorMessage(NbBundle.getMessage(SuiteCustomizerLibraries.class, (String)"MSG_ErrorParsingMetadata", (Object)e.getLocalizedMessage()));
        }
    }

    private boolean findWarning(UniverseModule m, Map<String, UniverseModule> modules, Map<String, Set<UniverseModule>> providers, Set<UniverseModule> excluded, FixInfo fi) {
        TreeSet<Dependency> deps = new TreeSet<Dependency>(new Comparator<Dependency>(){

            @Override
            public int compare(Dependency d1, Dependency d2) {
                return d1.getName().compareTo(d2.getName());
            }
        });
        String mdn = m.getDisplayName();
        this.initNodes();
        ClusterNode node = this.libChildren.findCluster(m.getCluster());
        if (node == null) {
            return false;
        }
        String mc = node.getDisplayName();
        deps.addAll(m.getModuleDependencies());
        boolean ret = false;
        for (Dependency d : deps) {
            Object needed;
            int mrvHi;
            int mrvLo;
            String cnb;
            String codename = d.getName();
            int slash = codename.lastIndexOf(47);
            if (slash == -1) {
                cnb = codename;
                mrvLo = -1;
                mrvHi = -1;
            } else {
                cnb = codename.substring(0, slash);
                String mrv = codename.substring(slash + 1);
                int dash = mrv.lastIndexOf(45);
                if (dash == -1) {
                    mrvLo = mrvHi = Integer.parseInt(mrv);
                } else {
                    mrvLo = Integer.parseInt(mrv.substring(0, dash));
                    mrvHi = Integer.parseInt(mrv.substring(dash + 1));
                }
            }
            UniverseModule dep = modules.get(cnb);
            if (dep == null) {
                FixInfo.putUnfixable(fi, new String[]{"ERR_no_dep", mdn, mc, cnb});
                return true;
            }
            String ddn = dep.getDisplayName();
            if (excluded.contains(dep)) {
                node = this.libChildren.findCluster(dep.getCluster());
                if (node == null) {
                    return false;
                }
                String dc = node.getDisplayName();
                FixInfo.putFixable(fi, cnb, new String[]{"ERR_excluded_dep", mdn, mc, ddn, dc});
                excluded.remove(dep);
                ret = true;
            }
            if (dep.getReleaseVersion() < mrvLo || dep.getReleaseVersion() > mrvHi) {
                FixInfo.putUnfixable(fi, new String[]{"ERR_bad_dep_mrv", mdn, mc, ddn});
                return true;
            }
            if (d.getComparison() == 1) {
                needed = new SpecificationVersion(d.getVersion());
                SpecificationVersion found = dep.getSpecificationVersion();
                if (found != null && found.compareTo(needed) >= 0) continue;
                FixInfo.putUnfixable(fi, new String[]{"ERR_bad_dep_spec", mdn, mc, ddn});
                return true;
            }
            if (d.getComparison() != 2 || ((String)(needed = d.getVersion())).equals("*") || ((String)needed).equals(dep.getImplementationVersion())) continue;
            FixInfo.putUnfixable(fi, new String[]{"ERR_bad_dep_impl", mdn, mc, ddn});
            return true;
        }
        for (String tok : new TreeSet<String>(m.getRequiredTokens())) {
            UniverseModule wouldBeProvider = null;
            boolean found = false;
            Set<UniverseModule> possibleProviders = providers.get(tok);
            if (possibleProviders != null) {
                for (UniverseModule p : possibleProviders) {
                    if (excluded.contains(p)) {
                        if (wouldBeProvider != null) continue;
                        wouldBeProvider = p;
                        continue;
                    }
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (wouldBeProvider != null) {
                node = this.libChildren.findCluster(wouldBeProvider.getCluster());
                if (node == null) {
                    return false;
                }
                String[] msg = new String[]{"ERR_only_excluded_providers", tok, mdn, mc, wouldBeProvider.getDisplayName(), node.getDisplayName()};
                if (possibleProviders.size() == 1) {
                    excluded.remove(wouldBeProvider);
                    FixInfo.putFixable(fi, wouldBeProvider.getCodeNameBase(), msg);
                    ret = true;
                    continue;
                }
                FixInfo.putUnfixable(fi, msg);
                return true;
            }
            FixInfo.putUnfixable(fi, new String[]{"ERR_no_providers", tok, mdn, mc});
            return true;
        }
        return ret;
    }

    private void updateJavaPlatformEnabled() {
        boolean enabled = ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0;
        this.javaPlatformCombo.setEnabled(enabled);
        this.javaPlatformButton.setEnabled(enabled);
    }

    static /* synthetic */ Comparator access$2400() {
        return MODULES_COMPARATOR;
    }

    static {
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.autoupdate.services");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.autoupdate.ui");
        DISABLED_PLATFORM_MODULES.add("org.openide.execution");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.execution");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.multiview");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.favorites");
        DISABLED_PLATFORM_MODULES.add("org.openide.compat");
        DISABLED_PLATFORM_MODULES.add("org.openide.util.enumerations");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.core.kit");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.templates");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.libs.jsr223");
        DISABLED_PLATFORM_MODULES.add("org.jdesktop.layout");
        DISABLED_PLATFORM_MODULES.add("org.openide.options");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.api.visual");
        NO_ACTIONS = new SystemAction[0];
        ENABLED_PROP_TEMPLATE = new EnabledProp(null);
        ORIGIN_PROP_TEMPLATE = new OriginProp(null);
        UNIVERSE_MODULE_COMPARATOR = new Comparator<UniverseModule>(){
            Collator COLL = Collator.getInstance();

            @Override
            public int compare(UniverseModule m1, UniverseModule m2) {
                return this.COLL.compare(m1.getDisplayName(), m2.getDisplayName());
            }
        };
    }

    static class FixInfo {
        String[] warning;
        boolean fixable = true;
        Set<String> toAdd = new HashSet<String>();
        private SortedSet<String> currentAdditions = new TreeSet<String>();

        FixInfo() {
        }

        private static void putFixable(FixInfo fi, String cnb, String[] warning) {
            if (!fi.fixable) {
                throw new IllegalStateException("Cannot put fixable error on top of unfixable one.\\nExisting: " + Arrays.toString(fi.warning) + "\\nNew: " + Arrays.toString(warning));
            }
            if (fi.warning == null) {
                fi.warning = warning;
            }
            fi.toAdd.add(cnb);
            fi.currentAdditions.add(cnb);
        }

        private static void putUnfixable(FixInfo fi, String[] warning) {
            fi.fixable = false;
            if (fi.warning == null) {
                fi.warning = warning;
            }
        }

        private boolean isEmpty() {
            return this.warning == null;
        }

        public SortedSet<String> getCurrentAdditions() {
            return this.currentAdditions;
        }

        private void resetCurrentAdditions() {
            this.currentAdditions.clear();
        }

        public String getRestartPointFor(String additionCNB) {
            this.currentAdditions.add(additionCNB);
            return this.currentAdditions.first();
        }
    }

    private static final class SuiteModule
    extends AbstractUniverseModule {
        private final NbModuleProject project;
        private final Set<Dependency> dependencies;

        public SuiteModule(NbModuleProject project) {
            super(ManifestManager.getInstance(project.getManifest(), false));
            this.project = project;
            this.dependencies = new HashSet<Dependency>();
            Element dataE = project.getPrimaryConfigurationData();
            Element depsE = XMLUtil.findElement((Element)dataE, (String)"module-dependencies", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            assert (depsE != null) : "Malformed metadata in " + project;
            for (Element dep : XMLUtil.findSubElements((Element)depsE)) {
                Element specverE;
                Element run = XMLUtil.findElement((Element)dep, (String)"run-dependency", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                if (run == null) continue;
                String text = XMLUtil.findText((org.w3c.dom.Node)XMLUtil.findElement((Element)dep, (String)"code-name-base", (String)"http://www.netbeans.org/ns/nb-module-project/3"));
                Element relverE = XMLUtil.findElement((Element)run, (String)"release-version", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                if (relverE != null) {
                    text = text + '/' + XMLUtil.findText((org.w3c.dom.Node)relverE);
                }
                if ((specverE = XMLUtil.findElement((Element)run, (String)"specification-version", (String)"http://www.netbeans.org/ns/nb-module-project/3")) != null) {
                    text = text + " > " + XMLUtil.findText((org.w3c.dom.Node)specverE);
                } else {
                    Element implver = XMLUtil.findElement((Element)run, (String)"implementation-version", (String)"http://www.netbeans.org/ns/nb-module-project/3");
                    if (implver != null) {
                        text = text + " = *";
                    }
                }
                this.dependencies.addAll(Dependency.create((int)1, (String)text));
            }
        }

        @Override
        public String getCodeNameBase() {
            return this.project.getCodeNameBase();
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            String s = this.project.getSpecVersion();
            return s != null ? new SpecificationVersion(s) : null;
        }

        @Override
        public Set<Dependency> getModuleDependencies() {
            return this.dependencies;
        }

        @Override
        public File getCluster() {
            return ClusterUtils.getClusterDirectory(this.project);
        }

        @Override
        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }
    }

    private static final class PlatformModule
    extends AbstractUniverseModule {
        private final ModuleEntry entry;

        public PlatformModule(ModuleEntry entry) throws IOException {
            super(ManifestManager.getInstanceFromJAR(entry.getJarLocation()));
            this.entry = entry;
        }

        @Override
        public String getCodeNameBase() {
            return this.entry.getCodeNameBase();
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            String s = this.entry.getSpecificationVersion();
            return s != null ? new SpecificationVersion(s) : null;
        }

        @Override
        public Set<Dependency> getModuleDependencies() {
            return this.mm.getModuleDependencies();
        }

        @Override
        public File getCluster() {
            return this.entry.getClusterDirectory();
        }

        @Override
        public String getDisplayName() {
            return this.entry.getLocalizedName();
        }
    }

    private static abstract class AbstractUniverseModule
    implements UniverseModule {
        protected final ManifestManager mm;

        protected AbstractUniverseModule(ManifestManager mm) {
            this.mm = mm;
        }

        @Override
        public int getReleaseVersion() {
            String s = this.mm.getReleaseVersion();
            return s != null ? Integer.parseInt(s) : -1;
        }

        @Override
        public String getImplementationVersion() {
            return this.mm.getImplementationVersion();
        }

        @Override
        public Set<String> getProvidedTokens() {
            return new HashSet<String>(Arrays.asList(this.mm.getProvidedTokens()));
        }

        @Override
        public Set<String> getRequiredTokens() {
            HashSet<String> s = new HashSet<String>(Arrays.asList(this.mm.getRequiredTokens()));
            s.addAll(Arrays.asList(this.mm.getNeededTokens()));
            Iterator it = s.iterator();
            while (it.hasNext()) {
                String tok = (String)it.next();
                if (!tok.startsWith("org.openide.modules.ModuleFormat") && !tok.startsWith("org.openide.modules.os.")) continue;
                it.remove();
            }
            s.addAll(Arrays.asList(this.mm.getNeededTokens()));
            return s;
        }

        public String toString() {
            return this.getCodeNameBase();
        }
    }

    static interface UniverseModule {
        public String getCodeNameBase();

        public int getReleaseVersion();

        public SpecificationVersion getSpecificationVersion();

        public String getImplementationVersion();

        public Set<String> getProvidedTokens();

        public Set<String> getRequiredTokens();

        public Set<Dependency> getModuleDependencies();

        public File getCluster();

        public String getDisplayName();
    }

    private class LibrariesChildren
    extends Children.Keys<ClusterNode> {
        private final SortedSet<ClusterNode> platformNodes = new TreeSet<ClusterNode>(SuiteCustomizerLibraries.access$2400());
        private final List<ClusterNode> extraNodes = new ArrayList<ClusterNode>();
        private ClusterNode selfCN;

        private LibrariesChildren() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<? extends ClusterNode> platformNodes() {
            SortedSet<ClusterNode> sortedSet = this.platformNodes;
            synchronized (sortedSet) {
                return new ArrayList<ClusterNode>(this.platformNodes);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<? extends ClusterNode> extraNodes() {
            List<ClusterNode> list = this.extraNodes;
            synchronized (list) {
                return new ArrayList<ClusterNode>(this.extraNodes);
            }
        }

        protected Node[] createNodes(ClusterNode key) {
            return new Node[]{key};
        }

        protected void addNotify() {
            super.addNotify();
            this.setMergedKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private ClusterNode findCluster(File clusterDir) {
            for (ClusterNode clusterNode : this.extraNodes()) {
                if (!clusterNode.getClusterInfo().getClusterDir().equals(clusterDir)) continue;
                return clusterNode;
            }
            for (ClusterNode clusterNode : this.platformNodes()) {
                if (!clusterNode.getClusterInfo().getClusterDir().equals(clusterDir)) continue;
                return clusterNode;
            }
            if (ClusterUtils.getClusterDirectory(SuiteCustomizerLibraries.this.getProperties().getProject()).equals(clusterDir)) {
                if (this.selfCN == null) {
                    this.selfCN = SuiteCustomizerLibraries.this.createSuiteNode(ClusterInfo.create(SuiteCustomizerLibraries.this.getProperties().getProject(), true));
                }
                return this.selfCN;
            }
            return null;
        }

        private void getProjectModules(Set<NbModuleProject> suiteModules) {
            for (ClusterNode clusterNode : this.extraNodes()) {
                ClusterInfo ci = clusterNode.getClusterInfo();
                Project prj = ci.getProject();
                if (prj == null) continue;
                NbModuleProvider nbmp = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
                if (nbmp != null) {
                    suiteModules.add((NbModuleProject)prj);
                    continue;
                }
                for (Node node2 : clusterNode.getChildren().getNodes()) {
                    SuiteComponentNode scn = (SuiteComponentNode)node2;
                    suiteModules.add((NbModuleProject)scn.getProject());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeClusters(Node[] selectedNodes) {
            List<ClusterNode> list = this.extraNodes;
            synchronized (list) {
                this.extraNodes.removeAll(Arrays.asList(selectedNodes));
            }
            this.setMergedKeys();
            SuiteCustomizerLibraries.this.updateDependencyWarnings(true);
        }

        private void setMergedKeys() {
            ArrayList<? extends ClusterNode> allNodes = new ArrayList<ClusterNode>(this.platformNodes());
            allNodes.addAll(this.extraNodes());
            for (ClusterNode clusterNode : allNodes) {
                clusterNode.updateClusterState();
            }
            this.setKeys(allNodes);
        }
    }

    private static final class OriginProp
    extends PropertySupport.ReadOnly<String> {
        private Enabled node;

        public PropertyEditor getPropertyEditor() {
            return null;
        }

        private OriginProp(Enabled node) {
            super("origin", String.class, SuiteCustomizerLibraries.getMessage("LBL_Origin"), SuiteCustomizerLibraries.getMessage("LBL_OriginShortDesc"));
            this.node = node;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.node == null ? null : this.node.getOrigin();
        }
    }

    private static final class EnabledProp
    extends PropertySupport.ReadWrite<Boolean> {
        private Enabled node;
        private PropertyEditor editor;

        public EnabledProp(Enabled node) {
            super("enabled", Boolean.TYPE, SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabled"), SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabledShortDescription"));
            this.node = node;
        }

        public void setValue(Boolean val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.node.setEnabled(val);
        }

        public Boolean getValue() throws IllegalAccessException, InvocationTargetException {
            Children ch = this.node.getChildren();
            Logger logger = Logger.getLogger(EnabledProp.class.getName());
            if (ch == Children.LEAF) {
                logger.log(Level.FINE, "Node '" + this.node.getName() + "' is LEAF, enabled=" + this.node.isEnabled());
                return this.node.isEnabled();
            }
            if (this.node.getState() == EnabledState.PART_ENABLED) {
                logger.log(Level.FINE, "Node '" + this.node.getName() + "', enabled=null");
                return null;
            }
            logger.log(Level.FINE, "Node '" + this.node.getName() + "', enabled=" + this.node.isEnabled());
            return this.node.isEnabled();
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = super.getPropertyEditor();
            }
            return this.editor;
        }
    }

    final class BinaryModuleNode
    extends Enabled {
        private final boolean deprecated;

        public BinaryModuleNode(ModuleEntry entry, boolean enabled) {
            super(Children.LEAF, enabled);
            this.deprecated = entry.isDeprecated();
            String cnb = entry.getCodeNameBase();
            this.setName(cnb);
            this.setDisplayName(entry.getLocalizedName());
            String desc = entry.getShortDescription();
            this.setShortDescription(SuiteCustomizerLibraries.this.formatEntryDesc(cnb, desc));
        }

        @Override
        public boolean isDeprecated() {
            return this.deprecated;
        }

        @Override
        public boolean isPlatformNode() {
            return ((Enabled)this.getParentNode()).isPlatformNode();
        }

        @Override
        public String getOrigin() {
            if (this.isPlatformNode()) {
                return SuiteCustomizerLibraries.getMessage("LBL_PlatformOrigin");
            }
            return SuiteCustomizerLibraries.getMessage("LBL_ExtCluster");
        }

        @Override
        public Project getProject() {
            return null;
        }
    }

    final class ClusterNode
    extends Enabled {
        private ClusterInfo ci;

        public ClusterNode(ClusterInfo ci, Children ch) {
            super(ch, ci.isEnabled());
            this.ci = ci;
            Project prj = ci.getProject();
            if (prj != null) {
                this.setName(ProjectUtils.getInformation((Project)prj).getDisplayName());
                NbModuleProvider nbmp = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
                if (nbmp != null) {
                    LocalizedBundleInfo bundleInfo;
                    LocalizedBundleInfo.Provider provider = (LocalizedBundleInfo.Provider)prj.getLookup().lookup(LocalizedBundleInfo.Provider.class);
                    if (provider != null && (bundleInfo = provider.getLocalizedBundleInfo()) != null) {
                        this.setShortDescription(SuiteCustomizerLibraries.this.formatEntryDesc(nbmp.getCodeNameBase(), bundleInfo.getShortDescription()));
                    }
                } else {
                    this.setShortDescription(ci.getClusterDir().getAbsolutePath());
                }
            } else {
                this.setName(ci.getClusterDir().getName());
                this.setShortDescription(ci.getClusterDir().getAbsolutePath());
            }
        }

        private ClusterInfo getClusterInfo() {
            return this.ci;
        }

        private void setClusterInfo(ClusterInfo ci) {
            if (!this.ci.equals(ci)) {
                this.ci = ci;
                SuiteCustomizerLibraries.this.refresh();
            }
        }

        @Override
        public void setState(EnabledState es, boolean propagate) {
            super.setState(es, propagate);
            if (this.ci != null && this.ci.isEnabled() != this.isEnabled()) {
                this.ci = ClusterInfo.createFromCP(this.ci.getClusterDir(), this.ci.getProject(), this.ci.isPlatformCluster(), this.ci.getSourceRoots(), this.ci.getJavadocRoots(), this.isEnabled());
            }
        }

        @Override
        public boolean isPlatformNode() {
            return this.ci.isPlatformCluster();
        }

        @Override
        public String getOrigin() {
            if (this.isPlatformNode()) {
                return SuiteCustomizerLibraries.getMessage("LBL_PlatformOrigin");
            }
            if (this.getProject() == null) {
                return SuiteCustomizerLibraries.getMessage("LBL_ExtCluster");
            }
            NbModuleProvider nbmp = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
            if (nbmp == null) {
                return SuiteCustomizerLibraries.getMessage("LBL_SuiteProject");
            }
            if (nbmp.getModuleType() == NbModuleProvider.STANDALONE) {
                return SuiteCustomizerLibraries.getMessage("LBL_StandaloneProject");
            }
            Logger.getLogger(SuiteCustomizerLibraries.class.getName()).log(Level.WARNING, "#166594: {0} should not contain NB.org module or suite component project", this.ci);
            return null;
        }

        @Override
        public Project getProject() {
            return this.ci.getProject();
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }
    }

    final class SuiteComponentNode
    extends Enabled {
        private final Project project;
        private final NbModuleProvider nbmp;

        public SuiteComponentNode(Project prj, NbModuleProvider nbmp, boolean enabled) {
            LocalizedBundleInfo bundleInfo;
            super(Children.LEAF, enabled);
            this.project = prj;
            this.nbmp = nbmp;
            String cnb = nbmp.getCodeNameBase();
            this.setName(cnb);
            this.setDisplayName(ProjectUtils.getInformation((Project)prj).getDisplayName());
            LocalizedBundleInfo.Provider provider = (LocalizedBundleInfo.Provider)prj.getLookup().lookup(LocalizedBundleInfo.Provider.class);
            if (provider != null && (bundleInfo = provider.getLocalizedBundleInfo()) != null) {
                this.setShortDescription(SuiteCustomizerLibraries.this.formatEntryDesc(cnb, bundleInfo.getShortDescription()));
            }
        }

        @Override
        public boolean isDeprecated() {
            return ManifestManager.getInstance(Util.getManifest(this.nbmp.getManifestFile()), false).isDeprecated();
        }

        @Override
        public boolean isPlatformNode() {
            return false;
        }

        @Override
        public String getOrigin() {
            return SuiteCustomizerLibraries.getMessage("LBL_SuiteComponent");
        }

        @Override
        public Project getProject() {
            return this.project;
        }
    }

    abstract class Enabled
    extends AbstractNode {
        private EnabledState state;

        Enabled(Children ch, boolean enabled) {
            super(ch);
            this.setState(enabled ? EnabledState.FULL_ENABLED : EnabledState.DISABLED, false);
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            ss.put((Node.Property)new EnabledProp(this));
            ss.put((Node.Property)new OriginProp(this));
            this.setSheet(s);
            this.setIconBaseWithExtension(this.isLeaf() ? "org/netbeans/modules/apisupport/project/resources/module.png" : "org/netbeans/modules/apisupport/project/suite/resources/suite.png");
        }

        public String getHtmlDisplayName() {
            if (this.isDeprecated()) {
                try {
                    return "<html><s>" + XMLUtil.toElementContent((String)this.getDisplayName()) + "</s>";
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Action getPreferredAction() {
            return null;
        }

        public SystemAction[] getActions(boolean context) {
            return NO_ACTIONS;
        }

        public void setEnabled(boolean s) {
            this.setState(s ? EnabledState.FULL_ENABLED : EnabledState.DISABLED, true);
        }

        public boolean isEnabled() {
            return this.state != EnabledState.DISABLED;
        }

        public EnabledState getState() {
            return this.state;
        }

        public abstract boolean isPlatformNode();

        public abstract String getOrigin();

        protected void setState(EnabledState s, boolean propagate) {
            if (s == this.state) {
                return;
            }
            this.state = s;
            Logger logger = Logger.getLogger(EnabledProp.class.getName());
            logger.log(Level.FINE, "Node '" + this.getName() + "', state=" + (s == EnabledState.DISABLED ? "disabled" : (s == EnabledState.FULL_ENABLED ? "full enabled" : "part enabled")));
            if (propagate) {
                EnabledState newChildState = s == EnabledState.PART_ENABLED ? null : s;
                for (Node nn : this.getChildren().getNodes()) {
                    if (!(nn instanceof Enabled)) continue;
                    Enabled en = (Enabled)nn;
                    if (newChildState != null) {
                        en.setState(newChildState, false);
                    }
                    en.firePropertyChange(null, null, null);
                }
                Node n = this.getParentNode();
                if (n instanceof Enabled) {
                    assert (s != EnabledState.PART_ENABLED) : "Module node should not be passed ENABLED_PARTIALLY state";
                    Enabled par = (Enabled)n;
                    par.updateClusterState();
                    par.firePropertyChange(null, null, null);
                }
                SuiteCustomizerLibraries.this.updateDependencyWarnings(false);
            }
        }

        void updateClusterState() {
            if (this.getChildren() == Children.LEAF) {
                return;
            }
            boolean allEnabled = true;
            boolean allDisabled = true;
            for (Node nn : this.getChildren().getNodes()) {
                Enabled ch;
                if (nn instanceof Enabled && !(allEnabled &= (ch = (Enabled)nn).isEnabled()) && !(allDisabled &= !ch.isEnabled())) break;
            }
            if (allEnabled) {
                this.setState(EnabledState.FULL_ENABLED, false);
            } else if (allDisabled) {
                this.setState(EnabledState.DISABLED, false);
            } else {
                this.setState(EnabledState.PART_ENABLED, false);
            }
        }

        public abstract Project getProject();

        protected abstract boolean isDeprecated();
    }

    private static enum EnabledState {
        FULL_ENABLED,
        PART_ENABLED,
        DISABLED;

    }

    private final class WaitNode
    extends AbstractNode {
        public WaitNode() {
            super(Children.LEAF);
            this.setDisplayName(CustomizerComponentFactory.WAIT_VALUE);
            this.setIconBaseWithExtension(SuiteCustomizerLibraries.WAIT_ICON_PATH);
        }
    }
}

