/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.io.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOContainer;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IOWindow
implements IOContainer.Provider {
    private static IOWindowImpl impl;

    IOWindowImpl impl() {
        if (impl == null) {
            impl = IOWindowImpl.findDefault();
        }
        return impl;
    }

    public void add(JComponent comp, IOContainer.CallBacks cb) {
        this.impl().addTab(comp, cb);
    }

    public JComponent getSelected() {
        return this.impl().getSelectedTab();
    }

    public boolean isActivated() {
        return this.impl().isActivated();
    }

    public void open() {
        this.impl().open();
    }

    public void remove(JComponent comp) {
        this.impl().removeTab(comp);
    }

    public void requestActive() {
        this.impl().requestActive();
    }

    public void requestVisible() {
        this.impl().requestVisible();
    }

    public void select(JComponent comp) {
        this.impl().selectTab(comp);
    }

    public void setIcon(JComponent comp, Icon icon) {
        this.impl().setIcon(comp, icon);
    }

    public void setTitle(JComponent comp, String name) {
        this.impl().setTitle(comp, name);
    }

    public void setToolTipText(JComponent comp, String text) {
        this.impl().setToolTipText(comp, text);
    }

    public void setToolbarActions(JComponent comp, Action[] toolbarActions) {
        this.impl().setToolbarActions(comp, toolbarActions);
    }

    public boolean isCloseable(JComponent comp) {
        return true;
    }

    public static final class IOWindowImpl
    extends TopComponent
    implements ChangeListener,
    PropertyChangeListener {
        public static IOWindowImpl DEFAULT;
        private static final String ICON_PROP = "tabIcon";
        private static final String TOOLBAR_ACTIONS_PROP = "toolbarActions";
        private static final String TOOLBAR_BUTTONS_PROP = "toolbarButtons";
        private static final String ICON_RESOURCE = "org/netbeans/core/resources/frames/output.png";
        private static final boolean AQUA;
        private JTabbedPane pane;
        private JComponent singleTab;
        private JToolBar toolbar;
        private JPopupMenu popupMenu;
        private Map<JComponent, IOContainer.CallBacks> tabToCb = new HashMap<JComponent, IOContainer.CallBacks>();
        boolean activated;
        JComponent lastSelTab;

        static synchronized IOWindowImpl findDefault() {
            if (DEFAULT == null) {
                TopComponent tc = WindowManager.getDefault().findTopComponent("output");
                if (tc != null) {
                    if (tc instanceof IOWindowImpl) {
                        DEFAULT = (IOWindowImpl)tc;
                    } else {
                        IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected: " + IOWindowImpl.class.getName() + " Returned: " + tc.getClass().getName());
                        Logger.getLogger(IOWindowImpl.class.getName()).log(Level.WARNING, null, exc);
                        IOWindowImpl.getDefault();
                    }
                } else {
                    IOWindowImpl.getDefault();
                }
            }
            DEFAULT.getActionMap().remove("org.openide.actions.FindAction");
            return DEFAULT;
        }

        public static synchronized IOWindowImpl getDefault() {
            if (DEFAULT == null) {
                DEFAULT = new IOWindowImpl();
            }
            return DEFAULT;
        }

        public Object readResolve() throws ObjectStreamException {
            return IOWindowImpl.getDefault();
        }

        public IOWindowImpl() {
            this.pane = TabbedPaneFactory.createCloseButtonTabbedPane();
            this.pane.addChangeListener(this);
            this.pane.addPropertyChangeListener("close", this);
            this.setFocusable(true);
            this.toolbar = new JToolBar();
            this.toolbar.setOrientation(1);
            this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
            this.toolbar.setFloatable(false);
            Insets ins = this.toolbar.getMargin();
            JButton sample = new JButton();
            sample.setBorderPainted(false);
            sample.setOpaque(false);
            sample.setText(null);
            sample.setIcon(new Icon(){

                @Override
                public int getIconHeight() {
                    return 16;
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                }
            });
            this.toolbar.add(sample);
            Dimension buttonPref = sample.getPreferredSize();
            Dimension minDim = new Dimension(buttonPref.width + ins.left + ins.right, buttonPref.height + ins.top + ins.bottom);
            this.toolbar.setMinimumSize(minDim);
            this.toolbar.setPreferredSize(minDim);
            this.toolbar.remove(sample);
            this.setLayout(new BorderLayout());
            this.add(this.toolbar, "West");
            this.toolbar.setBorder(new VariableRightBorder(this.pane));
            this.toolbar.setBorderPainted(true);
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new Close());
            this.popupMenu.add(new CloseAll());
            this.popupMenu.add(new CloseOthers());
            this.pane.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

                protected void showPopup(MouseEvent evt) {
                    IOWindowImpl.this.popupMenu.show((Component)((Object)IOWindowImpl.this), evt.getX(), evt.getY());
                }
            });
            String name = NbBundle.getMessage(IOWindow.class, (String)"LBL_IO_WINDOW");
            this.setDisplayName(name);
            this.setToolTipText(name);
            this.setName(name);
            this.setIcon(ImageUtilities.loadImage((String)ICON_RESOURCE));
            this.putClientProperty("SlidingName", this.getDisplayName());
            if (AQUA) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
                this.setOpaque(true);
                this.toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
                this.pane.setBackground(UIManager.getColor("NbExplorerView.background"));
                this.pane.setOpaque(true);
            }
        }

        public void open() {
            if (!this.isOpened()) {
                super.open();
            }
        }

        public void requestActive() {
            super.requestActive();
            JComponent tab = this.getSelectedTab();
            if (tab != null) {
                tab.requestFocus();
            }
        }

        public void requestVisible() {
            if (!this.isShowing()) {
                super.requestVisible();
            }
        }

        public boolean isActivated() {
            return this.activated;
        }

        public void addTab(JComponent comp, IOContainer.CallBacks cb) {
            if (cb != null) {
                this.tabToCb.put(comp, cb);
            }
            if (this.singleTab != null) {
                assert (this.pane.getParent() == null);
                assert (this.pane.getTabCount() == 0);
                this.remove(this.singleTab);
                this.pane.add(this.singleTab);
                this.pane.setIconAt(0, (Icon)this.singleTab.getClientProperty(ICON_PROP));
                this.pane.setToolTipTextAt(0, this.singleTab.getToolTipText());
                this.singleTab = null;
                this.pane.add(comp);
                this.add(this.pane);
                this.updateWindowName(null);
            } else if (this.pane.getTabCount() > 0) {
                assert (this.pane.getParent() != null);
                assert (this.singleTab == null);
                this.pane.add(comp);
            } else {
                assert (this.pane.getParent() == null);
                assert (this.singleTab == null);
                this.setFocusable(false);
                this.singleTab = comp;
                this.add(comp);
                this.updateWindowName(this.singleTab.getName());
                this.checkTabSelChange();
            }
            this.revalidate();
        }

        public void removeTab(JComponent comp) {
            if (this.singleTab != null) {
                assert (this.singleTab == comp);
                this.remove(this.singleTab);
                this.singleTab = null;
                this.updateWindowName(null);
                this.checkTabSelChange();
                this.setFocusable(true);
                this.revalidate();
                this.repaint();
            } else if (this.pane.getParent() == this) {
                assert (this.pane.getTabCount() > 1);
                this.pane.remove(comp);
                if (this.pane.getTabCount() == 1) {
                    this.singleTab = (JComponent)this.pane.getComponentAt(0);
                    this.pane.remove(this.singleTab);
                    this.remove(this.pane);
                    this.add(this.singleTab);
                    this.updateWindowName(this.singleTab.getName());
                }
                this.revalidate();
            }
            IOContainer.CallBacks cb = this.tabToCb.remove(comp);
            if (cb != null) {
                cb.closed();
            }
        }

        public void selectTab(JComponent comp) {
            if (this.singleTab == null) {
                this.pane.setSelectedComponent(comp);
            }
            this.checkTabSelChange();
        }

        public JComponent getSelectedTab() {
            return this.singleTab != null ? this.singleTab : (JComponent)this.pane.getSelectedComponent();
        }

        public void setTitle(JComponent comp, String name) {
            comp.setName(name);
            if (this.singleTab != null) {
                assert (this.singleTab == comp);
                this.updateWindowName(name);
            } else {
                assert (this.pane.getParent() == this);
                int idx = this.pane.indexOfComponent(comp);
                assert (idx >= 0);
                this.pane.setTitleAt(idx, name);
            }
        }

        public void setToolTipText(JComponent comp, String text) {
            comp.setToolTipText(text);
            if (this.singleTab != null) {
                assert (this.singleTab == comp);
            } else {
                assert (this.pane.getParent() == this);
                int idx = this.pane.indexOfComponent(comp);
                assert (idx >= 0);
                this.pane.setToolTipTextAt(idx, text);
            }
        }

        public void setIcon(JComponent comp, Icon icon) {
            if (comp == this.singleTab) {
                comp.putClientProperty(ICON_PROP, icon);
                return;
            }
            int idx = this.pane.indexOfComponent(comp);
            if (idx < 0) {
                return;
            }
            comp.putClientProperty(ICON_PROP, icon);
            this.pane.setIconAt(idx, icon);
            this.pane.setDisabledIconAt(idx, icon);
        }

        void setToolbarActions(JComponent comp, Action[] toolbarActions) {
            if (toolbarActions != null && toolbarActions.length > 0) {
                if (toolbarActions.length > 5) {
                    throw new IllegalArgumentException("No more than 5 actions allowed in the output window toolbar");
                }
                comp.putClientProperty(TOOLBAR_ACTIONS_PROP, toolbarActions);
            }
            if (this.getSelectedTab() == comp) {
                this.updateToolbar(comp);
            }
        }

        public int getPersistenceType() {
            return 0;
        }

        public String preferredID() {
            return "output";
        }

        public void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            if (Boolean.TRUE.equals(this.getClientProperty("isSliding"))) {
                this.repaint(200L);
            }
        }

        public void paintComponent(Graphics g) {
            if (AQUA) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
            if (this.hasFocus()) {
                Insets ins = this.getInsets();
                Color col = UIManager.getColor("controlShadow");
                if (col == null) {
                    col = Color.GRAY;
                }
                g.setColor(col);
                g.drawRect(ins.left + 2, ins.top + 2, this.getWidth() - (ins.left + ins.right + 4), this.getHeight() - (ins.top + ins.bottom + 4));
            }
        }

        void updateWindowName(String name) {
            String winName = NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_IO_WINDOW");
            if (name != null) {
                String newName = NbBundle.getMessage(IOWindowImpl.class, (String)"FMT_IO_WINDOW", (Object[])new Object[]{winName, name});
                if (newName.indexOf("<html>") != -1) {
                    newName = "<html>" + newName.replace("<html>", "");
                    this.setHtmlDisplayName(newName);
                    this.setToolTipText(newName);
                } else {
                    this.setDisplayName(newName);
                    this.setHtmlDisplayName(null);
                    this.setToolTipText(newName);
                }
            } else {
                this.setDisplayName(winName);
                this.setToolTipText(winName);
                this.setHtmlDisplayName(null);
            }
        }

        private void updateToolbar(JComponent comp) {
            this.toolbar.removeAll();
            if (comp != null) {
                JButton[] buttons = this.getTabButtons(comp);
                for (int i = 0; i < buttons.length; ++i) {
                    this.toolbar.add(buttons[i]);
                }
            }
            this.toolbar.revalidate();
            this.toolbar.repaint();
        }

        JButton[] getTabButtons(JComponent comp) {
            JButton[] buttons = (JButton[])comp.getClientProperty(TOOLBAR_BUTTONS_PROP);
            if (buttons != null) {
                return buttons;
            }
            Action[] actions = (Action[])comp.getClientProperty(TOOLBAR_ACTIONS_PROP);
            if (actions == null) {
                return new JButton[0];
            }
            buttons = new JButton[actions.length];
            for (int i = 0; i < buttons.length; ++i) {
                buttons[i] = new JButton(actions[i]);
                buttons[i].setBorderPainted(false);
                buttons[i].setOpaque(false);
                buttons[i].setText(null);
                buttons[i].putClientProperty("hideActionText", Boolean.TRUE);
                Object icon = actions[i].getValue("SmallIcon");
                if (!(icon instanceof Icon)) {
                    throw new IllegalStateException("No icon provided for " + actions[i]);
                }
                buttons[i].setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)icon)));
                String name = (String)actions[i].getValue("Name");
                String shortDescription = (String)actions[i].getValue("ShortDescription");
                String longDescription = (String)actions[i].getValue("LongDescription");
                if (name == null) {
                    name = shortDescription;
                }
                if (longDescription == null) {
                    longDescription = shortDescription;
                }
                buttons[i].getAccessibleContext().setAccessibleName(name);
                buttons[i].getAccessibleContext().setAccessibleDescription(longDescription);
            }
            return buttons;
        }

        protected void componentActivated() {
            super.componentActivated();
            this.activated = true;
            JComponent comp = this.getSelectedTab();
            IOContainer.CallBacks cb = this.tabToCb.get(comp);
            if (cb != null) {
                cb.activated();
            }
        }

        protected void componentDeactivated() {
            super.componentDeactivated();
            this.activated = false;
            JComponent comp = this.getSelectedTab();
            IOContainer.CallBacks cb = this.tabToCb.get(comp);
            if (cb != null) {
                cb.deactivated();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.checkTabSelChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("close".equals(evt.getPropertyName())) {
                JComponent comp = (JComponent)evt.getNewValue();
                this.removeTab(comp);
            }
        }

        void checkTabSelChange() {
            JComponent sel = this.getSelectedTab();
            if (sel != this.lastSelTab) {
                this.lastSelTab = sel;
                this.updateToolbar(sel);
                this.getActionMap().setParent(sel != null ? sel.getActionMap() : null);
            }
        }

        private JComponent[] getTabs() {
            if (this.singleTab != null) {
                return new JComponent[]{this.singleTab};
            }
            JComponent[] tabs = new JComponent[this.pane.getTabCount()];
            for (int i = 0; i < this.pane.getTabCount(); ++i) {
                tabs[i] = (JComponent)this.pane.getComponentAt(i);
            }
            return tabs;
        }

        private void closeOtherTabs() {
            assert (this.pane.getParent() == this);
            JComponent sel = this.getSelectedTab();
            for (JComponent tab : this.getTabs()) {
                if (tab == sel) continue;
                this.removeTab(tab);
            }
        }

        private void closeAllTabs() {
            for (JComponent tab : this.getTabs()) {
                this.removeTab(tab);
            }
        }

        static {
            AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
        }

        private class VariableRightBorder
        implements Border {
            private JTabbedPane pane;

            public VariableRightBorder(JTabbedPane pane) {
                this.pane = pane;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (this.pane.getParent() != IOWindowImpl.this) {
                    Color old = g.getColor();
                    g.setColor(this.getColor());
                    g.drawLine(x + width - 1, y, x + width - 1, y + height);
                    g.setColor(old);
                }
            }

            public Color getColor() {
                if (Utilities.isMac()) {
                    Color c1 = UIManager.getColor("controlShadow");
                    Color c2 = UIManager.getColor("control");
                    return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
                }
                return UIManager.getColor("controlShadow");
            }

            @Override
            public Insets getBorderInsets(Component c) {
                if (this.pane.getParent() == IOWindowImpl.this) {
                    return new Insets(0, 0, 0, 0);
                }
                return new Insets(0, 0, 0, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        }

        private class CloseOthers
        extends AbstractAction {
            public CloseOthers() {
                super(NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_CloseOthers"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                IOWindowImpl.this.closeOtherTabs();
            }
        }

        private class CloseAll
        extends AbstractAction {
            public CloseAll() {
                super(NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_CloseAll"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                IOWindowImpl.this.closeAllTabs();
            }
        }

        private class Close
        extends AbstractAction {
            public Close() {
                super(NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_Close"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                IOWindowImpl.this.removeTab(IOWindowImpl.this.getSelectedTab());
            }
        }
    }
}

