/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.javamodel;

import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.design.javamodel.FaultModel;
import org.netbeans.modules.websvc.design.javamodel.JavadocModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.javamodel.ResultModel;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.openide.filesystems.FileObject;

public class MethodModel {
    private FileObject implementationClass;
    String javaName;
    String operationName;
    String action;
    private ResultModel result;
    private List<ParamModel> params;
    boolean oneWay;
    private JavadocModel javadoc;
    private List<FaultModel> faults;
    private SOAPMessage soapRequest;
    private SOAPMessage soapResponse;
    private ElementHandle methodHandle;

    MethodModel(FileObject fileObject, String string) {
        this.implementationClass = fileObject;
        this.operationName = string;
    }

    MethodModel() {
    }

    public FileObject getImplementationClass() {
        if (!this.implementationClass.isValid()) {
            FileObject fileObject = this.implementationClass.getParent();
            this.implementationClass = fileObject.getFileObject(this.implementationClass.getNameExt());
        }
        return this.implementationClass;
    }

    void setImplementationClass(FileObject fileObject) {
        this.implementationClass = fileObject;
    }

    public ElementHandle getMethodHandle() {
        return this.methodHandle;
    }

    void setMethodHandle(ElementHandle elementHandle) {
        this.methodHandle = elementHandle;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String string) {
        if (this.operationName != string) {
            JaxWsUtils.setWebMethodAttrValue((FileObject)this.getImplementationClass(), (ElementHandle)this.methodHandle, (String)"operationName", (String)string);
            this.operationName = string == null ? this.javaName : string;
        }
    }

    public ResultModel getResult() {
        return this.result;
    }

    void setResult(ResultModel resultModel) {
        this.result = resultModel;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public List<ParamModel> getParams() {
        return this.params;
    }

    void setParams(List<ParamModel> list) {
        this.params = list;
    }

    public boolean isOneWay() {
        return this.oneWay;
    }

    public void setOneWay(boolean bl) {
        this.oneWay = bl;
    }

    public JavadocModel getJavadoc() {
        return this.javadoc;
    }

    void setJavadoc(JavadocModel javadocModel) {
        this.javadoc = javadocModel;
    }

    public void setJavadoc(String string) {
        Utils.setJavadoc(this.implementationClass, this, string);
    }

    public List<FaultModel> getFaults() {
        return this.faults;
    }

    void setFaults(List<FaultModel> list) {
        this.faults = list;
    }

    public boolean isEqualTo(MethodModel methodModel) {
        int n;
        if (!this.operationName.equals(methodModel.operationName)) {
            return false;
        }
        if (!this.result.isEqualTo(methodModel.result)) {
            return false;
        }
        if (this.oneWay != methodModel.oneWay) {
            return false;
        }
        if (!Utils.isEqualTo(this.action, methodModel.action)) {
            return false;
        }
        if (this.javadoc != null ? !this.javadoc.isEqualTo(methodModel.javadoc) : methodModel.javadoc != null) {
            return false;
        }
        if (this.params.size() != methodModel.params.size()) {
            return false;
        }
        for (n = 0; n < this.params.size(); ++n) {
            if (this.params.get(n).isEqualTo(methodModel.params.get(n))) continue;
            return false;
        }
        if (this.faults.size() != methodModel.faults.size()) {
            return false;
        }
        for (n = 0; n < this.faults.size(); ++n) {
            if (this.faults.get(n).isEqualTo(methodModel.faults.get(n))) continue;
            return false;
        }
        return true;
    }

    public SOAPMessage getSoapRequest() {
        return this.soapRequest;
    }

    void setSoapRequest(SOAPMessage sOAPMessage) {
        this.soapRequest = sOAPMessage;
    }

    public SOAPMessage getSoapResponse() {
        return this.soapResponse;
    }

    void setSoapResponse(SOAPMessage sOAPMessage) {
        this.soapResponse = sOAPMessage;
    }
}

