/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.design.view.widget.OperationWidget;
import org.netbeans.modules.websvc.design.view.widget.ParametersTableModel;
import org.netbeans.modules.websvc.design.view.widget.TabWidget;
import org.netbeans.modules.websvc.design.view.widget.TableModel;
import org.netbeans.modules.websvc.design.view.widget.TableWidget;
import org.openide.util.NbBundle;

public class ParametersWidget
extends AbstractTitledWidget
implements TabWidget {
    private transient MethodModel method;
    private transient boolean nameEditable;
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private transient TableModel model;
    private transient TableWidget parameterTable;
    private transient Widget tabComponent;

    public ParametersWidget(ObjectScene objectScene, MethodModel methodModel, boolean bl) {
        super(objectScene, 0, 12, 0, BORDER_COLOR);
        this.method = methodModel;
        this.nameEditable = bl;
        this.createContent();
    }

    @Override
    protected Paint getTitlePaint(Rectangle rectangle) {
        return TITLE_COLOR_PARAMETER;
    }

    private void createContent() {
        this.model = new ParametersTableModel(this.method, this.nameEditable);
        this.populateContentWidget(this.getContentWidget());
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)0, (int)1, (int)1, (int)1));
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), this.getIcon(), this.getTitle(), "(" + this.method.getParams().size() + ")");
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)5);
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)4);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.buttons.setOpaque(true);
        this.buttons.setBackground((Paint)TITLE_COLOR_BRIGHT);
        this.getHeaderWidget().addChild(this.buttons);
    }

    private void populateContentWidget(Widget widget) {
        if (this.model.getRowCount() > 0) {
            this.parameterTable = new TableWidget(this.getScene(), this.model);
            widget.addChild((Widget)this.parameterTable);
        } else {
            LabelWidget labelWidget = new LabelWidget(this.getScene(), NbBundle.getMessage(OperationWidget.class, (String)"LBL_InputNone"));
            labelWidget.setAlignment(LabelWidget.Alignment.CENTER);
            widget.addChild((Widget)labelWidget);
        }
    }

    @Override
    public Object hashKey() {
        return this.model;
    }

    @Override
    public String getTitle() {
        return NbBundle.getMessage(OperationWidget.class, (String)"LBL_Input");
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public Widget getComponentWidget() {
        if (this.tabComponent == null) {
            this.tabComponent = this.createContentWidget();
            this.populateContentWidget(this.tabComponent);
        }
        return this.tabComponent;
    }
}

