/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.URLUtils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IndexBuilder
implements Runnable,
ChangeListener {
    private static final String[] INDEX_FILE_NAMES = new String[]{"overview-summary.html", "index.html", "index.htm"};
    private static IndexBuilder INSTANCE;
    private static RequestProcessor.Task task;
    private static final ErrorManager err;
    private Reference<List<Index>> cachedData;
    private JavadocRegistry jdocRegs;
    Map<URL, Info> filesystemInfo = Collections.emptyMap();

    private IndexBuilder() {
        this.jdocRegs = JavadocRegistry.getDefault();
        this.jdocRegs.addChangeListener(this);
        if (err.isLoggable(1)) {
            err.log("new IndexBuilder");
        }
    }

    public static synchronized IndexBuilder getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new IndexBuilder();
        IndexBuilder.scheduleTask();
        return INSTANCE;
    }

    @Override
    public void run() {
        this.cachedData = null;
        this.refreshIndex();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        IndexBuilder.scheduleTask();
    }

    public List<Index> getIndices(boolean blocking) {
        List<Index> data;
        if (blocking) {
            task.waitFinished();
        } else if (!task.isFinished()) {
            return null;
        }
        if (this.cachedData != null && (data = this.cachedData.get()) != null) {
            err.log("getIndices (cached)");
            return data;
        }
        err.log("getIndices");
        data = new ArrayList<Index>();
        for (Map.Entry<URL, Info> entry : this.filesystemInfo.entrySet()) {
            Info info = entry.getValue();
            URL fo = URLUtils.findOpenable(entry.getKey(), info.indexFileName);
            if (fo == null) continue;
            data.add(new Index(info.title, fo));
        }
        Collections.sort(data);
        this.cachedData = new WeakReference<List<Index>>(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndex() {
        Map<URL, Info> oldMap;
        if (err.isLoggable(1)) {
            err.log("refreshIndex");
        }
        IndexBuilder indexBuilder = this;
        synchronized (indexBuilder) {
            oldMap = this.filesystemInfo;
        }
        URL[] docRoots = this.jdocRegs.getDocRoots();
        WeakHashMap<URL, Info> m = new WeakHashMap<URL, Info>();
        for (int ifCount = 0; ifCount < docRoots.length; ++ifCount) {
            InputStream is;
            URL fo = docRoots[ifCount];
            Info oldInfo = oldMap.get(fo);
            if (oldInfo != null) {
                m.put(fo, oldInfo);
                continue;
            }
            URL index = URLUtils.findOpenable(fo, INDEX_FILE_NAMES);
            if ((index == null || index.toString().endsWith("index.html")) && (is = URLUtils.open(fo, "package-list")) != null) {
                try {
                    try {
                        String resName;
                        URL pindex;
                        BufferedReader r = new BufferedReader(new InputStreamReader(is));
                        String line = r.readLine();
                        if (line != null && r.readLine() == null && (pindex = URLUtils.findOpenable(fo, resName = line.replace('.', '/') + "/package-summary.html")) != null) {
                            index = pindex;
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
            if (index != null) {
                String title = this.parseTitle(index);
                if (title != null) {
                    JavadocSearchType st = this.jdocRegs.findSearchType(fo);
                    if (st == null) continue;
                    title = st.getOverviewTitleBase(title);
                }
                if (title == null || title.isEmpty() || title.equals("Overview")) {
                    String filename = URLUtils.getDisplayName(index);
                    if (filename.length() > 54) {
                        filename = filename.substring(0, 10) + "[...]" + filename.substring(filename.length() - 40, filename.length());
                    }
                    title = NbBundle.getMessage(IndexBuilder.class, (String)"FMT_NoOverviewTitle", (Object[])new Object[]{filename});
                }
                Info info = new Info();
                info.title = title;
                info.indexFileName = index.toString().substring(fo.toString().length());
                m.put(fo, info);
            }
            IndexBuilder indexBuilder2 = this;
            synchronized (indexBuilder2) {
                this.filesystemInfo = m;
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseTitle(URL html) {
        String title = null;
        try {
            BufferedInputStream is = new BufferedInputStream(URLUtils.openStream(html), 1024);
            SimpleTitleParser tp = new SimpleTitleParser(is);
            try {
                tp.parse();
                title = tp.getTitle();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        return title != null ? title.trim() : title;
    }

    private static synchronized void scheduleTask() {
        if (task == null) {
            task = new RequestProcessor(IndexBuilder.class).create((Runnable)IndexBuilder.getDefault());
        }
        task.schedule(100);
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexBuilder");
    }

    static final class SimpleTitleParser {
        private char cc;
        private InputStream is;
        private String charset;
        private String title;
        private State state = State.CONTINUE;

        SimpleTitleParser(InputStream is) {
            this.is = is;
        }

        public String getTitle() {
            return this.title;
        }

        public void parse() throws IOException {
            this.readNext();
            block4: while (this.state == State.CONTINUE) {
                switch (this.cc) {
                    case '<': {
                        this.handleOpenBrace();
                        continue block4;
                    }
                    case '\uffff': {
                        return;
                    }
                }
                this.readNext();
            }
        }

        private void readNext() throws IOException {
            this.cc = (char)this.is.read();
        }

        private void handleOpenBrace() throws IOException {
            StringBuilder sb = new StringBuilder();
            block5: while (true) {
                this.readNext();
                switch (this.cc) {
                    case '>': {
                        String tag = sb.toString().toLowerCase();
                        if (tag.startsWith("body")) {
                            this.state = State.EXIT;
                            return;
                        }
                        if (tag.startsWith("meta")) {
                            this.handleMetaTag(tag);
                            return;
                        }
                        if (tag.startsWith("title")) {
                            this.handleTitleTag();
                            return;
                        }
                        return;
                    }
                    case '\uffff': {
                        return;
                    }
                    case ' ': {
                        if (sb.length() == 0) continue block5;
                    }
                    default: {
                        sb.append(this.cc);
                    }
                }
            }
        }

        private void handleMetaTag(String txt) {
            int offset;
            String name = "";
            String value = "";
            char[] txts = txt.toCharArray();
            int start = offset = 5;
            int state2 = 0;
            while (offset < txts.length) {
                char tc = txt.charAt(offset);
                if (tc == '=' && state2 == 0) {
                    name = String.valueOf(txts, start, offset++ - start).trim();
                    state2 = 1;
                    continue;
                }
                if (state2 == 1 && (tc == '\"' || tc == '\'')) {
                    start = ++offset;
                    state2 = 2;
                    continue;
                }
                if (state2 == 2 && (tc == '\"' || tc == '\'')) {
                    value = String.valueOf(txts, start, offset++ - start);
                    if ("content".equals(name)) break;
                    name = "";
                    state2 = 0;
                    start = offset;
                    continue;
                }
                ++offset;
            }
            StringTokenizer tk = new StringTokenizer(value, ";");
            while (tk.hasMoreTokens()) {
                String str = tk.nextToken().trim();
                if (!str.startsWith("charset") || (str = str.substring(7).trim()).charAt(0) != '=') continue;
                this.charset = str.substring(1).trim();
                return;
            }
        }

        private void handleTitleTag() throws IOException {
            byte[] buf = new byte[200];
            int offset = 0;
            while (true) {
                this.readNext();
                switch (this.cc) {
                    case '\uffff': {
                        return;
                    }
                    case '>': {
                        if (!"</title".equals(new String(buf, offset - 7, 7).toLowerCase())) break;
                        this.state = State.EXIT;
                        this.title = this.charset == null ? new String(buf, 0, offset - 7).trim() : new String(buf, 0, offset - 7, this.charset).trim();
                        return;
                    }
                }
                this.cc = (char)(this.cc == '\n' || this.cc == '\r' ? 32 : (int)this.cc);
                if (offset == buf.length) {
                    buf = SimpleTitleParser.enlarge(buf);
                }
                buf[offset++] = (byte)this.cc;
            }
        }

        private static byte[] enlarge(byte[] b) {
            byte[] b2 = new byte[b.length + 200];
            System.arraycopy(b, 0, b2, 0, b.length);
            return b2;
        }

        static enum State {
            CONTINUE,
            EXIT;

        }
    }

    public static final class Index
    implements Comparable<Index> {
        private static final Collator c = Collator.getInstance();
        public final String display;
        public final URL fo;

        private Index(String display, URL fo) {
            this.display = display;
            this.fo = fo;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Index)) {
                return false;
            }
            Index other = (Index)obj;
            return this.display.equals(other.display) && this.fo.toString().equals(other.fo.toString());
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.fo.toString().hashCode();
        }

        @Override
        public int compareTo(Index o) {
            return c.compare(this.display, o.display);
        }
    }

    private static class Info {
        String title;
        String indexFileName;

        private Info() {
        }
    }
}

