/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RemoteFileUtil {
    public static boolean fileExists(String absolutePath, ExecutionEnvironment executionEnvironment) {
        FileObject fo = RemoteFileUtil.getFileObject(RemoteFileUtil.normalizeAbsolutePath(absolutePath, executionEnvironment), executionEnvironment);
        return fo != null && fo.isValid();
    }

    public static boolean fileExists(String absolutePath, ExecutionEnvironment executionEnvironment, RemoteProject.Mode remoteMode) {
        executionEnvironment = remoteMode == RemoteProject.Mode.REMOTE_SOURCES ? executionEnvironment : ExecutionEnvironmentFactory.getLocal();
        return RemoteFileUtil.fileExists(RemoteFileUtil.normalizeAbsolutePath(absolutePath, executionEnvironment), executionEnvironment);
    }

    public static boolean isDirectory(String absolutePath, ExecutionEnvironment executionEnvironment) {
        FileObject fo = RemoteFileUtil.getFileObject(absolutePath, executionEnvironment);
        return fo != null && fo.isFolder();
    }

    public static FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        FileObject result = FileSystemProvider.getFileObject((FileObject)baseFileObject, (String)relativeOrAbsolutePath);
        if (result == null) {
            String absRootPath = CndPathUtilitities.toAbsolutePath((FileObject)baseFileObject, (String)relativeOrAbsolutePath);
            result = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)absRootPath));
        }
        return result;
    }

    private RemoteFileUtil() {
    }

    public static FileObject getFileObject(String absolutePath, ExecutionEnvironment execEnv, RemoteProject.Mode remoteMode) {
        switch (remoteMode) {
            case LOCAL_SOURCES: {
                return RemoteFileUtil.getFileObject(absolutePath, ExecutionEnvironmentFactory.getLocal());
            }
            case REMOTE_SOURCES: {
                return RemoteFileUtil.getFileObject(absolutePath, execEnv);
            }
        }
        throw new IllegalArgumentException("Unexpected remote mode: " + (Object)((Object)remoteMode));
    }

    public static FileObject getFileObject(String absolutePath, ExecutionEnvironment execEnv) {
        CndUtils.assertAbsolutePathInConsole((String)absolutePath, (String)"path for must be absolute");
        if (execEnv.isRemote()) {
            String normalizedPath;
            if (CndUtils.isDebugMode() && !(normalizedPath = RemoteFileUtil.normalizeAbsolutePath(absolutePath, execEnv)).equals(absolutePath)) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Warning: path is not normalized:  absolute path is _" + absolutePath + "_ normailzed path is _" + normalizedPath + "_"));
            }
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)execEnv).findResource(absolutePath);
        }
        return CndFileUtils.toFileObject((CharSequence)absolutePath);
    }

    public static FileSystem getProjectSourceFileSystem(Project project) {
        RemoteProject remoteProject;
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)remoteProject.getSourceFileSystemHost());
        }
        return CndFileUtils.getLocalFileSystem();
    }

    public static ExecutionEnvironment getProjectSourceExecutionEnvironment(Project project) {
        RemoteProject remoteProject;
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES) {
            return remoteProject.getSourceFileSystemHost();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public static FileObject getFileObject(String absolutePath, Project project) {
        ExecutionEnvironment execEnv = RemoteFileUtil.getProjectSourceExecutionEnvironment(project);
        if (execEnv != null && execEnv.isRemote()) {
            return RemoteFileUtil.getFileObject(absolutePath, execEnv);
        }
        FileObject projectDir = project.getProjectDirectory();
        CndUtils.assertNotNull((Object)projectDir, (String)("Null project dir for " + project));
        try {
            FileSystem fs = projectDir.getFileSystem();
            return fs.findResource(absolutePath);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static String normalizeAbsolutePath(String absPath, Project project) {
        ExecutionEnvironment execEnv = RemoteFileUtil.getProjectSourceExecutionEnvironment(project);
        if (execEnv != null && execEnv.isRemote()) {
            return RemoteFileUtil.normalizeAbsolutePath(absPath, execEnv);
        }
        return CndFileUtils.normalizeAbsolutePath((String)absPath);
    }

    public static String normalizeAbsolutePath(String absPath, ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            return FileSystemProvider.normalizeAbsolutePath((String)absPath, (ExecutionEnvironment)execEnv);
        }
        return FileUtil.normalizePath((String)absPath);
    }

    public static String getAbsolutePath(FileObject fileObject) {
        return fileObject.getPath();
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        File file = FileUtil.toFile((FileObject)fo);
        return file == null ? fo.getPath() : file.getCanonicalPath();
    }

    public static JFileChooser createFileChooser(RemoteProject.Mode remoteMode, ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        return RemoteFileUtil.createFileChooser(remoteMode == RemoteProject.Mode.REMOTE_SOURCES ? execEnv : ExecutionEnvironmentFactory.getLocal(), titleText, buttonText, mode, filters, initialPath, useParent);
    }

    public static JFileChooser createFileChooser(ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        FileChooserBuilder.JFileChooserEx fileChooser;
        if (execEnv.isLocal()) {
            fileChooser = new FileChooser(titleText, buttonText, mode, filters, initialPath, useParent);
        } else {
            fileChooser = new FileChooserBuilder(execEnv).createFileChooser(initialPath);
            fileChooser.setApproveButtonText(buttonText);
            fileChooser.setDialogTitle(titleText);
            fileChooser.setFileSelectionMode(mode);
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    fileChooser.addChoosableFileFilter(filters[i]);
                }
                fileChooser.setFileFilter(filters[0]);
            }
        }
        return fileChooser;
    }
}

