/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SQLHistoryAction
extends SQLExecutionBaseAction {
    private static final String ICON_PATH = "org/netbeans/modules/db/sql/editor/resources/sql_history_16.png";
    private static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";

    @Override
    protected String getIconBase() {
        return ICON_PATH;
    }

    @Override
    protected String getDisplayName(SQLExecution sqlExecution) {
        return NbBundle.getMessage(SQLHistoryAction.class, (String)"LBL_SQLHistoryAction");
    }

    @Override
    protected void actionPerformed(SQLExecution sqlExecution) {
        FileObject historyRoot = FileUtil.getConfigFile((String)SQL_HISTORY_FOLDER);
        if (historyRoot == null || historyRoot.getChildren().length == 0) {
            SQLHistoryAction.notifyNoSQLExecuted();
        } else {
            historyRoot.refresh(true);
            sqlExecution.showHistory();
        }
    }

    private static void notifyNoSQLExecuted() {
        String message = NbBundle.getMessage(SQLExecutionBaseAction.class, (String)"LBL_NoSQLExecuted");
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }
}

