/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import com.sun.jna.Pointer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.PtyUtility;
import org.netbeans.modules.nativeexecution.support.EnvWriter;
import org.netbeans.modules.nativeexecution.support.Win32APISupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class LocalNativeProcess
extends AbstractNativeProcess {
    private Process process = null;
    private PipedInputStream errorPipedInputStream = null;
    private PipedOutputStream errorPipedOutputStream = null;
    private boolean win1073741515added = false;

    public LocalNativeProcess(NativeProcessInfo info) {
        super(info);
    }

    @Override
    protected void create() throws Throwable {
        if (this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
            this.createWin();
        } else {
            this.createNonWin();
        }
    }

    private void createNonWin() throws IOException, InterruptedException {
        MacroMap env = this.info.getEnvironment().clone();
        if (this.info.isUnbuffer()) {
            UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), env);
        }
        ProcessBuilder pb = new ProcessBuilder(this.hostInfo.getShell(), "-s");
        String workingDirectory = this.info.getWorkingDirectory(true);
        if (workingDirectory != null) {
            File wd = new File(workingDirectory);
            if (!wd.exists()) {
                throw new FileNotFoundException(LocalNativeProcess.loc("NativeProcess.noSuchDirectoryError.text", wd.getAbsolutePath()));
            }
            pb.directory(wd);
        }
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        this.process = pb.start();
        OutputStream toProcessStream = this.process.getOutputStream();
        InputStream fromProcessStream = this.process.getInputStream();
        this.setErrorStream(this.process.getErrorStream());
        this.setInputStream(fromProcessStream);
        this.setOutputStream(toProcessStream);
        toProcessStream.write("echo $$\n".getBytes());
        toProcessStream.flush();
        EnvWriter ew = new EnvWriter(toProcessStream, false);
        ew.write(env);
        if (this.info.getInitialSuspend()) {
            toProcessStream.write("ITS_TIME_TO_START=\n".getBytes());
            toProcessStream.write("trap 'ITS_TIME_TO_START=1' CONT\n".getBytes());
            toProcessStream.write("while [ -z \"$ITS_TIME_TO_START\" ]; do sleep 1; done\n".getBytes());
        }
        toProcessStream.write(("exec " + this.info.getCommandLineForShell() + "\n").getBytes());
        toProcessStream.flush();
        this.creation_ts = System.nanoTime();
        this.readPID(fromProcessStream);
    }

    private void createWin() throws IOException, InterruptedException {
        String wdir;
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        MacroMap jointEnv = MacroMap.forExecEnv(ExecutionEnvironmentFactory.getLocal());
        jointEnv.putAll(this.info.getEnvironment());
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.info.isUnbuffer()) {
            UnbufferSupport.initUnbuffer(this.info.getExecutionEnvironment(), jointEnv);
        }
        pb.environment().clear();
        for (Map.Entry<String, String> envEntry : jointEnv.entrySet()) {
            pb.environment().put(envEntry.getKey(), envEntry.getValue());
        }
        pb.command(this.info.getCommand());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(String.format("Command: %s", this.info.getCommand()));
        }
        if ((wdir = this.info.getWorkingDirectory(true)) != null) {
            File wd = new File(wdir);
            if (!wd.exists()) {
                throw new FileNotFoundException(LocalNativeProcess.loc("NativeProcess.noSuchDirectoryError.text", wd.getAbsolutePath()));
            }
            pb.directory(wd);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(String.format("Working directory: %s", wdir));
            }
        }
        this.process = pb.start();
        this.creation_ts = System.nanoTime();
        this.errorPipedOutputStream = new PipedOutputStream();
        this.errorPipedInputStream = new PipedInputStream(this.errorPipedOutputStream);
        this.setErrorStream(new SequenceInputStream(this.process.getErrorStream(), this.errorPipedInputStream));
        this.setInputStream(this.process.getInputStream());
        this.setOutputStream(this.process.getOutputStream());
        int newPid = 12345;
        try {
            String className = this.process.getClass().getName();
            if ("java.lang.Win32Process".equals(className) || "java.lang.ProcessImpl".equals(className)) {
                Field f = this.process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long phandle = f.getLong(this.process);
                Win32APISupport kernel = Win32APISupport.instance;
                Win32APISupport.HANDLE handle = new Win32APISupport.HANDLE();
                handle.setPointer(Pointer.createConstant((long)phandle));
                newPid = kernel.GetProcessId(handle);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(("" + newPid).getBytes());
        this.readPID(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int waitResult() throws InterruptedException {
        if (this.process == null) {
            return -1;
        }
        try {
            int exitcode = this.process.waitFor();
            if (exitcode == -1073741515 && Utilities.isWindows()) {
                LocalNativeProcess localNativeProcess = this;
                synchronized (localNativeProcess) {
                    if (!this.win1073741515added && this.errorPipedOutputStream != null) {
                        String exec;
                        StringBuilder cmd = new StringBuilder();
                        Iterator<String> iterator = this.info.getCommand().iterator();
                        if (this.info.isPtyMode()) {
                            exec = iterator.next();
                            String ptyUtilityPath = null;
                            try {
                                ptyUtilityPath = PtyUtility.getInstance().getPath(ExecutionEnvironmentFactory.getLocal());
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            if (ptyUtilityPath != null && exec.equals(ptyUtilityPath)) {
                                exec = iterator.next();
                                exec = exec.substring(1, exec.length() - 1);
                                exec = WindowsSupport.getInstance().convertToWindowsPath(exec);
                            }
                        } else {
                            exec = iterator.next();
                        }
                        if (exec.contains(" ")) {
                            cmd.append('\"').append(exec).append('\"').append(' ');
                        } else {
                            cmd.append(exec).append(' ');
                        }
                        while (iterator.hasNext()) {
                            cmd.append(iterator.next()).append(' ');
                        }
                        String errorMsg = LocalNativeProcess.loc("LocalNativeProcess.windowsProcessStartFailed.1073741515.text", cmd.toString());
                        if (this.info.isPtyMode()) {
                            errorMsg = errorMsg.replaceAll("\n", "\n\r");
                        }
                        try {
                            Charset charset = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
                            this.errorPipedOutputStream.write(errorMsg.getBytes(charset));
                            this.errorPipedOutputStream.flush();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        this.win1073741515added = true;
                    }
                }
            }
            int n = exitcode;
            return n;
        }
        finally {
            try {
                if (this.errorPipedOutputStream != null) {
                    this.errorPipedOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected int destroyImpl() {
        if (this.process != null) {
            this.process.destroy();
            return 1;
        }
        return 0;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(LocalNativeProcess.class, (String)key, (Object[])params);
    }
}

