/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.HelperUtility;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.ShellSession;
import org.openide.util.Exceptions;

public final class Stat {
    private static final java.util.logging.Logger LOG = Logger.getInstance();
    private final long inode;
    private final long ctime;
    private static final HelperUtility statHelperUtility = new HelperUtility("bin/nativeexecution/$osname-${platform}$_isa/stat");

    public static Stat get(String filename, ExecutionEnvironment exEnv) {
        try {
            String[] res = ShellSession.execute(exEnv, statHelperUtility.getPath(exEnv) + " " + filename);
            if (res.length > 1) {
                return new Stat(Long.valueOf(res[0].split(": ")[1].trim()), Long.valueOf(res[1].split(": ")[1].trim()));
            }
            LOG.log(Level.WARNING, "stat result for file {0} is incorrect: {1}", new Object[]{filename, res});
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private Stat(long inode, long ctime) {
        this.inode = inode;
        this.ctime = ctime;
    }

    public long getCtime() {
        return this.ctime;
    }

    public long getInode() {
        return this.inode;
    }

    public String toString() {
        return "inode=" + this.inode + ", " + "ctime=" + this.ctime;
    }
}

