/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.jsch.JSchChannelsSupport;
import org.netbeans.modules.nativeexecution.support.Authentication;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.ui.AuthTypeSelectorDlg;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class JSchConnectionTask
implements Cancellable {
    private static final RequestProcessor connectorThread = new RequestProcessor("ConnectionManager queue", 1);
    private static final int SOCKET_CREATION_TIMEOUT = Integer.getInteger("socket.connection.timeout", 10000);
    private static final java.util.logging.Logger log = Logger.getInstance();
    private final JSch jsch;
    private final ExecutionEnvironment env;
    private AtomicReference<Future<Result>> resultRef = new AtomicReference();
    private volatile boolean cancelled;

    public JSchConnectionTask(JSch jsch, ExecutionEnvironment env) {
        this.jsch = jsch;
        this.env = env;
        this.cancelled = false;
    }

    public synchronized void start() {
        if (this.resultRef.get() == null) {
            Future result = connectorThread.submit((Callable)new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    return JSchConnectionTask.this.connect();
                }
            });
            this.resultRef.set(result);
        }
    }

    private Result connect() throws Exception {
        try {
            try {
                this.env.prepareForConnection();
            }
            catch (Throwable th) {
                return new Result(null, new Problem(ProblemType.ENV_PREPARE_ERROR, th));
            }
            if (this.cancelled) {
                return new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
            }
            if (!this.isReachable()) {
                return new Result(null, new Problem(ProblemType.HOST_UNREACHABLE));
            }
            if (this.cancelled) {
                return new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
            }
            if (!JSchConnectionTask.initJsch(this.env)) {
                return new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
            }
            JSchChannelsSupport cs = new JSchChannelsSupport(this.jsch, this.env);
            cs.connect();
            return new Result(cs, null);
        }
        catch (JSchException e) {
            log.log(Level.FINE, "JSchException connecting to " + this.env, e);
            if (e.getMessage().equals("Auth cancel")) {
                return new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
            }
            if (e.getMessage().contains("java.net.SocketTimeoutException") || e.getMessage().contains("timeout")) {
                return new Result(null, new Problem(ProblemType.CONNECTION_TIMEOUT, e));
            }
            return new Result(null, new Problem(ProblemType.CONNECTION_FAILED, e));
        }
        catch (CancellationException ex) {
            log.log(Level.FINE, "CancellationException", ex);
            return new Result(null, new Problem(ProblemType.CONNECTION_CANCELLED));
        }
        catch (Throwable th) {
            return new Result(null, new Problem(ProblemType.CONNECTION_FAILED, th));
        }
    }

    private static boolean initJsch(ExecutionEnvironment env) {
        Authentication auth = Authentication.getFor(env);
        if (!auth.isDefined()) {
            AuthTypeSelectorDlg dlg = new AuthTypeSelectorDlg();
            if (!dlg.initAuthentication(auth)) {
                return false;
            }
        } else {
            auth.apply();
        }
        return true;
    }

    public Problem getProblem() throws InterruptedException, ExecutionException {
        Future<Result> result = this.resultRef.get();
        if (result == null) {
            throw new IllegalStateException("Not started yet");
        }
        return result.get().problem;
    }

    public JSchChannelsSupport getResult() throws InterruptedException, ExecutionException {
        Future<Result> result = this.resultRef.get();
        if (result == null) {
            throw new IllegalStateException("Not started yet");
        }
        return result.get().cs;
    }

    private boolean isReachable() throws IOException {
        Callable<Boolean> checker = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Socket socket = new Socket();
                InetSocketAddress addressToConnect = new InetSocketAddress(JSchConnectionTask.this.env.getHostAddress(), JSchConnectionTask.this.env.getSSHPort());
                try {
                    socket.connect(addressToConnect, SOCKET_CREATION_TIMEOUT);
                }
                catch (Exception ioe) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    socket.close();
                }
                return true;
            }
        };
        Future<Boolean> task = NativeTaskExecutorService.submit(checker, "Host " + this.env.getHost() + " availability test");
        while (!this.cancelled && !task.isDone()) {
            try {
                task.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
            }
            catch (TimeoutException ex) {}
        }
        boolean result = false;
        if (task.isDone()) {
            try {
                result = task.get();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    private static final class Result {
        public final JSchChannelsSupport cs;
        public final Problem problem;

        public Result(JSchChannelsSupport cs, Problem problem) {
            this.cs = cs;
            this.problem = problem;
        }
    }

    public static enum ProblemType {
        ENV_PREPARE_ERROR,
        AUTH_FAIL,
        HOST_UNREACHABLE,
        CONNECTION_CANCELLED,
        CONNECTION_FAILED,
        CONNECTION_TIMEOUT;

    }

    public static final class Problem {
        public final ProblemType type;
        public final Throwable cause;

        public Problem(ProblemType type) {
            this(type, null);
        }

        public Problem(ProblemType type, Throwable cause) {
            this.type = type;
            this.cause = cause;
        }
    }
}

