/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.support.ui.CertPassphraseDlg;
import org.netbeans.modules.nativeexecution.support.ui.PasswordDlg;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class RemoteUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private static final Object lock = RemoteUserInfo.class.getName() + "Lock";
    private static final PasswordManager pm = PasswordManager.getInstance();
    private final Component parent;
    private final ExecutionEnvironment env;
    private volatile Component parentWindow = null;
    private String passphrase = null;
    private volatile String password = null;
    private final boolean allowInterraction;

    public RemoteUserInfo(ExecutionEnvironment env, boolean allowToAskForPassword) {
        this.env = env;
        this.allowInterraction = allowToAskForPassword;
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                RemoteUserInfo.this.parentWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        this.parent = this.parentWindow;
    }

    public String getPassphrase() {
        String result = this.passphrase;
        this.passphrase = null;
        return result;
    }

    public String getPassword() {
        char[] saved = pm.getPassword(this.env);
        if (saved != null) {
            return new String(saved);
        }
        String result = this.password;
        this.password = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promptPassword(String message) {
        Object object = lock;
        synchronized (object) {
            boolean result;
            if (pm.getPassword(this.env) != null) {
                return true;
            }
            if (!this.allowInterraction) {
                return false;
            }
            PasswordDlg pwdDlg = new PasswordDlg();
            Object object2 = lock;
            synchronized (object2) {
                result = pwdDlg.askPassword(this.env);
            }
            if (result) {
                char[] clearPassword = pwdDlg.getPassword();
                pm.storePassword(this.env, clearPassword, pwdDlg.isRememberPassword());
                Arrays.fill(clearPassword, '\u0000');
                pwdDlg.clearPassword();
                return true;
            }
            throw new CancellationException(RemoteUserInfo.loc("USER_AUTH_CANCELED", new String[0]));
        }
    }

    public boolean promptPassphrase(String arg0) {
        if (!this.allowInterraction) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            CertPassphraseDlg pwdDlg = new CertPassphraseDlg();
            boolean result = pwdDlg.askPassword(this.env, arg0);
            if (result) {
                this.passphrase = new String(pwdDlg.getPassword());
                pwdDlg.clearPassword();
                return true;
            }
            throw new CancellationException(RemoteUserInfo.loc("USER_AUTH_CANCELED", new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promptYesNo(String str) {
        int foo;
        Object[] options = new Object[]{"yes", "no"};
        Object object = lock;
        synchronized (object) {
            foo = JOptionPane.showOptionDialog(this.parent, str, RemoteUserInfo.loc("TITLE_YN_Warning", new String[0]), -1, 2, null, options, options[0]);
        }
        return foo == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMessage(String message) {
        Object object = lock;
        synchronized (object) {
            JOptionPane.showMessageDialog(this.parent, message);
        }
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length == 1 && !echo[0]) {
            if (!this.promptPassword(RemoteUserInfo.loc("MSG_PasswordInteractive", destination, prompt[0]))) {
                return null;
            }
            return new String[]{this.getPassword()};
        }
        return null;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(RemoteUserInfo.class, (String)key, (Object[])params);
    }
}

