/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.ui.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.support.ui.api.AutocompletionProvider;
import org.openide.util.RequestProcessor;

public abstract class FileNamesCompletionProvider
implements AutocompletionProvider {
    private static final int cacheSizeLimit = 20;
    private static final int cacheLifetime = 600000;
    private final ExecutionEnvironment env;
    private final LinkedList<CachedValue> cache = new LinkedList();
    private final RequestProcessor.Task cleanUpTask;
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final ConnectionListener listener = new Listener();

    public FileNamesCompletionProvider(ExecutionEnvironment env) {
        this.env = env;
        ConnectionManager.getInstance().addConnectionListener(this.listener);
        this.enabled.set(ConnectionManager.getInstance().isConnectedTo(env));
        this.cleanUpTask = RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedList linkedList = FileNamesCompletionProvider.this.cache;
                synchronized (linkedList) {
                    FileNamesCompletionProvider.this.cache.clear();
                }
            }
        }, 600000);
    }

    @Override
    public final List<String> autocomplete(String str) {
        if (!this.enabled.get()) {
            return Collections.emptyList();
        }
        this.cleanUpTask.schedule(600000);
        if (!(str.startsWith(".") || str.startsWith("/") || str.startsWith("~"))) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int idx = str.lastIndexOf(47) + 1;
        String dir = str.substring(0, idx);
        String file = str.substring(idx);
        List<String> content = this.getList(dir);
        for (String c : content) {
            if (!c.startsWith(file)) continue;
            result.add(c);
        }
        return result;
    }

    protected abstract List<String> listDir(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getList(String dir) {
        LinkedList<CachedValue> linkedList = this.cache;
        synchronized (linkedList) {
            for (int i = 0; i < this.cache.size(); ++i) {
                CachedValue cv = this.cache.get(i);
                if (!cv.key.equals(dir)) continue;
                this.cache.remove(i);
                this.cache.add(cv);
                return cv.value;
            }
        }
        List<String> content = this.listDir(dir);
        LinkedList<CachedValue> linkedList2 = this.cache;
        synchronized (linkedList2) {
            this.cache.add(new CachedValue(dir, content));
            while (this.cache.size() > 20) {
                this.cache.removeFirst();
            }
        }
        return content;
    }

    private static final class CachedValue {
        final String key;
        final List<String> value;

        public CachedValue(String key, List<String> value) {
            this.key = key;
            this.value = value;
        }
    }

    private class Listener
    implements ConnectionListener {
        private Listener() {
        }

        @Override
        public void connected(ExecutionEnvironment environment) {
            if (((Object)FileNamesCompletionProvider.this.env).equals(environment)) {
                FileNamesCompletionProvider.this.enabled.set(true);
            }
        }

        @Override
        public void disconnected(ExecutionEnvironment environment) {
            if (((Object)FileNamesCompletionProvider.this.env).equals(environment)) {
                FileNamesCompletionProvider.this.enabled.set(false);
            }
        }
    }
}

