/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws;

import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.impl.IdeJaxWsStack;
import org.netbeans.modules.websvc.wsstack.jaxws.impl.JdkJaxWsStack;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.openide.util.Lookup;

public class JaxWsStackProvider {
    private static WSStack<JaxWs> jdkJaxWsStack;
    private static WSStack<JaxWs> ideJaxWsStack;

    public static WSStack<JaxWs> getJaxWsStack(J2eePlatform j2eePlatform) {
        return WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class);
    }

    public static WSTool getJaxWsStackTool(J2eePlatform j2eePlatform, JaxWs.Tool toolId) {
        WSStack wsStack = WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class);
        if (wsStack != null) {
            return wsStack.getWSTool((WSStack.Tool)toolId);
        }
        return null;
    }

    public static synchronized WSStack<JaxWs> getJdkJaxWsStack() {
        String jaxWsVersion;
        if (jdkJaxWsStack == null && (jaxWsVersion = JaxWsStackProvider.getJaxWsStackVersion(System.getProperty("java.version"))) != null) {
            jdkJaxWsStack = WSStackFactory.createWSStack(JaxWs.class, new JdkJaxWsStack(jaxWsVersion), (WSStack.Source)WSStack.Source.JDK);
        }
        return jdkJaxWsStack;
    }

    public static synchronized WSStack<JaxWs> getIdeJaxWsStack() {
        if (ideJaxWsStack == null) {
            ideJaxWsStack = WSStackFactory.createWSStack(JaxWs.class, new IdeJaxWsStack(), (WSStack.Source)WSStack.Source.IDE);
        }
        return ideJaxWsStack;
    }

    private static String getJaxWsStackVersion(String java_version) {
        if (java_version.startsWith("1.6")) {
            int index = java_version.indexOf("_");
            if (index > 0) {
                String releaseVersion = JaxWsStackProvider.parseReleaseVersion(java_version.substring(index + 1));
                Integer rv = Integer.valueOf(releaseVersion);
                if (rv >= 4) {
                    return "2.1.1";
                }
                return "2.0";
            }
            return null;
        }
        try {
            Float version = Float.valueOf(java_version.substring(0, 3));
            if ((double)version.floatValue() > 1.6) {
                return "2.1.3";
            }
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String parseReleaseVersion(String releaseVersion) {
        char c;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < releaseVersion.length() && Character.isDigit(c = releaseVersion.charAt(i)); ++i) {
            buf.append(c);
        }
        return buf.toString();
    }
}

