/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.php.project.connections.ui.transfer.table.SortColumnHeaderRenderer;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileTableModel;
import org.netbeans.modules.php.project.connections.ui.transfer.table.TransferFileUnit;

final class TransferFilterTable
extends JTable {
    private static final long serialVersionUID = -1378410694823823371L;
    private static final int DARKER_COLOR_COMPONENT = 10;
    private final TransferFileTableModel model;
    private int rowHeightFontBase = -1;

    TransferFilterTable(TransferFileTableModel model) {
        super(model);
        this.model = model;
        this.setShowGrid(false);
        this.setColumnsSize();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.revalidate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getParent().setBackground(this.getBackground());
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int colIndex;
        int realColumnIndex;
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        tip = this.model.getToolTipText(rowIndex, realColumnIndex = this.convertColumnIndexToModel(colIndex = this.columnAtPoint(p)));
        return tip != null ? tip : super.getToolTipText(e);
    }

    private void setColumnsSize() {
        int columnCount = this.model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn activeColumn = this.getColumnModel().getColumn(i);
            activeColumn.setPreferredWidth(this.model.getPreferredWidth(this.getTableHeader(), i));
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        Color bgColor = this.getBackground();
        Color bgColorDarker = TransferFilterTable.getDarkerColor(bgColor);
        TransferFileUnit u = this.model.getUnitAtRow(row);
        if (u != null && !u.canBeMarked()) {
            c.setForeground(Color.gray);
        } else {
            c.setFont(this.getFont());
            if (this.isRowSelected(row)) {
                c.setForeground(this.getSelectionForeground());
            } else {
                c.setForeground(this.getForeground());
            }
        }
        if (!this.isCellSelected(row, column)) {
            if (row % 2 == 0) {
                c.setBackground(bgColorDarker);
            } else {
                c.setBackground(bgColor);
            }
        }
        if (this.rowHeightFontBase < 0) {
            Font font = c.getFont();
            FontMetrics fontMetrics = c.getFontMetrics(font);
            int def = new JTable().getRowHeight();
            this.rowHeightFontBase = Math.max(def, fontMetrics.getHeight());
            this.setRowHeight(this.rowHeightFontBase);
        }
        return c;
    }

    static Color getDarkerColor(Color color) {
        return new Color(Math.abs(color.getRed() - 10), Math.abs(color.getGreen() - 10), Math.abs(color.getBlue() - 10));
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new TransferFilterTableHeader();
    }

    private final class TransferFilterTableHeader
    extends JTableHeader {
        private static final long serialVersionUID = 19524897514214165L;
        private SortColumnHeaderRenderer sortingRenderer;
        int selectedRow;

        TransferFilterTableHeader() {
            super(TransferFilterTable.this.getColumnModel());
            this.selectedRow = -1;
            this.setTable(TransferFilterTable.this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TransferFilterTableHeader.this.setSelectedRow();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    assert (TransferFilterTableHeader.this.sortingRenderer != null) : "Sorting renderer cannot be null.";
                    TransferFileUnit selectedUnit = TransferFilterTableHeader.this.getSelectedUnit();
                    int column = TransferFilterTableHeader.this.getTable().columnAtPoint(e.getPoint());
                    TransferFilterTableHeader.this.sortingRenderer.setSorting(column);
                    TransferFilterTableHeader.this.repaint();
                    TransferFilterTableHeader.this.scroolToUnit(selectedUnit);
                }
            });
            this.getModel().addUpdateUnitListener(new TransferFileTableChangeListener(){

                @Override
                public void updateUnitsChanged() {
                    assert (TransferFilterTableHeader.this.sortingRenderer != null) : "Sorting renderer cannot be null.";
                    TransferFilterTableHeader.this.setSelectedRow();
                    TransferFileUnit selectedUnit = TransferFilterTableHeader.this.getSelectedUnit();
                    TransferFilterTableHeader.this.sortingRenderer.sort();
                    TransferFilterTableHeader.this.scroolToUnit(selectedUnit);
                }

                @Override
                public void filterChanged() {
                }
            });
            this.setReorderingAllowed(false);
        }

        @Override
        public void setDraggedColumn(TableColumn aColumn) {
            if (aColumn != null && aColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(aColumn);
        }

        @Override
        public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
            if (!(defaultRenderer instanceof SortColumnHeaderRenderer)) {
                this.sortingRenderer = new SortColumnHeaderRenderer(this.getModel(), defaultRenderer);
                defaultRenderer = this.sortingRenderer;
            }
            super.setDefaultRenderer(defaultRenderer);
        }

        void setSelectedRow() {
            this.selectedRow = this.getTable().getSelectedRow();
        }

        TransferFileUnit getSelectedUnit() {
            TransferFileUnit selectedUnit = null;
            TransferFileTableModel m = this.getModel();
            if (this.selectedRow != -1) {
                selectedUnit = m.getUnitAtRow(this.selectedRow);
            }
            return selectedUnit;
        }

        void scroolToUnit(TransferFileUnit selectedUnit) {
            if (selectedUnit == null) {
                return;
            }
            TransferFileTableModel m = this.getModel();
            int newRow = m.getRowForUnit(selectedUnit);
            assert (newRow != -1) : String.format("Previoulsy selecte unit %s has to be found.", selectedUnit);
            this.getTable().getSelectionModel().setSelectionInterval(newRow, newRow);
            Rectangle rect = this.getTable().getCellRect(newRow, 0, true);
            this.getTable().scrollRectToVisible(rect);
        }

        private TransferFileTableModel getModel() {
            return (TransferFileTableModel)TransferFilterTable.this.getModel();
        }
    }
}

