/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.ui.actions.support.DebugScript;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class DefaultScriptProvider
implements DebugScript.Provider {
    protected static final ExecutionDescriptor.LineConvertorFactory PHP_LINE_CONVERTOR_FACTORY = new PhpLineConvertorFactory();
    private static final Project PROJECT = new DummyProject();
    protected final PhpProgram program;
    protected final File file;

    public DefaultScriptProvider(File file) {
        assert (file != null);
        this.file = file;
        PhpProgram prg = null;
        try {
            prg = this.getPhpProgram();
            assert (prg.isValid()) : String.format("php program %s must be valid", prg);
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage());
        }
        this.program = prg;
    }

    @Override
    public ExecutionDescriptor getDescriptor() throws IOException {
        RunScript.InOutPostRedirector redirector = new RunScript.InOutPostRedirector(this.file);
        return PhpProgram.getExecutionDescriptor().frontWindow(PhpOptions.getInstance().isOpenResultInOutputWindow()).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory").outConvertorFactory(PHP_LINE_CONVERTOR_FACTORY).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)redirector).postExecution((Runnable)redirector).charset(FileEncodingQuery.getDefaultEncoding());
    }

    @Override
    public ExternalProcessBuilder getProcessBuilder() {
        assert (this.isValid());
        ExternalProcessBuilder builder = this.program.getProcessBuilder().addArgument(this.file.getAbsolutePath());
        builder = builder.workingDirectory(this.file.getParentFile());
        return builder;
    }

    @Override
    public String getOutputTabTitle() {
        assert (this.isValid());
        return String.format("%s - %s", this.program.getProgram(), this.file.getName());
    }

    @Override
    public boolean isValid() {
        return this.program != null && this.program.isValid();
    }

    protected PhpProgram getPhpProgram() throws PhpProgram.InvalidPhpProgramException {
        return PhpInterpreter.getDefault();
    }

    @Override
    public Project getProject() {
        return PROJECT;
    }

    @Override
    public FileObject getStartFile() {
        return FileUtil.toFileObject((File)this.file);
    }

    @Override
    public List<Pair<String, String>> getDebugPathMapping() {
        return Collections.emptyList();
    }

    @Override
    public Pair<String, Integer> getDebugProxy() {
        return null;
    }

    private static final class DummyProject
    implements Project {
        private DummyProject() {
        }

        public FileObject getProjectDirectory() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Lookup getLookup() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class PhpLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private PhpLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            LineConvertor[] lineConvertors = new LineConvertor[PhpInterpreter.LINE_PATTERNS.length];
            int i = 0;
            for (Pattern linePattern : PhpInterpreter.LINE_PATTERNS) {
                lineConvertors[i++] = LineConvertors.filePattern(null, (Pattern)linePattern, null, (int)1, (int)2);
            }
            return LineConvertors.proxy((LineConvertor[])lineConvertors);
        }
    }
}

