/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.nodes.MavenProjectNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public class LogicalViewProviderImpl
implements LogicalViewProvider {
    private final NbMavenProjectImpl project;

    public LogicalViewProviderImpl(NbMavenProjectImpl proj) {
        this.project = proj;
    }

    public Node createLogicalView() {
        return new MavenProjectNode(LogicalViewProviderImpl.createLookup(this.project), this.project);
    }

    private static Lookup createLookup(NbMavenProjectImpl project) {
        if (!project.getProjectDirectory().isValid()) {
            return Lookups.fixed((Object[])new Object[]{project});
        }
        DataFolder rootFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        SearchInfo info = SearchInfoFactory.createSearchInfo((FileObject)rootFolder.getPrimaryFile(), (boolean)true, (FileObjectFilter[])new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER});
        return Lookups.fixed((Object[])new Object[]{project, rootFolder, info});
    }

    public Node findPath(Node node, Object target) {
        NbMavenProjectImpl proj = (NbMavenProjectImpl)node.getLookup().lookup(NbMavenProjectImpl.class);
        if (proj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            int i;
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!proj.equals(owner)) {
                return null;
            }
            Node[] nodes = node.getChildren().getNodes(true);
            for (i = 0; i < nodes.length; ++i) {
                Node result = PackageView.findPath((Node)nodes[i], (Object)target);
                if (result == null) continue;
                return result;
            }
            for (i = 0; i < nodes.length; ++i) {
                FindDelegate deleg = (FindDelegate)nodes[i].getLookup().lookup(FindDelegate.class);
                if (deleg != null) {
                    for (Node n : deleg.getDelegates(nodes[i])) {
                        Node result = PackageView.findPath((Node)n, (Object)fo);
                        if (result != null) {
                            return result;
                        }
                        Node found = this.findNodeByFileDataObject(n, fo);
                        if (found == null) continue;
                        return found;
                    }
                    continue;
                }
                Node found = this.findNodeByFileDataObject(nodes[i], fo);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    private Node findNodeByFileDataObject(Node node, FileObject fo) {
        DataObject dobj;
        FileObject xfo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (xfo == null && (dobj = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            xfo = dobj.getPrimaryFile();
        }
        if (xfo != null) {
            if (xfo.equals(fo)) {
                return node;
            }
            if (FileUtil.isParentOf((FileObject)xfo, (FileObject)fo)) {
                FileObject folder = fo.isFolder() ? fo : fo.getParent();
                String relPath = FileUtil.getRelativePath((FileObject)xfo, (FileObject)folder);
                ArrayList<String> path = new ArrayList<String>();
                StringTokenizer strtok = new StringTokenizer(relPath, "/");
                while (strtok.hasMoreTokens()) {
                    String token = strtok.nextToken();
                    path.add(token);
                }
                try {
                    Node folderNode;
                    Node node2 = folderNode = folder.equals(xfo) ? node : NodeOp.findPath((Node)node, Collections.enumeration(path));
                    if (fo.isFolder()) {
                        return folderNode;
                    }
                    Node[] childs = folderNode.getChildren().getNodes(true);
                    for (int j = 0; j < childs.length; ++j) {
                        DataObject dobj2 = (DataObject)childs[j].getLookup().lookup(DataObject.class);
                        if (dobj2 == null || !dobj2.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                        return childs[j];
                    }
                }
                catch (NodeNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static interface FindDelegate {
        public Node[] getDelegates(Node var1);
    }
}

