/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.LookupMerger;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenProjectPropsImpl {
    public static final String NAMESPACE = "http://www.netbeans.org/ns/maven-properties-data/1";
    static String ROOT = "properties";
    private boolean transaction = false;
    private TreeMap<String, String> transPropsShared;
    private TreeMap<String, String> transPropsPrivate;
    private AuxiliaryConfiguration aux;
    private boolean sharedChanged;
    private final NbMavenProjectImpl nbprji;

    MavenProjectPropsImpl(AuxiliaryConfiguration aux, NbMavenProjectImpl pr) {
        this.aux = aux;
        this.nbprji = pr;
    }

    private AuxiliaryConfiguration getAuxConf() {
        return this.aux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, boolean shared) {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            return this.get(key, shared, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, boolean shared, boolean usePom) {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            String val;
            if (this.transaction) {
                if (shared && this.transPropsShared.containsKey(key)) {
                    return this.transPropsShared.get(key);
                }
                if (!shared && this.transPropsPrivate.containsKey(key)) {
                    return this.transPropsPrivate.get(key);
                }
            } else {
                TreeMap<String, String> props = this.readProperties(this.getAuxConf(), shared);
                String ret = props.get(key);
                if (ret != null) {
                    return ret;
                }
            }
            if (shared && usePom && (val = this.nbprji.getOriginalMavenProject().getProperties().getProperty(key)) != null) {
                return val;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value, boolean shared) {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            if (shared) {
                // empty if block
            }
            if (this.transaction) {
                if (shared) {
                    this.sharedChanged |= !Utilities.compareObjects((Object)value, (Object)this.transPropsShared.put(key, value));
                } else {
                    this.transPropsPrivate.put(key, value);
                }
            } else {
                this.writeAuxiliaryData(this.getAuxConf(), key, value, shared);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> listKeys(boolean shared) {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            TreeMap<String, String> props = this.readProperties(this.getAuxConf(), shared);
            if (shared) {
                Properties mvnprops = this.nbprji.getOriginalMavenProject().getProperties();
                for (Object prop : mvnprops.keySet()) {
                    props.put((String)prop, "any");
                }
            }
            return props.keySet();
        }
    }

    private void writeAuxiliaryData(AuxiliaryConfiguration conf, String property, String value, boolean shared) {
        Element enEl;
        Element el = this.getOrCreateRootElement(conf, shared);
        NodeList list = el.getElementsByTagNameNS(NAMESPACE, property);
        if (list.getLength() > 0) {
            enEl = (Element)list.item(0);
        } else {
            enEl = el.getOwnerDocument().createElementNS(NAMESPACE, property);
            el.appendChild(enEl);
        }
        if (value != null) {
            enEl.setTextContent(value);
        } else {
            el.removeChild(enEl);
        }
        conf.putConfigurationFragment(el, shared);
    }

    private void writeAuxiliaryData(AuxiliaryConfiguration conf, TreeMap<String, String> props, boolean shared) {
        Element el = this.getOrCreateRootElement(conf, shared);
        for (String key : props.keySet()) {
            Element enEl;
            NodeList list = el.getElementsByTagNameNS(NAMESPACE, key);
            if (list.getLength() > 0) {
                enEl = (Element)list.item(0);
            } else {
                enEl = el.getOwnerDocument().createElementNS(NAMESPACE, key);
                el.appendChild(enEl);
            }
            String value = props.get(key);
            if (value != null) {
                enEl.setTextContent(value);
                continue;
            }
            el.removeChild(enEl);
        }
        conf.putConfigurationFragment(el, shared);
    }

    private Element getOrCreateRootElement(AuxiliaryConfiguration conf, boolean shared) {
        Element el = conf.getConfigurationFragment(ROOT, NAMESPACE, shared);
        if (el == null) {
            el = XMLUtil.createDocument((String)ROOT, (String)NAMESPACE, null, null).getDocumentElement();
            if (shared) {
                Comment comment = el.getOwnerDocument().createComment("\nProperties that influence various parts of the IDE, especially code formatting and the like. \nYou can copy and paste the single properties, into the pom.xml file and the IDE will pick them up.\nThat way multiple projects can share the same settings (useful for formatting rules for example).\nAny value defined here will override the pom.xml file value but is only applicable to the current project.\n");
                el.appendChild(comment);
            }
        }
        return el;
    }

    private TreeMap<String, String> readProperties(AuxiliaryConfiguration aux, boolean shared) {
        NodeList list;
        TreeMap<String, String> props = new TreeMap<String, String>();
        Element el = aux.getConfigurationFragment(ROOT, NAMESPACE, shared);
        if (el != null && (list = el.getChildNodes()).getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node nd = list.item(i);
                if (!(nd instanceof Element)) continue;
                Element enEl = (Element)nd;
                props.put(enEl.getNodeName(), enEl.getTextContent());
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<String, String> getRawProperties(boolean shared) {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            return this.readProperties(this.getAuxConf(), shared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction() {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            this.transaction = true;
            this.transPropsShared = this.getRawProperties(true);
            this.transPropsPrivate = this.getRawProperties(false);
            this.sharedChanged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            this.transaction = false;
            if (this.transPropsShared == null) {
                Logger.getLogger(MavenProjectPropsImpl.class.getName()).info("Commiting a transaction that was cancelled.");
                return;
            }
            if (this.sharedChanged) {
                this.writeAuxiliaryData(this.getAuxConf(), this.transPropsShared, true);
            }
            this.writeAuxiliaryData(this.getAuxConf(), this.transPropsPrivate, false);
            this.transPropsPrivate = null;
            this.transPropsShared = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTransaction() {
        NbMavenProjectImpl nbMavenProjectImpl = this.nbprji;
        synchronized (nbMavenProjectImpl) {
            this.transaction = false;
            this.transPropsPrivate = null;
            this.transPropsShared = null;
        }
    }

    static class MergedAuxProperties
    implements AuxiliaryProperties {
        Lookup.Result<AuxiliaryProperties> props;
        private MavenProjectPropsImpl primary;

        private MergedAuxProperties(Lookup lookup, MavenProjectPropsImpl primary) {
            this.props = lookup.lookupResult(AuxiliaryProperties.class);
            this.primary = primary;
        }

        public String get(String key, boolean shared) {
            String toRet;
            block1: {
                AuxiliaryProperties prop;
                toRet = this.primary.get(key, shared);
                if (toRet != null) break block1;
                Iterator i$ = this.props.allInstances().iterator();
                while (i$.hasNext() && (toRet = (prop = (AuxiliaryProperties)i$.next()).get(key, shared)) == null) {
                }
            }
            return toRet;
        }

        public void put(String key, String value, boolean shared) {
            this.primary.put(key, value, shared);
        }

        public Iterable<String> listKeys(boolean shared) {
            TreeSet<String> toRet = new TreeSet<String>();
            Iterator<String> s = this.primary.listKeys(shared).iterator();
            while (s.hasNext()) {
                toRet.add(s.next());
            }
            for (AuxiliaryProperties aux : this.props.allInstances()) {
                s = aux.listKeys(shared).iterator();
                while (s.hasNext()) {
                    toRet.add(s.next());
                }
            }
            return toRet;
        }
    }

    static class Merger
    implements LookupMerger<AuxiliaryProperties> {
        private MavenProjectPropsImpl primary;

        Merger(MavenProjectPropsImpl primary) {
            this.primary = primary;
        }

        public Class<AuxiliaryProperties> getMergeableClass() {
            return AuxiliaryProperties.class;
        }

        public AuxiliaryProperties merge(Lookup lookup) {
            return new MergedAuxProperties(lookup, this.primary);
        }
    }
}

