/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class MavenSourcesImpl
implements Sources,
SourceGroupModifierImplementation {
    public static final String TYPE_OTHER = "Resources";
    public static final String TYPE_TEST_OTHER = "TestResources";
    public static final String TYPE_GEN_SOURCES = "GeneratedSources";
    public static final String TYPE_GROOVY = "groovy";
    public static final String TYPE_SCALA = "scala";
    public static final String NAME_GROOVYSOURCE = "81GroovySourceRoot";
    public static final String NAME_GROOVYTESTSOURCE = "82GroovyTestSourceRoot";
    public static final String NAME_SCALASOURCE = "91ScalaSourceRoot";
    public static final String NAME_SCALATESTSOURCE = "92ScalaTestSourceRoot";
    public static final String NAME_PROJECTROOT = "ProjectRoot";
    public static final String NAME_XDOCS = "XDocs";
    public static final String NAME_SOURCE = "1SourceRoot";
    public static final String NAME_TESTSOURCE = "2TestSourceRoot";
    public static final String NAME_GENERATED_SOURCE = "6GeneratedSourceRoot";
    private final NbMavenProjectImpl project;
    private final List<ChangeListener> listeners;
    private Map<String, SourceGroup> javaGroup;
    private Map<File, SourceGroup> genSrcGroup;
    private Map<File, OtherGroup> otherMainGroups;
    private Map<File, OtherGroup> otherTestGroups;
    private Map<String, SourceGroup> groovyGroup;
    private Map<String, SourceGroup> scalaGroup;
    private final Object lock = new Object();

    public MavenSourcesImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        this.listeners = new ArrayList<ChangeListener>();
        this.javaGroup = new TreeMap<String, SourceGroup>();
        this.genSrcGroup = new TreeMap<File, SourceGroup>();
        this.otherMainGroups = new TreeMap<File, OtherGroup>();
        this.otherTestGroups = new TreeMap<File, OtherGroup>();
        this.groovyGroup = new TreeMap<String, SourceGroup>();
        this.scalaGroup = new TreeMap<String, SourceGroup>();
        NbMavenProject.addPropertyChangeListener(this.project, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("MavenProject".equals(event.getPropertyName())) {
                    MavenSourcesImpl.this.checkChanges(true, true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChanges(boolean fireChanges, boolean checkAlsoNonJavaStuff) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            MavenProject mp = this.project.getOriginalMavenProject();
            FileObject folder = FileUtilities.convertStringToFileObject(mp.getBuild().getSourceDirectory());
            changed |= this.checkSourceGroupCache(folder, NAME_SOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Sources"), this.javaGroup);
            folder = FileUtilities.convertStringToFileObject(mp.getBuild().getTestSourceDirectory());
            changed |= this.checkSourceGroupCache(folder, NAME_TESTSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Test_Sources"), this.javaGroup);
            changed |= this.checkGeneratedGroupsCache(this.project.getGeneratedSourceRoots());
            folder = FileUtilities.convertURItoFileObject(this.project.getGroovyDirectory(false));
            changed |= this.checkSourceGroupCache(folder, NAME_GROOVYSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_GroovySources"), this.groovyGroup);
            folder = FileUtilities.convertURItoFileObject(this.project.getGroovyDirectory(true));
            changed |= this.checkSourceGroupCache(folder, NAME_GROOVYTESTSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Test_GroovySources"), this.groovyGroup);
            folder = FileUtilities.convertURItoFileObject(this.project.getScalaDirectory(false));
            changed |= this.checkSourceGroupCache(folder, NAME_SCALASOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_ScalaSources"), this.scalaGroup);
            folder = FileUtilities.convertURItoFileObject(this.project.getScalaDirectory(true));
            changed |= this.checkSourceGroupCache(folder, NAME_SCALATESTSOURCE, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Test_ScalaSources"), this.scalaGroup);
            if (checkAlsoNonJavaStuff) {
                changed |= this.checkOtherGroupsCache(this.project.getOtherRoots(false), false);
                changed |= this.checkOtherGroupsCache(this.project.getOtherRoots(true), true);
            }
        }
        if (changed && fireChanges) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> currList;
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            currList = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener list2 : currList) {
            list2.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String str) {
        if ("generic".equals(str)) {
            return new SourceGroup[]{GenericSources.group((Project)this.project, (FileObject)this.project.getProjectDirectory(), (String)NAME_PROJECTROOT, (String)((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName(), null, null)};
        }
        if ("java".equals(str)) {
            ArrayList<SourceGroup> toReturn = new ArrayList<SourceGroup>();
            Object object = this.lock;
            synchronized (object) {
                this.checkChanges(false, false);
                toReturn.addAll(this.javaGroup.values());
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        if (TYPE_GEN_SOURCES.equals(str)) {
            URI[] uris = this.project.getGeneratedSourceRoots();
            ArrayList<SourceGroup> toReturn = new ArrayList<SourceGroup>();
            Object object = this.lock;
            synchronized (object) {
                this.checkGeneratedGroupsCache(uris);
                toReturn.addAll(this.genSrcGroup.values());
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        if (TYPE_OTHER.equals(str) || TYPE_TEST_OTHER.equals(str)) {
            boolean test = TYPE_TEST_OTHER.equals(str);
            ArrayList<OtherGroup> toReturn2 = new ArrayList<OtherGroup>();
            File[] roots = this.project.getOtherRoots(test);
            Object object = this.lock;
            synchronized (object) {
                this.checkOtherGroupsCache(roots, test);
                if (test && !this.otherTestGroups.isEmpty()) {
                    toReturn2.addAll(this.otherTestGroups.values());
                } else if (!test && !this.otherMainGroups.isEmpty()) {
                    toReturn2.addAll(this.otherMainGroups.values());
                }
            }
            SourceGroup[] grp = new SourceGroup[toReturn2.size()];
            grp = toReturn2.toArray(grp);
            return grp;
        }
        if (TYPE_GROOVY.equals(str)) {
            ArrayList<SourceGroup> toReturn = new ArrayList<SourceGroup>();
            Object toReturn2 = this.lock;
            synchronized (toReturn2) {
                this.checkChanges(false, false);
                toReturn.addAll(this.groovyGroup.values());
            }
            SourceGroup[] grp = new SourceGroup[toReturn.size()];
            grp = toReturn.toArray(grp);
            return grp;
        }
        if (TYPE_SCALA.equals(str)) {
            ArrayList<SourceGroup> toReturn = new ArrayList<SourceGroup>();
            SourceGroup[] grp = this.lock;
            synchronized (this.lock) {
                this.checkChanges(false, false);
                toReturn.addAll(this.scalaGroup.values());
                // ** MonitorExit[grp] (shouldn't be in output)
                grp = new SourceGroup[toReturn.size()];
                grp = toReturn.toArray(grp);
                return grp;
            }
        }
        if ("resources".equals(str)) {
            return this.getOrCreateResourceSourceGroup(false, false);
        }
        return new SourceGroup[0];
    }

    private SourceGroup[] getOrCreateResourceSourceGroup(boolean test, boolean create) {
        URI[] uris = this.project.getResources(test);
        if (uris.length > 0) {
            ArrayList<URI> virtuals = new ArrayList<URI>();
            ArrayList<SourceGroup> existing = new ArrayList<SourceGroup>();
            for (URI u : uris) {
                FileObject fo = FileUtilities.convertURItoFileObject(u);
                if (fo == null) {
                    virtuals.add(u);
                    continue;
                }
                existing.add(GenericSources.group((Project)this.project, (FileObject)fo, (String)"resources", (String)NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Project_Resources"), null, null));
            }
            if (create && existing.isEmpty()) {
                File root = new File((URI)virtuals.get(0));
                FileObject fo = null;
                try {
                    fo = FileUtil.createFolder((File)root);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                existing.add(GenericSources.group((Project)this.project, (FileObject)fo, (String)"resources", (String)NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Project_Resources"), null, null));
            }
            return existing.toArray(new SourceGroup[0]);
        }
        return new SourceGroup[0];
    }

    private boolean checkSourceGroupCache(FileObject root, String name, String displayName, Map<String, SourceGroup> groups) {
        SourceGroup group = groups.get(name);
        if (root == null && group != null) {
            groups.remove(name);
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (group == null) {
            group = GenericSources.group((Project)this.project, (FileObject)root, (String)name, (String)displayName, null, null);
            groups.put(name, group);
            changed = true;
        } else if (!group.getRootFolder().equals(root)) {
            group = GenericSources.group((Project)this.project, (FileObject)root, (String)name, (String)displayName, null, null);
            groups.put(name, group);
            changed = true;
        }
        return changed;
    }

    private boolean checkGeneratedGroupsCache(URI[] uris) {
        boolean changed = false;
        ArrayList<File> checked = new ArrayList<File>();
        for (URI u : uris) {
            File file = FileUtil.normalizeFile((File)new File(u));
            FileObject folder = FileUtil.toFileObject((File)file);
            changed |= this.checkGeneratedGroupCache(folder, file, file.getName());
            checked.add(file);
        }
        HashSet<File> currs = new HashSet<File>();
        currs.addAll(this.genSrcGroup.keySet());
        for (File curr : currs) {
            if (checked.contains(curr)) continue;
            this.genSrcGroup.remove(curr);
            changed = true;
        }
        return changed;
    }

    private boolean checkGeneratedGroupCache(FileObject root, File rootFile, String nameSuffix) {
        SourceGroup group = this.genSrcGroup.get(rootFile);
        if (root == null && group != null) {
            this.genSrcGroup.remove(rootFile);
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (group == null) {
            group = new GeneratedGroup(this.project, root, NAME_GENERATED_SOURCE + nameSuffix, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Generated_Sources", (Object)nameSuffix));
            this.genSrcGroup.put(rootFile, group);
            changed = true;
        } else if (!group.getRootFolder().isValid() || !group.getRootFolder().equals(root)) {
            group = new GeneratedGroup(this.project, root, NAME_GENERATED_SOURCE + nameSuffix, NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Generated_Sources", (Object)nameSuffix));
            this.genSrcGroup.put(rootFile, group);
            changed = true;
        }
        return changed;
    }

    private boolean checkOtherGroupsCache(File[] roots, boolean test) {
        boolean ch = false;
        HashSet<File> toRemove = new HashSet<File>(test ? this.otherTestGroups.keySet() : this.otherMainGroups.keySet());
        toRemove.removeAll(Arrays.asList(roots));
        URI[] res = this.project.getResources(test);
        HashSet<File> resources = new HashSet<File>();
        for (URI uRI : res) {
            resources.add(new File(uRI));
        }
        for (Comparable<URI> comparable : roots) {
            ch |= this.checkOtherGroup((File)comparable, (Set<File>)resources, test);
        }
        for (File f : toRemove) {
            ch |= this.checkOtherGroup(f, resources, test);
        }
        return ch;
    }

    private boolean checkOtherGroup(File rootFile, Set<File> resourceRoots, boolean test) {
        boolean wasResourceBefore;
        FileObject root = FileUtil.toFileObject((File)rootFile);
        if (root != null && !root.isFolder()) {
            root = null;
        }
        Map<File, OtherGroup> map = test ? this.otherTestGroups : this.otherMainGroups;
        OtherGroup grp = map.get(rootFile);
        boolean isResourceNow = resourceRoots.contains(rootFile);
        boolean bl = wasResourceBefore = grp != null && grp.getResource() != null;
        if (root == null && grp != null || root != null && grp != null && wasResourceBefore && !isResourceNow) {
            map.remove(rootFile);
            return true;
        }
        if (root == null) {
            return false;
        }
        boolean changed = false;
        if (grp == null || !grp.getRootFolder().isValid() || !grp.getRootFolder().equals(root) || isResourceNow != wasResourceBefore) {
            grp = new OtherGroup(this.project, root, "Resource" + (test ? "Test" : "Main") + root.getNameExt(), root.getName(), test);
            map.put(rootFile, grp);
            changed = true;
        }
        return changed;
    }

    public SourceGroup createSourceGroup(String type, String hint) {
        assert (type != null);
        MavenProject mp = this.project.getOriginalMavenProject();
        File folder = null;
        if ("resources".equals(type)) {
            boolean main = "main".equals(hint);
            SourceGroup[] grps = this.getOrCreateResourceSourceGroup(!main, true);
            if (grps.length > 0) {
                return grps[0];
            }
            return null;
        }
        if ("java".equals(type)) {
            if ("main".equals(hint)) {
                folder = FileUtilities.convertStringToFile(mp.getBuild().getSourceDirectory());
            }
            if ("test".equals(hint)) {
                folder = FileUtilities.convertStringToFile(mp.getBuild().getTestSourceDirectory());
            }
        }
        if (TYPE_GROOVY.equals(type)) {
            if ("main".equals(hint)) {
                folder = new File(this.project.getGroovyDirectory(false));
            }
            if ("test".equals(hint)) {
                folder = new File(this.project.getGroovyDirectory(true));
            }
        }
        if (TYPE_SCALA.equals(type)) {
            if ("main".equals(hint)) {
                folder = new File(this.project.getScalaDirectory(false));
            }
            if ("test".equals(hint)) {
                folder = new File(this.project.getScalaDirectory(true));
            }
        }
        if (folder != null) {
            SourceGroup[] grps;
            folder.mkdirs();
            FileUtil.refreshFor((File[])new File[]{folder});
            this.checkChanges(false, true);
            FileObject fo = FileUtil.toFileObject((File)folder);
            assert (fo != null);
            for (SourceGroup sg : grps = this.getSourceGroups(type)) {
                if (!fo.equals(sg.getRootFolder())) continue;
                return sg;
            }
        }
        return null;
    }

    public boolean canCreateSourceGroup(String type, String hint) {
        return !(!"resources".equals(type) && !"java".equals(type) && !TYPE_GROOVY.equals(type) && !TYPE_SCALA.equals(type) || !"main".equals(hint) && !"test".equals(hint));
    }

    public static final class GeneratedGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private File rootFile;
        private final String name;
        private final String displayName;
        private final Icon icon = null;
        private final Icon openedIcon = null;
        private NbMavenProjectImpl project;

        GeneratedGroup(NbMavenProjectImpl p, FileObject rootFold, String nm, String displayNm) {
            this.project = p;
            this.rootFolder = rootFold;
            this.rootFile = FileUtil.toFile((FileObject)this.rootFolder);
            this.name = nm;
            this.displayName = displayNm != null ? displayNm : NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Root_not_defined");
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public File getRootFolderFile() {
            return this.rootFile;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return opened ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject file) {
            if (file != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)file)) {
                throw new IllegalArgumentException();
            }
            if (this.project != null) {
                if (file.isFolder() && file != this.project.getProjectDirectory() && ProjectManager.getDefault().isProject(file)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)file) != this.project) {
                    return false;
                }
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }

    public static final class OtherGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private File rootFile;
        private final String name;
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        private NbMavenProjectImpl project;
        private Resource resource;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        OtherGroup(NbMavenProjectImpl p, FileObject rootFold, String nm, String displayNm, boolean test) {
            this.project = p;
            this.rootFolder = rootFold;
            this.rootFile = FileUtil.toFile((FileObject)this.rootFolder);
            this.resource = this.checkResource(rootFold, test ? this.project.getOriginalMavenProject().getTestResources() : this.project.getOriginalMavenProject().getResources());
            if (this.resource != null) {
                Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/others-badge.png", (boolean)true);
                this.icon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(false), (Image)badge, (int)8, (int)8));
                this.openedIcon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(true), (Image)badge, (int)8, (int)8));
                this.displayName = this.name = FileUtilities.relativizeFile(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), FileUtilities.convertStringToFile(this.resource.getDirectory()));
            } else {
                this.icon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon(false));
                this.openedIcon = ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon(true));
                this.name = nm;
                this.displayName = displayNm != null ? displayNm : NbBundle.getMessage(MavenSourcesImpl.class, (String)"SG_Root_not_defined");
            }
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public File getRootFolderFile() {
            return this.rootFile;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.resource != null && this.resource.getTargetPath() != null) {
                return this.displayName + " -> " + this.resource.getTargetPath();
            }
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return opened ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject file) {
            File f;
            if (file != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)file)) {
                throw new IllegalArgumentException();
            }
            if (this.project != null) {
                if (file.isFolder() && file != this.project.getProjectDirectory() && ProjectManager.getDefault().isProject(file)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)file) != this.project) {
                    return false;
                }
            }
            if ((f = FileUtil.toFile((FileObject)file)) != null) {
                return SharabilityQuery.getSharability((File)f) != 2;
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.support.removePropertyChangeListener(l);
        }

        private Resource checkResource(FileObject rootFold, List<Resource> list) {
            for (Resource elem : list) {
                URI uri = FileUtilities.getDirURI(this.project.getProjectDirectory(), elem.getDirectory());
                FileObject fo = FileUtilities.convertURItoFileObject(uri);
                if (fo == null || !fo.equals(rootFold)) continue;
                return elem;
            }
            return null;
        }
    }
}

