/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class AddPropertyDialog
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private NbMavenProjectImpl project;
    private JButton okbutton;
    private String goalsText;
    private Pattern COMPLETE = Pattern.compile("(.+)[:](.+)[:](.+)[:](.+)");
    private Pattern SHORT = Pattern.compile("(.+)[:](.+)");
    private JScrollPane jScrollPane2;
    private JLabel lblPropertyExpressions;
    private JTextPane tpDesc;
    private JScrollPane tvExpressions;

    public AddPropertyDialog(NbMavenProjectImpl prj, String goalsText) {
        this.initComponents();
        this.manager = new ExplorerManager();
        this.project = prj;
        this.okbutton = new JButton(NbBundle.getMessage(AddPropertyDialog.class, (String)"BTN_OK"));
        this.manager.setRootContext(Node.EMPTY);
        this.tpDesc.setEditorKit(new HTMLEditorKit());
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] nds = AddPropertyDialog.this.getExplorerManager().getSelectedNodes();
                if (nds.length != 1) {
                    AddPropertyDialog.this.okbutton.setEnabled(false);
                } else {
                    PluginIndexManager.ParameterDetail plg = (PluginIndexManager.ParameterDetail)nds[0].getLookup().lookup(PluginIndexManager.ParameterDetail.class);
                    if (plg != null) {
                        AddPropertyDialog.this.okbutton.setEnabled(true);
                        AddPropertyDialog.this.tpDesc.setText(plg.getHtmlDetails(false));
                    } else {
                        AddPropertyDialog.this.okbutton.setEnabled(false);
                        AddPropertyDialog.this.tpDesc.setText("");
                    }
                }
            }
        });
        ((BeanTreeView)this.tvExpressions).setRootVisible(false);
        ((BeanTreeView)this.tvExpressions).setSelectionMode(0);
        this.goalsText = goalsText;
        RequestProcessor.getDefault().post((Runnable)new Loader());
    }

    public JButton getOkButton() {
        return this.okbutton;
    }

    String getSelectedExpression() {
        PluginIndexManager.ParameterDetail hld;
        Node[] nds = this.getExplorerManager().getSelectedNodes();
        if (nds.length == 1 && (hld = (PluginIndexManager.ParameterDetail)nds[0].getLookup().lookup(PluginIndexManager.ParameterDetail.class)) != null) {
            return hld.getExpression();
        }
        return null;
    }

    private void initComponents() {
        this.tvExpressions = new BeanTreeView();
        this.lblPropertyExpressions = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tpDesc = new JTextPane();
        this.lblPropertyExpressions.setText(NbBundle.getMessage(AddPropertyDialog.class, (String)"AddPropertyDialog.lblPropertyExpressions.text"));
        this.tpDesc.setEditable(false);
        this.jScrollPane2.setViewportView(this.tpDesc);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tvExpressions, GroupLayout.Alignment.LEADING, -1, 433, Short.MAX_VALUE).addComponent(this.lblPropertyExpressions, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 433, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblPropertyExpressions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tvExpressions, -1, 200, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 127, Short.MAX_VALUE).addContainerGap()));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void addPluginNode(String groupId, String artifactId, String version, String mojo, Children.Array rootChilds) {
        if (version == null || groupId == null || artifactId == null) {
            return;
        }
        assert (rootChilds != null);
        Children.Array pluginChilds = new Children.Array();
        try {
            Set exprs = PluginIndexManager.getPluginParameters((String)groupId, (String)artifactId, (String)version, (String)mojo);
            if (exprs != null) {
                for (PluginIndexManager.ParameterDetail el : exprs) {
                    if (el.getExpression() == null) continue;
                    AbstractNode param = new AbstractNode(Children.LEAF, Lookups.singleton((Object)el));
                    param.setIconBaseWithExtension("org/netbeans/modules/maven/customizer/param.png");
                    param.setDisplayName(el.getExpression() + " (" + el.getName() + ")");
                    pluginChilds.add(new Node[]{param});
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(AddPropertyDialog.class.getName()).log(Level.INFO, "Error while retrieving list of expressions", exception);
        }
        AbstractNode plugin = new AbstractNode((Children)pluginChilds);
        plugin.setIconBaseWithExtension("org/netbeans/modules/maven/customizer/mojo.png");
        plugin.setDisplayName(groupId + ":" + artifactId + (mojo != null ? " [" + mojo + "]" : ""));
        rootChilds.add(new Node[]{plugin});
    }

    private String findVersion(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        ArrayList plugins = new ArrayList();
        if (this.project != null) {
            List pm;
            List bld = this.project.getOriginalMavenProject().getBuildPlugins();
            if (bld != null) {
                plugins.addAll(bld);
            }
            if (this.project.getOriginalMavenProject().getPluginManagement() != null && (pm = this.project.getOriginalMavenProject().getPluginManagement().getPlugins()) != null) {
                plugins.addAll(pm);
            }
        }
        for (Plugin plg : plugins) {
            if (!key.equals(plg.getKey())) continue;
            return plg.getVersion();
        }
        return null;
    }

    private class Loader
    implements Runnable {
        private Loader() {
        }

        @Override
        public void run() {
            String[] goals;
            Children.Array rootChilds = new Children.Array();
            for (String goal : goals = StringUtils.split((String)AddPropertyDialog.this.goalsText, (String)" ")) {
                String groupId = null;
                String artifactid = null;
                String version = null;
                String mojo = null;
                Matcher m1 = AddPropertyDialog.this.COMPLETE.matcher(goal);
                if (m1.matches()) {
                    groupId = m1.group(1);
                    artifactid = m1.group(2);
                    version = m1.group(3);
                    mojo = m1.group(4);
                } else {
                    Matcher m2 = AddPropertyDialog.this.SHORT.matcher(goal);
                    if (m2.matches()) {
                        String prefix = m2.group(1);
                        try {
                            Set plgs = PluginIndexManager.getPluginsForGoalPrefix((String)prefix);
                            if (plgs != null && plgs.size() > 0) {
                                mojo = m2.group(2);
                                DefaultArtifactVersion latest = null;
                                String[] latestP = null;
                                for (String plg : plgs) {
                                    String[] p = StringUtils.split((String)plg, (String)"|");
                                    DefaultArtifactVersion current = new DefaultArtifactVersion(p[2]);
                                    if (latest != null && current.compareTo((ArtifactVersion)latest) <= 0) continue;
                                    latest = current;
                                    latestP = p;
                                }
                                if (latestP != null) {
                                    groupId = latestP[0];
                                    artifactid = latestP[1];
                                    version = latestP[2];
                                }
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                AddPropertyDialog.this.addPluginNode(groupId, artifactid, version, mojo, rootChilds);
            }
            HashSet<String> extensionsids = new HashSet<String>();
            if (AddPropertyDialog.this.project != null) {
                List plgns = AddPropertyDialog.this.project.getOriginalMavenProject().getBuildPlugins();
                if (plgns != null) {
                    for (Plugin plg : plgns) {
                        if (plg == null || !plg.isExtensions()) continue;
                        extensionsids.add(plg.getGroupId() + ":" + plg.getArtifactId() + ":" + plg.getVersion());
                    }
                }
                String mvnVersion = MavenSettings.getCommandLineMavenVersion();
                String packaging = AddPropertyDialog.this.project.getOriginalMavenProject().getPackaging();
                if (packaging != null) {
                    try {
                        Map cycle = PluginIndexManager.getLifecyclePlugins((String)packaging, (String)mvnVersion, (String[])extensionsids.toArray(new String[0]));
                        if (cycle != null) {
                            for (List phase : cycle.values()) {
                                for (String mapping : phase) {
                                    String[] split = StringUtils.split((String)mapping, (String)":");
                                    String version = AddPropertyDialog.this.findVersion(split[0], split[1]);
                                    AddPropertyDialog.this.addPluginNode(split[0], split[1], version, split[2], rootChilds);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            AbstractNode root = new AbstractNode((Children)rootChilds);
            root.setName("root");
            AddPropertyDialog.this.getExplorerManager().setRootContext((Node)root);
        }
    }
}

