/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CompilePanel
extends JPanel {
    private static final String[] LABELS = new String[]{NbBundle.getMessage(CompilePanel.class, (String)"COS_ALL"), NbBundle.getMessage(CompilePanel.class, (String)"COS_APP"), NbBundle.getMessage(CompilePanel.class, (String)"COS_TESTS"), NbBundle.getMessage(CompilePanel.class, (String)"COS_NONE")};
    private static final String[] VALUES = new String[]{"all", "app", "test", "none"};
    private static final String PARAM_DEBUG = "debug";
    private static final String PARAM_DEPRECATION = "showDeprecation";
    private static final int COS_ALL = 0;
    private static final int COS_APP = 1;
    private static final int COS_TESTS = 2;
    private static final int COS_NONE = 3;
    private ComboBoxUpdater<String> listener;
    private final ModelHandle handle;
    private final Project project;
    private CheckBoxUpdater debugUpdater;
    private CheckBoxUpdater deprecateUpdater;
    private static boolean warningShown = false;
    private Color origComPlatformFore;
    private JButton btnMngPlatform;
    private JCheckBox cbDebug;
    private JCheckBox cbDeprecate;
    private JComboBox comCompileOnSave;
    private JComboBox comJavaPlatform;
    private JLabel lblCompileOnSave;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJavaPlatform;
    private static final String CONFIGURATION_EL = "configuration";

    public CompilePanel(ModelHandle handle, Project prj) {
        this.initComponents();
        this.handle = handle;
        this.project = prj;
        DefaultComboBoxModel<String> mdl = new DefaultComboBoxModel<String>(LABELS);
        this.comCompileOnSave.setModel(mdl);
        this.comJavaPlatform.setModel(new PlatformsModel());
        this.comJavaPlatform.setRenderer(new PlatformsRenderer());
        this.origComPlatformFore = this.comJavaPlatform.getForeground();
        this.initValues();
    }

    private String valueToLabel(String value) {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].equalsIgnoreCase(value)) continue;
            return LABELS[i];
        }
        return LABELS[2];
    }

    private String labelToValue(String label) {
        for (int i = 0; i < LABELS.length; ++i) {
            if (!LABELS[i].equalsIgnoreCase(label)) continue;
            return VALUES[i];
        }
        return VALUES[2];
    }

    private void initValues() {
        this.listener = new ComboBoxUpdater<String>(this.comCompileOnSave, this.lblCompileOnSave){

            @Override
            public String getDefaultValue() {
                return LABELS[2];
            }

            @Override
            public String getValue() {
                String val = null;
                Properties props = CompilePanel.this.handle.getPOMModel().getProject().getProperties();
                if (props != null) {
                    val = props.getProperty("netbeans.compile.on.save");
                }
                if (val == null) {
                    val = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
                }
                if (val != null) {
                    return CompilePanel.this.valueToLabel(val);
                }
                return LABELS[2];
            }

            @Override
            public void setValue(String label) {
                boolean hasConfig;
                String value = CompilePanel.this.labelToValue(label);
                if (value != null && value.equals(VALUES[2])) {
                    value = null;
                }
                if ((VALUES[0].equals(value) || VALUES[1].equals(value)) && !warningShown && DontShowAgainSettings.getDefault().showWarningAboutApplicationCoS()) {
                    WarnPanel panel = new WarnPanel(NbBundle.getMessage(CompilePanel.class, (String)"HINT_ApplicationCoS"));
                    NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)panel, -1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (panel.disabledWarning()) {
                        DontShowAgainSettings.getDefault().dontshowWarningAboutApplicationCoSAnymore();
                    }
                    warningShown = true;
                }
                boolean bl = hasConfig = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true) != null;
                if (CompilePanel.this.handle.getProject().getProperties().containsKey("netbeans.compile.on.save")) {
                    Properties modprops = CompilePanel.this.handle.getPOMModel().getProject().getProperties();
                    if (modprops == null) {
                        modprops = CompilePanel.this.handle.getPOMModel().getFactory().createProperties();
                        CompilePanel.this.handle.getPOMModel().getProject().setProperties(modprops);
                    }
                    modprops.setProperty("netbeans.compile.on.save", value == null ? null : value);
                    CompilePanel.this.handle.markAsModified(CompilePanel.this.handle.getPOMModel());
                    if (hasConfig) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", null, true);
                    }
                    return;
                }
                CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", value == null ? null : value, true);
            }
        };
        this.debugUpdater = new CheckBoxUpdater(this.cbDebug){

            @Override
            public Boolean getValue() {
                String val = CompilePanel.getCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEBUG);
                if (val != null) {
                    return Boolean.valueOf(val);
                }
                return null;
            }

            @Override
            public void setValue(Boolean value) {
                String text = value == null ? "true" : value.toString();
                CompilePanel.checkCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEBUG, text);
            }

            @Override
            public boolean getDefaultValue() {
                return true;
            }
        };
        this.deprecateUpdater = new CheckBoxUpdater(this.cbDeprecate){

            @Override
            public Boolean getValue() {
                String val = CompilePanel.getCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEPRECATION);
                if (val != null) {
                    return Boolean.valueOf(val);
                }
                return null;
            }

            @Override
            public void setValue(Boolean value) {
                String text = value == null ? "false" : value.toString();
                CompilePanel.checkCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEPRECATION, text);
            }

            @Override
            public boolean getDefaultValue() {
                return false;
            }
        };
        new ComboBoxUpdater<JavaPlatform>(this.comJavaPlatform, this.lblJavaPlatform){

            @Override
            public JavaPlatform getValue() {
                String val = null;
                Properties props = CompilePanel.this.handle.getPOMModel().getProject().getProperties();
                if (props != null) {
                    val = props.getProperty("netbeans.hint.jdkPlatform");
                }
                if (val == null) {
                    val = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true);
                }
                if (val != null) {
                    return BootClassPathImpl.getActivePlatform(val);
                }
                return CompilePanel.this.getSelPlatform();
            }

            @Override
            public JavaPlatform getDefaultValue() {
                return CompilePanel.this.getSelPlatform();
            }

            @Override
            public void setValue(JavaPlatform value) {
                boolean hasConfig;
                JavaPlatform platf = value == null ? JavaPlatformManager.getDefault().getDefaultPlatform() : value;
                String platformId = (String)platf.getProperties().get("platform.ant.name");
                if (JavaPlatformManager.getDefault().getDefaultPlatform().equals(platf)) {
                    platformId = null;
                }
                boolean bl = hasConfig = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true) != null;
                if (CompilePanel.this.handle.getProject().getProperties().containsKey("netbeans.hint.jdkPlatform")) {
                    Properties modprops = CompilePanel.this.handle.getPOMModel().getProject().getProperties();
                    if (modprops == null) {
                        modprops = CompilePanel.this.handle.getPOMModel().getFactory().createProperties();
                        CompilePanel.this.handle.getPOMModel().getProject().setProperties(modprops);
                    }
                    modprops.setProperty("netbeans.hint.jdkPlatform", platformId);
                    CompilePanel.this.handle.markAsModified(CompilePanel.this.handle.getPOMModel());
                    if (hasConfig) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", null, true);
                    }
                    return;
                }
                CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", platformId, true);
            }
        };
    }

    private JavaPlatform getSelPlatform() {
        String platformId = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        return BootClassPathImpl.getActivePlatform(platformId);
    }

    private void initComponents() {
        this.lblJavaPlatform = new JLabel();
        this.comJavaPlatform = new JComboBox();
        this.btnMngPlatform = new JButton();
        this.lblCompileOnSave = new JLabel();
        this.comCompileOnSave = new JComboBox();
        this.lblHint1 = new JLabel();
        this.lblHint2 = new JLabel();
        this.cbDebug = new JCheckBox();
        this.cbDeprecate = new JCheckBox();
        this.setPreferredSize(new Dimension(576, 303));
        Mnemonics.setLocalizedText((JLabel)this.lblJavaPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblJavaPlatform.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMngPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.text"));
        this.btnMngPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompilePanel.this.btnMngPlatformActionPerformed(evt);
            }
        });
        this.lblCompileOnSave.setLabelFor(this.comCompileOnSave);
        Mnemonics.setLocalizedText((JLabel)this.lblCompileOnSave, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblCompileOnSave.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDebug.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDeprecate, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDeprecate.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblHint1, -1, 566, Short.MAX_VALUE).addComponent(this.lblHint2, -2, 566, Short.MAX_VALUE).addComponent(this.cbDebug).addComponent(this.cbDeprecate).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCompileOnSave).addComponent(this.lblJavaPlatform)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comJavaPlatform, 0, 204, Short.MAX_VALUE).addComponent(this.comCompileOnSave, 0, 204, Short.MAX_VALUE)).addGap(16, 16, 16).addComponent(this.btnMngPlatform))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavaPlatform).addComponent(this.comJavaPlatform, -2, -1, -2).addComponent(this.btnMngPlatform)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCompileOnSave).addComponent(this.comCompileOnSave, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint2).addGap(18, 18, 18).addComponent(this.cbDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDeprecate).addContainerGap(142, Short.MAX_VALUE)));
        this.btnMngPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.AccessibleContext.accessibleDescription"));
    }

    private void btnMngPlatformActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelPlatform());
    }

    public static void checkCompilerParam(ModelHandle handle, String param, String value) {
        Plugin plugin;
        String debug = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", param, "compile");
        if (debug != null && debug.contains(value)) {
            return;
        }
        POMModel model = handle.getPOMModel();
        Plugin old = null;
        Build bld = model.getProject().getBuild();
        if (bld != null) {
            old = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
        } else {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        if (old != null) {
            plugin = old;
        } else {
            plugin = model.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
            bld.addPlugin(plugin);
        }
        Configuration config = plugin.getConfiguration();
        if (config == null) {
            config = model.getFactory().createConfiguration();
            plugin.setConfiguration(config);
        }
        config.setSimpleParameter(param, value);
        handle.markAsModified(handle.getPOMModel());
    }

    public static String getCompilerParam(ModelHandle handle, String param) {
        String val;
        Configuration config;
        Plugin plugin;
        Build bld = handle.getPOMModel().getProject().getBuild();
        if (bld != null && (plugin = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin")) != null && (config = plugin.getConfiguration()) != null && (val = config.getSimpleParameter(param)) != null) {
            return val;
        }
        String value = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", param, "compile");
        if (value != null) {
            return value;
        }
        return null;
    }

    private class PlatformsRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            JavaPlatform jp = (JavaPlatform)value;
            if (jp != null) {
                this.setText(jp.getDisplayName());
            } else {
                this.setText("");
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private static class PlatformsModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private JavaPlatform[] data;
        private Object sel;

        public PlatformsModel() {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.data = jpm.getInstalledPlatforms();
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
            this.sel = jpm.getDefaultPlatform();
        }

        @Override
        public int getSize() {
            return this.data.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.data[index];
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.sel = anItem;
            this.fireContentsChanged(this, 0, this.data.length);
        }

        @Override
        public Object getSelectedItem() {
            return this.sel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.data = jpm.getInstalledPlatforms();
            this.fireContentsChanged(this, 0, this.data.length);
        }
    }
}

