/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.sunas;

import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.j2ee.sunas.SunASAutoIntegrationProvider;
import org.netbeans.modules.profiler.j2ee.sunas.SunASIntegrationPanelUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SunASIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "SunASIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("SunASIntegrationPanel.HelpCtx");
    private Model model = new Model();
    private String domainHint = "";
    private String hint = "";
    private SunASIntegrationPanelUI panel = null;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.getInstallPath() != null && this.model.getInstallPath().length() > 0 && this.model.getDomain() != null && this.model.getDomain().length() > 0 && this.model.getSelectedPlatform() != null;
    }

    public boolean canBack(AttachWizardContext context) {
        return true;
    }

    public boolean canFinish(AttachWizardContext context) {
        return false;
    }

    public boolean canNext(AttachWizardContext context) {
        return this.isValid();
    }

    public boolean onCancel(AttachWizardContext context) {
        return true;
    }

    public void onEnter(AttachWizardContext context) {
        if (this.model.getDomain() == null || this.model.getDomain().length() == 0) {
            this.model.setDomain(((SunASAutoIntegrationProvider)context.getIntegrationProvider()).getDomain());
        }
        if (this.model.getInstallPath() == null || this.model.getInstallPath().length() == 0) {
            this.model.setInstallPath(((SunASAutoIntegrationProvider)context.getIntegrationProvider()).getInstallationPath());
        }
        String selectedJavaHome = ((SunASAutoIntegrationProvider)context.getIntegrationProvider()).getTargetJava();
        List platformList = TargetPlatform.getPlatformList((boolean)false);
        for (TargetPlatform platform : platformList) {
            if (!platform.equals((Object)selectedJavaHome)) continue;
            this.model.setTargetJava(platform);
            break;
        }
        this.panel.loadModel();
    }

    public void onExit(AttachWizardContext context) {
        SunASAutoIntegrationProvider provider = (SunASAutoIntegrationProvider)this.getContext().getIntegrationProvider();
        boolean isModified = false;
        if (provider.getInstallationPath() == null || provider.getDomain() == null || provider.getTargetJavaHome() == null) {
            return;
        }
        if (!provider.getInstallationPath().equals(this.model.getInstallPath())) {
            isModified = true;
        } else if (!provider.getDomain().equals(this.model.getDomain())) {
            isModified = true;
        } else if (provider.getTargetJavaHome() != null && this.model.getSelectedPlatform() != null && !provider.getTargetJavaHome().equals(this.model.getSelectedPlatform().getHomePath())) {
            isModified = true;
        }
        if (isModified) {
            context.setConfigChanged();
        }
        provider.setInstallationPath(this.model.getInstallPath());
        provider.setDomain(this.model.getDomain());
        provider.setTargetPlatform(this.model.getSelectedPlatform());
    }

    public void onFinish(AttachWizardContext context) {
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new SunASIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    protected void onPanelShow() {
        this.panel.refreshJvmList(this.model.getSelectedPlatform());
    }

    class Model {
        private List domains = new Vector();
        private String domain = "";
        private String installPath = "";
        private TargetPlatform targetPlatform = null;

        public void setDomain(String domain) {
            this.domain = domain;
            SunASIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getDomain() {
            return this.domain;
        }

        public String getDomainHint() {
            return SunASIntegrationPanel.this.domainHint;
        }

        public List getDomains() {
            return this.domains;
        }

        public void setInstallPath(String installPath) {
            String targetOS;
            SunASAutoIntegrationProvider provider = (SunASAutoIntegrationProvider)SunASIntegrationPanel.this.getContext().getIntegrationProvider();
            ValidationResult validation = provider.validateInstallation(targetOS = SunASIntegrationPanel.this.getContext().getAttachSettings().getHostOS(), installPath);
            if (!validation.isValid()) {
                SunASIntegrationPanel.this.hint = validation.getMessage();
                SunASIntegrationPanel.this.domainHint = NbBundle.getMessage(this.getClass(), (String)"SunAS8IntegrationProvider_InstallDirPendingMsg");
            } else {
                SunASIntegrationPanel.this.hint = "";
                SunASIntegrationPanel.this.domainHint = "";
            }
            this.installPath = installPath;
            this.updateDomains();
            SunASIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getInstallPath() {
            return this.installPath;
        }

        public String getInstallPathHint() {
            return SunASIntegrationPanel.this.hint;
        }

        public TargetPlatform getSelectedPlatform() {
            return this.targetPlatform;
        }

        public void setTargetJava(TargetPlatform java) {
            this.targetPlatform = java;
            SunASIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        private void updateDomains() {
            SunASAutoIntegrationProvider provider = (SunASAutoIntegrationProvider)SunASIntegrationPanel.this.getContext().getIntegrationProvider();
            this.domains.clear();
            this.domains.addAll(provider.getAvailableDomains(this.installPath));
            if ((this.domain == null || this.domain.length() == 0) && this.domains.size() > 0) {
                this.domain = (String)this.domains.get(0);
            } else if (this.domains.size() == 0) {
                this.domain = null;
            }
        }
    }
}

