/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileCheckoutTarget;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNFileCheckoutEditor;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNRepository {
    public static final long INVALID_REVISION = -1L;
    protected String myRepositoryUUID;
    protected SVNURL myRepositoryRoot;
    protected SVNURL myLocation;
    private int myLockCount;
    private Thread myLocker;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNSession myOptions;
    private ISVNTunnelProvider myTunnelProvider;
    private ISVNDebugLog myDebugLog;
    private ISVNCanceller myCanceller;
    private Collection myConnectionListeners;

    protected SVNRepository(SVNURL location, ISVNSession options) {
        this.myLocation = location;
        this.myOptions = options;
        this.myConnectionListeners = new SVNHashSet();
    }

    public SVNURL getLocation() {
        return this.myLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(SVNURL url, boolean forceReconnect) throws SVNException {
        this.lock();
        try {
            if (url == null) {
                return;
            }
            if (!url.getProtocol().equals(this.myLocation.getProtocol())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "SVNRepository URL could not be changed from ''{0}'' to ''{1}''; create new SVNRepository instance instead", new Object[]{this.myLocation, url});
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (forceReconnect) {
                this.closeSession();
                this.myRepositoryRoot = null;
                this.myRepositoryUUID = null;
            } else if (this.myRepositoryRoot == null) {
                if (!url.toString().startsWith(this.myLocation.toString() + "/") && !url.equals(this.getLocation())) {
                    this.closeSession();
                    this.myRepositoryRoot = null;
                    this.myRepositoryUUID = null;
                }
            } else if (!url.toString().startsWith(this.myRepositoryRoot.toString() + "/") && !this.myRepositoryRoot.equals(url)) {
                this.closeSession();
                this.myRepositoryRoot = null;
                this.myRepositoryUUID = null;
            }
            this.myLocation = url;
        }
        finally {
            this.unlock();
        }
    }

    public String getRepositoryUUID() {
        try {
            return this.getRepositoryUUID(false);
        }
        catch (SVNException sVNException) {
            return this.myRepositoryUUID;
        }
    }

    public String getRepositoryUUID(boolean forceConnection) throws SVNException {
        if (forceConnection && this.myRepositoryUUID == null) {
            this.testConnection();
        }
        return this.myRepositoryUUID;
    }

    public SVNURL getRepositoryRoot() {
        try {
            return this.getRepositoryRoot(false);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    public SVNURL getRepositoryRoot(boolean forceConnection) throws SVNException {
        if (forceConnection && this.myRepositoryRoot == null) {
            this.testConnection();
        }
        return this.myRepositoryRoot;
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        this.myAuthManager = authManager;
    }

    public ISVNAuthenticationManager getAuthenticationManager() {
        return this.myAuthManager;
    }

    public void setTunnelProvider(ISVNTunnelProvider tunnelProvider) {
        this.myTunnelProvider = tunnelProvider;
    }

    public ISVNTunnelProvider getTunnelProvider() {
        return this.myTunnelProvider;
    }

    public void setCanceller(ISVNCanceller canceller) {
        this.myCanceller = canceller;
    }

    public ISVNCanceller getCanceller() {
        return this.myCanceller == null ? ISVNCanceller.NULL : this.myCanceller;
    }

    protected void setRepositoryCredentials(String uuid, SVNURL rootURL) {
        if (uuid != null && rootURL != null) {
            this.myRepositoryUUID = uuid;
            this.myRepositoryRoot = rootURL;
        }
    }

    public abstract void testConnection() throws SVNException;

    public abstract long getLatestRevision() throws SVNException;

    public abstract long getDatedRevision(Date var1) throws SVNException;

    public abstract SVNProperties getRevisionProperties(long var1, SVNProperties var3) throws SVNException;

    public abstract void setRevisionPropertyValue(long var1, String var3, SVNPropertyValue var4) throws SVNException;

    public abstract SVNPropertyValue getRevisionPropertyValue(long var1, String var3) throws SVNException;

    public abstract SVNNodeKind checkPath(String var1, long var2) throws SVNException;

    public abstract long getFile(String var1, long var2, SVNProperties var4, OutputStream var5) throws SVNException;

    public abstract long getDir(String var1, long var2, SVNProperties var4, ISVNDirEntryHandler var5) throws SVNException;

    public abstract long getDir(String var1, long var2, SVNProperties var4, int var5, ISVNDirEntryHandler var6) throws SVNException;

    public int getFileRevisions(String path, long startRevision, long endRevision, ISVNFileRevisionHandler handler) throws SVNException {
        return this.getFileRevisions(path, startRevision, endRevision, false, handler);
    }

    public int getFileRevisions(String path, long startRevision, long endRevision, boolean includeMergedRevisions, ISVNFileRevisionHandler handler) throws SVNException {
        if (includeMergedRevisions) {
            this.assertServerIsMergeInfoCapable(null);
        }
        try {
            return this.getFileRevisionsImpl(path, startRevision, endRevision, includeMergedRevisions, handler);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getFileRevisionsFromLog(path, startRevision, endRevision, handler);
            }
            throw svne;
        }
    }

    public void assertServerIsMergeInfoCapable(String pathOrURL) throws SVNException {
        boolean isMergeInfoCapable = this.hasCapability(SVNCapability.MERGE_INFO);
        if (!isMergeInfoCapable) {
            if (pathOrURL == null) {
                SVNURL sessionURL = this.getLocation();
                pathOrURL = sessionURL.toString();
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Retrieval of mergeinfo unsupported by ''{0}''", pathOrURL);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    public long log(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, ISVNLogEntryHandler handler) throws SVNException {
        return this.log(targetPaths, startRevision, endRevision, changedPath, strictNode, 0L, handler);
    }

    public long log(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, long limit, ISVNLogEntryHandler handler) throws SVNException {
        return this.log(targetPaths, startRevision, endRevision, changedPath, strictNode, limit, false, null, handler);
    }

    public long log(String[] targetPaths, long startRevision, long endRevision, boolean discoverChangedPaths, boolean strictNodeHistory, long limit, boolean includeMergedRevisions, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        if (includeMergedRevisions) {
            this.assertServerIsMergeInfoCapable(null);
        }
        return this.logImpl(targetPaths, startRevision, endRevision, discoverChangedPaths, strictNodeHistory, limit, includeMergedRevisions, revisionProperties, handler);
    }

    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        try {
            return this.getLocationsImpl(path, pegRevision, revisions, handler);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getLocationsFromLog(path, pegRevision, revisions, handler);
            }
            throw svne;
        }
    }

    public long getLocationSegments(String path, long pegRevision, long startRevision, long endRevision, ISVNLocationSegmentHandler handler) throws SVNException {
        try {
            return this.getLocationSegmentsImpl(path, pegRevision, startRevision, endRevision, handler);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getLocationSegmentsFromLog(path, pegRevision, startRevision, endRevision, handler);
            }
            throw svne;
        }
    }

    public List getLocationSegments(String path, long pegRevision, long startRevision, long endRevision) throws SVNException {
        final LinkedList result = new LinkedList();
        this.getLocationSegments(path, pegRevision, startRevision, endRevision, new ISVNLocationSegmentHandler(){

            public void handleLocationSegment(SVNLocationSegment locationSegment) throws SVNException {
                result.add(locationSegment);
                SVNRepository.this.getCanceller().checkCancelled();
            }
        });
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                SVNLocationSegment segment1 = (SVNLocationSegment)o1;
                SVNLocationSegment segment2 = (SVNLocationSegment)o2;
                if (segment1.getStartRevision() == segment2.getStartRevision()) {
                    return 0;
                }
                return segment1.getStartRevision() < segment2.getStartRevision() ? -1 : 1;
            }
        });
        return result;
    }

    public Collection getFileRevisions(String path, Collection revisions, long sRevision, long eRevision) throws SVNException {
        final Collection result = revisions != null ? revisions : new LinkedList();
        ISVNFileRevisionHandler handler = new ISVNFileRevisionHandler(){

            public void openRevision(SVNFileRevision fileRevision) throws SVNException {
                result.add(fileRevision);
            }

            public void applyTextDelta(String path, String baseChecksum) throws SVNException {
            }

            public OutputStream textDeltaChunk(String token, SVNDiffWindow diffWindow) throws SVNException {
                return SVNFileUtil.DUMMY_OUT;
            }

            public void textDeltaEnd(String token) throws SVNException {
            }

            public void closeRevision(String token) throws SVNException {
            }
        };
        this.getFileRevisions(path, sRevision, eRevision, handler);
        return result;
    }

    public Collection getDir(String path, long revision, SVNProperties properties, Collection dirEntries) throws SVNException {
        return this.getDir(path, revision, properties, -1, dirEntries);
    }

    public Collection getDir(String path, long revision, SVNProperties properties, int entryFields, Collection dirEntries) throws SVNException {
        final Collection result = dirEntries != null ? dirEntries : new LinkedList();
        ISVNDirEntryHandler handler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) {
                result.add(dirEntry);
            }
        };
        this.getDir(path, revision, properties, entryFields, handler);
        return result;
    }

    public abstract SVNDirEntry getDir(String var1, long var2, boolean var4, Collection var5) throws SVNException;

    public Collection log(String[] targetPaths, Collection entries, long startRevision, long endRevision, boolean changedPath, boolean strictNode) throws SVNException {
        final Collection result = entries != null ? entries : new LinkedList();
        this.log(targetPaths, startRevision, endRevision, changedPath, strictNode, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                result.add(logEntry);
            }
        });
        return result;
    }

    public Collection getLocations(String path, Collection entries, long pegRevision, long[] revisions) throws SVNException {
        final Collection result = entries != null ? entries : new LinkedList();
        this.getLocations(path, pegRevision, revisions, new ISVNLocationEntryHandler(){

            public void handleLocationEntry(SVNLocationEntry locationEntry) {
                result.add(locationEntry);
            }
        });
        return result;
    }

    public Map getLocations(String path, Map entries, long pegRevision, long[] revisions) throws SVNException {
        final Map result = entries != null ? entries : new SVNHashMap();
        this.getLocations(path, pegRevision, revisions, new ISVNLocationEntryHandler(){

            public void handleLocationEntry(SVNLocationEntry locationEntry) {
                result.put(new Long(locationEntry.getRevision()), locationEntry);
            }
        });
        return result;
    }

    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, targetRevision, revision, target, ignoreAncestry, SVNDepth.fromRecurse(recursive), getContents, reporter, editor);
    }

    public abstract void diff(SVNURL var1, long var2, long var4, String var6, boolean var7, SVNDepth var8, boolean var9, ISVNReporterBaton var10, ISVNEditor var11) throws SVNException;

    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, targetRevision, revision, target, ignoreAncestry, SVNDepth.fromRecurse(recursive), true, reporter, editor);
    }

    public void diff(SVNURL url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.diff(url, revision, revision, target, ignoreAncestry, SVNDepth.fromRecurse(recursive), true, reporter, editor);
    }

    public void update(SVNURL url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.update(url, revision, target, SVNDepth.fromRecurse(recursive), reporter, editor);
    }

    public abstract void update(SVNURL var1, long var2, String var4, SVNDepth var5, ISVNReporterBaton var6, ISVNEditor var7) throws SVNException;

    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.update(revision, target, SVNDepth.fromRecurse(recursive), false, reporter, editor);
    }

    public abstract void update(long var1, String var3, SVNDepth var4, boolean var5, ISVNReporterBaton var6, ISVNEditor var7) throws SVNException;

    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.status(revision, target, SVNDepth.fromRecurse(recursive), reporter, editor);
    }

    public abstract void status(long var1, String var3, SVNDepth var4, ISVNReporterBaton var5, ISVNEditor var6) throws SVNException;

    public void checkout(long revision, String target, boolean recursive, ISVNEditor editor) throws SVNException {
        this.checkout(revision, target, SVNDepth.fromRecurse(recursive), editor);
    }

    public void checkout(long revision, String target, SVNDepth depth, ISVNEditor editor) throws SVNException {
        SVNErrorMessage err;
        final long lastRev = revision >= 0L ? revision : this.getLatestRevision();
        SVNNodeKind nodeKind = this.checkPath("", revision);
        if (nodeKind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' refers to a file, not a directory", this.getLocation());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        } else if (nodeKind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn't exist", this.getLocation());
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        final SVNDepth reporterDepth = depth;
        this.update(revision, target, depth, false, new ISVNReporterBaton(){

            public void report(ISVNReporter reporter) throws SVNException {
                reporter.setPath("", null, lastRev, reporterDepth, true);
                reporter.finishReport();
            }
        }, editor);
    }

    public void checkoutFiles(long revision, String[] paths, ISVNFileCheckoutTarget fileCheckoutHandler) throws SVNException {
        final long lastRev = revision >= 0L ? revision : this.getLatestRevision();
        final ArrayList<String> pathsList = new ArrayList<String>(Arrays.asList(paths));
        Collections.sort(pathsList, SVNPathUtil.PATH_COMPARATOR);
        ISVNReporterBaton reporterBaton = new ISVNReporterBaton(){

            public void report(ISVNReporter reporter) throws SVNException {
                reporter.setPath("", null, lastRev, SVNDepth.INFINITY, false);
                Iterator ps = pathsList.iterator();
                while (ps.hasNext()) {
                    String path = (String)ps.next();
                    reporter.deletePath(path);
                }
                reporter.finishReport();
            }
        };
        this.update(lastRev, null, SVNDepth.INFINITY, false, reporterBaton, (ISVNEditor)new SVNFileCheckoutEditor(fileCheckoutHandler));
    }

    public abstract void replay(long var1, long var3, boolean var5, ISVNEditor var6) throws SVNException;

    public void replayRange(long startRevision, long endRevision, long lowRevision, boolean sendDeltas, ISVNReplayHandler handler) throws SVNException {
        try {
            this.replayRangeImpl(startRevision, endRevision, lowRevision, sendDeltas, handler);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                for (long rev = startRevision; rev <= endRevision; ++rev) {
                    SVNProperties revProps = this.getRevisionProperties(rev, null);
                    ISVNEditor editor = handler.handleStartRevision(rev, revProps);
                    this.replay(lowRevision, rev, sendDeltas, editor);
                    handler.handleEndRevision(rev, revProps, editor);
                }
            }
            throw svne;
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, ISVNWorkspaceMediator mediator) throws SVNException {
        return this.getCommitEditor(logMessage, null, false, mediator);
    }

    public abstract SVNDirEntry info(String var1, long var2) throws SVNException;

    public abstract ISVNEditor getCommitEditor(String var1, Map var2, boolean var3, ISVNWorkspaceMediator var4) throws SVNException;

    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, SVNProperties revisionProperties, ISVNWorkspaceMediator mediator) throws SVNException {
        SVNProperties sVNProperties = revisionProperties = revisionProperties == null ? new SVNProperties() : new SVNProperties(revisionProperties);
        if (logMessage != null) {
            revisionProperties.put("svn:log", logMessage);
        }
        return this.getCommitEditorInternal(locks, keepLocks, revisionProperties, mediator);
    }

    protected abstract ISVNEditor getCommitEditorInternal(Map var1, boolean var2, SVNProperties var3, ISVNWorkspaceMediator var4) throws SVNException;

    public abstract SVNLock getLock(String var1) throws SVNException;

    public abstract SVNLock[] getLocks(String var1) throws SVNException;

    public Map getMergeInfo(String[] paths, long revision, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        if (paths == null) {
            return null;
        }
        this.assertServerIsMergeInfoCapable(this.getRepositoryRoot(true).toString());
        return this.getMergeInfoImpl(paths, revision, inherit, includeDescendants);
    }

    public abstract void lock(Map var1, String var2, boolean var3, ISVNLockHandler var4) throws SVNException;

    public abstract void unlock(Map var1, boolean var2, ISVNLockHandler var3) throws SVNException;

    public abstract void closeSession();

    public abstract boolean hasCapability(SVNCapability var1) throws SVNException;

    public ISVNSession getOptions() {
        if (this.myOptions == null) {
            this.myOptions = ISVNSession.DEFAULT;
        }
        return this.myOptions;
    }

    public void addConnectionListener(ISVNConnectionListener listener) {
        this.myConnectionListeners.add(listener);
    }

    public void removeConnectionListener(ISVNConnectionListener listener) {
        this.myConnectionListeners.remove(listener);
    }

    public long getDeletedRevision(String path, long pegRevision, long endRevision) throws SVNException {
        SVNErrorMessage err;
        if ("/".equals(path = this.getRepositoryPath(path))) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "root path could not be deleted");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (SVNRepository.isInvalidRevision(pegRevision)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid peg revision {0}", String.valueOf(pegRevision));
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (SVNRepository.isInvalidRevision(endRevision)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid end revision {0}", String.valueOf(endRevision));
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (endRevision <= pegRevision) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Peg revision must precede end revision");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        try {
            return this.getDeletedRevisionImpl(path, pegRevision, endRevision);
        }
        catch (SVNException svne) {
            SVNErrorCode errCode = svne.getErrorMessage().getErrorCode();
            if (errCode == SVNErrorCode.UNSUPPORTED_FEATURE || errCode == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getDeletedRevisionFromLog(path, pegRevision, endRevision);
            }
            throw svne;
        }
    }

    protected abstract long getDeletedRevisionImpl(String var1, long var2, long var4) throws SVNException;

    protected abstract long getLocationSegmentsImpl(String var1, long var2, long var4, long var6, ISVNLocationSegmentHandler var8) throws SVNException;

    protected abstract int getLocationsImpl(String var1, long var2, long[] var4, ISVNLocationEntryHandler var5) throws SVNException;

    protected abstract long logImpl(String[] var1, long var2, long var4, boolean var6, boolean var7, long var8, boolean var10, String[] var11, ISVNLogEntryHandler var12) throws SVNException;

    protected abstract int getFileRevisionsImpl(String var1, long var2, long var4, boolean var6, ISVNFileRevisionHandler var7) throws SVNException;

    protected abstract Map getMergeInfoImpl(String[] var1, long var2, SVNMergeInfoInheritance var4, boolean var5) throws SVNException;

    protected abstract void replayRangeImpl(long var1, long var3, long var5, boolean var7, ISVNReplayHandler var8) throws SVNException;

    protected void fireConnectionOpened() {
        Iterator listeners = this.myConnectionListeners.iterator();
        while (listeners.hasNext()) {
            ISVNConnectionListener listener = (ISVNConnectionListener)listeners.next();
            listener.connectionOpened(this);
        }
    }

    protected void fireConnectionClosed() {
        Iterator listeners = this.myConnectionListeners.iterator();
        while (listeners.hasNext()) {
            ISVNConnectionListener listener = (ISVNConnectionListener)listeners.next();
            listener.connectionClosed(this);
        }
    }

    protected synchronized void lock() {
        this.lock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void lock(boolean force) {
        try {
            SVNRepository sVNRepository = this;
            synchronized (sVNRepository) {
                if (Thread.currentThread() == this.myLocker) {
                    if (!force) {
                        this.getDebugLog().logFine(SVNLogType.DEFAULT, new Exception());
                        throw new Error("SVNRepository methods are not reenterable");
                    }
                    ++this.myLockCount;
                    return;
                }
                while (this.myLocker != null) {
                    this.wait();
                }
                this.myLocker = Thread.currentThread();
                ++this.myLockCount;
            }
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unlock() {
        SVNRepository sVNRepository = this;
        synchronized (sVNRepository) {
            if (--this.myLockCount <= 0) {
                this.myLockCount = 0;
                this.myLocker = null;
                this.notify();
            }
        }
    }

    protected static boolean isInvalidRevision(long revision) {
        return revision < 0L;
    }

    protected static boolean isValidRevision(long revision) {
        return revision >= 0L;
    }

    protected static Long getRevisionObject(long revision) {
        return SVNRepository.isValidRevision(revision) ? new Long(revision) : null;
    }

    protected static void assertValidRevision(long revision) throws SVNException {
        if (!SVNRepository.isValidRevision(revision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid revision number ''{0}''", new Long(revision));
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
    }

    public String getRepositoryPath(String relativePath) throws SVNException {
        if (relativePath == null) {
            return "/";
        }
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            return relativePath;
        }
        String fullPath = SVNPathUtil.append(this.getLocation().getPath(), relativePath);
        String repositoryPath = fullPath.substring(this.getRepositoryRoot(true).getPath().length());
        if ("".equals(repositoryPath)) {
            return "/";
        }
        if (!repositoryPath.startsWith("/")) {
            repositoryPath = "/" + repositoryPath;
        }
        return repositoryPath;
    }

    public String getFullPath(String relativeOrRepositoryPath) throws SVNException {
        if (relativeOrRepositoryPath == null) {
            return this.getFullPath("/");
        }
        String fullPath = relativeOrRepositoryPath.length() > 0 && relativeOrRepositoryPath.charAt(0) == '/' ? SVNPathUtil.append(this.getRepositoryRoot(true).getPath(), relativeOrRepositoryPath) : SVNPathUtil.append(this.getLocation().getPath(), relativeOrRepositoryPath);
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        return fullPath;
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    private long getDeletedRevisionFromLog(String path, long pegRevision, long endRevision) throws SVNException {
        DeletedRevisionLogHandler handler = new DeletedRevisionLogHandler(path);
        this.log(null, pegRevision, endRevision, true, true, 0L, false, null, handler);
        return handler.getDeletedRevision();
    }

    private long getLocationSegmentsFromLog(String path, long pegRevision, long startRevision, long endRevision, ISVNLocationSegmentHandler handler) throws SVNException {
        SVNNodeKind kind;
        String reposAbsPath = this.getRepositoryPath(path);
        long youngestRevision = -1L;
        if (SVNRepository.isInvalidRevision(pegRevision)) {
            pegRevision = youngestRevision = this.getLatestRevision();
        }
        if (SVNRepository.isInvalidRevision(startRevision)) {
            startRevision = SVNRepository.isValidRevision(youngestRevision) ? youngestRevision : this.getLatestRevision();
        }
        if (SVNRepository.isInvalidRevision(endRevision)) {
            endRevision = 0L;
        }
        if (pegRevision < startRevision || startRevision < endRevision) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "assertion failure in getLocationSegmentsFromLog:\n  pegRevision is {0}\n  startRevision is {1}\n  endRevision is {2}", new Object[]{new Long(pegRevision), new Long(startRevision), new Long(endRevision)});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if ((kind = this.checkPath(path, pegRevision)) == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn''t exist in revision {1}", new Object[]{reposAbsPath, new Long(pegRevision)});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        LocationSegmentsLogHandler locationSegmentsLogHandler = new LocationSegmentsLogHandler(kind, reposAbsPath, startRevision, handler);
        this.log(new String[]{path}, pegRevision, endRevision, true, false, 0L, false, new String[0], locationSegmentsLogHandler);
        if (!locationSegmentsLogHandler.myIsDone) {
            locationSegmentsLogHandler.maybeCropAndSendSegment(locationSegmentsLogHandler.myLastPath, startRevision, endRevision, locationSegmentsLogHandler.myRangeEnd, handler);
        }
        return locationSegmentsLogHandler.myCount;
    }

    private int getLocationsFromLog(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        String reposAbsPath = this.getRepositoryPath(path);
        SVNNodeKind kind = this.checkPath(path, pegRevision);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn''t exist in revision {1}", new Object[]{reposAbsPath, new Long(pegRevision)});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (revisions == null || revisions.length == 0) {
            return 0;
        }
        Arrays.sort(revisions);
        long oldestRequestedRev = revisions[0];
        long youngestRequestedRev = revisions[revisions.length - 1];
        long youngest = pegRevision;
        youngest = oldestRequestedRev > youngest ? oldestRequestedRev : youngest;
        youngest = youngestRequestedRev > youngest ? youngestRequestedRev : youngest;
        long oldest = pegRevision;
        oldest = oldestRequestedRev < oldest ? oldestRequestedRev : oldest;
        oldest = youngestRequestedRev < oldest ? youngestRequestedRev : oldest;
        LocationsLogHandler locationsLogHandler = new LocationsLogHandler(revisions, kind, reposAbsPath, pegRevision, handler);
        this.log(new String[]{path}, youngest, oldest, true, false, 0L, false, null, locationsLogHandler);
        if (locationsLogHandler.myPegPath == null) {
            locationsLogHandler.myPegPath = locationsLogHandler.myLastPath;
        }
        if (locationsLogHandler.myLastPath != null) {
            for (int i = 0; i < revisions.length; ++i) {
                long rev = revisions[i];
                Long revObject = new Long(rev);
                if (handler == null || locationsLogHandler.myProcessedRevisions.contains(revObject)) continue;
                handler.handleLocationEntry(new SVNLocationEntry(rev, locationsLogHandler.myLastPath));
                locationsLogHandler.myProcessedRevisions.add(revObject);
            }
        }
        if (locationsLogHandler.myPegPath == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unable to find repository location for ''{0}'' in revision {1}", new Object[]{reposAbsPath, new Long(pegRevision)});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (!reposAbsPath.equals(locationsLogHandler.myPegPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "''{0}'' in revision {1} is an unrelated object", new Object[]{reposAbsPath, new Long(youngest)});
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        return locationsLogHandler.myProcessedRevisions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFileRevisionsFromLog(String path, long startRevision, long endRevision, ISVNFileRevisionHandler handler) throws SVNException {
        SVNURL reposURL = this.getRepositoryRoot(true);
        SVNURL sessionURL = this.getLocation();
        String reposAbsPath = this.getRepositoryPath(path);
        SVNNodeKind kind = this.checkPath("", endRevision);
        if (kind == SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "''{0}'' is not a file", reposAbsPath);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        FileRevisionsLogHandler logHandler = new FileRevisionsLogHandler(reposAbsPath);
        this.log(new String[]{""}, endRevision, startRevision, true, false, 0L, false, null, logHandler);
        LinkedList revisions = logHandler.getRevisions();
        this.setLocation(reposURL, false);
        File lastFile = null;
        SVNProperties lastProps = null;
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        int i = 0;
        Iterator revsIter = revisions.iterator();
        while (revsIter.hasNext()) {
            Revision rev = (Revision)revsIter.next();
            File tmpFile = SVNFileUtil.createTempFile("tmp", ".tmp");
            SVNProperties props = new SVNProperties();
            OutputStream os = null;
            try {
                os = SVNFileUtil.openFileForWriting(tmpFile);
                this.getFile(rev.myPath, rev.myRevision, props, os);
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            SVNProperties propDiff = FSRepositoryUtil.getPropsDiffs(lastProps, props);
            SVNFileRevision fileRevision = new SVNFileRevision(rev.myPath, rev.myRevision, rev.myProperties, propDiff, false);
            handler.openRevision(fileRevision);
            InputStream srcStream = null;
            InputStream tgtStream = null;
            try {
                srcStream = lastFile != null ? SVNFileUtil.openFileForReading(lastFile, SVNLogType.NETWORK) : SVNFileUtil.DUMMY_IN;
                tgtStream = SVNFileUtil.openFileForReading(tmpFile, SVNLogType.NETWORK);
                deltaGenerator.sendDelta(rev.myPath, srcStream, 0L, tgtStream, handler, false);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(srcStream);
                SVNFileUtil.closeFile(tgtStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(srcStream);
            SVNFileUtil.closeFile(tgtStream);
            handler.closeRevision(rev.myPath);
            if (lastFile != null) {
                SVNFileUtil.deleteFile(lastFile);
            }
            lastFile = tmpFile;
            lastProps = props;
            ++i;
        }
        this.setLocation(sessionURL, false);
        return i;
    }

    private static String getPreviousLogPath(char[] action, long[] copyFromRevision, Map changedPaths, String path, SVNNodeKind kind, long revision) throws SVNException {
        if (action != null && action.length > 0) {
            action[0] = 77;
        }
        if (copyFromRevision != null && copyFromRevision.length > 0) {
            copyFromRevision[0] = -1L;
        }
        String previousPath = null;
        if (changedPaths != null) {
            SVNLogEntryPath change = (SVNLogEntryPath)changedPaths.get(path);
            if (change != null) {
                if (change.getType() != 'A' && change.getType() != 'R') {
                    previousPath = path;
                } else {
                    if (change.getCopyPath() != null) {
                        previousPath = change.getCopyPath();
                    }
                    if (action != null && action.length > 0) {
                        action[0] = change.getType();
                    }
                    if (copyFromRevision != null && copyFromRevision.length > 0) {
                        copyFromRevision[0] = change.getCopyRevision();
                    }
                    return previousPath;
                }
            }
            if (!changedPaths.isEmpty()) {
                String[] sortedPaths = changedPaths.keySet().toArray(new String[changedPaths.size()]);
                Arrays.sort(sortedPaths, SVNPathUtil.PATH_COMPARATOR);
                for (int i = sortedPaths.length; i > 0; --i) {
                    String changedPath = sortedPaths[i - 1];
                    if (!path.startsWith(changedPath) || path.length() <= changedPath.length() || path.charAt(changedPath.length()) != '/' || (change = (SVNLogEntryPath)changedPaths.get(changedPath)).getCopyPath() == null) continue;
                    if (action != null && action.length > 0) {
                        action[0] = change.getType();
                    }
                    if (copyFromRevision != null && copyFromRevision.length > 0) {
                        copyFromRevision[0] = change.getCopyRevision();
                    }
                    previousPath = SVNPathUtil.append(change.getCopyPath(), path.substring(changedPath.length() + 1));
                    break;
                }
            }
        }
        if (previousPath == null) {
            if (kind == SVNNodeKind.DIR) {
                previousPath = path;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Missing changed-path information for ''{0}'' in revision {1}", new Object[]{path, new Long(revision)});
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        }
        return previousPath;
    }

    private static class Revision {
        String myPath;
        long myRevision;
        SVNProperties myProperties;

        private Revision() {
        }
    }

    private static class LocationsLogHandler
    implements ISVNLogEntryHandler {
        String myLastPath;
        String myPegPath;
        SVNNodeKind myNodeKind;
        long myPegRevision;
        long[] myRevisions;
        int myRevisionsCount;
        ISVNLocationEntryHandler myLocationsHandler;
        LinkedList myProcessedRevisions;

        public LocationsLogHandler(long[] revisions, SVNNodeKind kind, String lastPath, long pegRevision, ISVNLocationEntryHandler handler) {
            this.myRevisionsCount = revisions.length;
            this.myRevisions = revisions;
            this.myNodeKind = kind;
            this.myLastPath = lastPath;
            this.myPegRevision = pegRevision;
            this.myProcessedRevisions = new LinkedList();
            this.myLocationsHandler = handler;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            String prevPath;
            if (logEntry.getChangedPaths() == null) {
                return;
            }
            String currentPath = this.myLastPath;
            if (currentPath == null) {
                return;
            }
            if (this.myPegPath == null && logEntry.getRevision() <= this.myPegRevision) {
                this.myPegPath = currentPath;
            }
            while (this.myRevisionsCount > 0) {
                long nextRev = this.myRevisions[this.myRevisionsCount - 1];
                if (logEntry.getRevision() > nextRev) break;
                if (this.myLocationsHandler != null) {
                    this.myLocationsHandler.handleLocationEntry(new SVNLocationEntry(nextRev, currentPath));
                    this.myProcessedRevisions.add(new Long(nextRev));
                }
                --this.myRevisionsCount;
            }
            if ((prevPath = SVNRepository.getPreviousLogPath(null, null, logEntry.getChangedPaths(), currentPath, this.myNodeKind, logEntry.getRevision())) == null) {
                this.myLastPath = null;
            } else if (!prevPath.equals(currentPath)) {
                this.myLastPath = prevPath;
            }
        }
    }

    private static class LocationSegmentsLogHandler
    implements ISVNLogEntryHandler {
        boolean myIsDone;
        String myLastPath;
        SVNNodeKind myNodeKind;
        long myCount;
        long myStartRevision;
        long myRangeEnd;
        ISVNLocationSegmentHandler myHandler;

        public LocationSegmentsLogHandler(SVNNodeKind kind, String lastPath, long startRev, ISVNLocationSegmentHandler handler) {
            this.myNodeKind = kind;
            this.myLastPath = lastPath;
            this.myStartRevision = startRev;
            this.myRangeEnd = startRev;
            this.myHandler = handler;
            this.myCount = 0L;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (this.myIsDone) {
                return;
            }
            long[] copyFromRevision = new long[]{-1L};
            String prevPath = SVNRepository.getPreviousLogPath(null, copyFromRevision, logEntry.getChangedPaths(), this.myLastPath, this.myNodeKind, logEntry.getRevision());
            if (prevPath == null) {
                this.myIsDone = true;
                this.maybeCropAndSendSegment(this.myLastPath, this.myStartRevision, logEntry.getRevision(), this.myRangeEnd, this.myHandler);
                return;
            }
            if (SVNRepository.isValidRevision(copyFromRevision[0])) {
                this.maybeCropAndSendSegment(this.myLastPath, this.myStartRevision, logEntry.getRevision(), this.myRangeEnd, this.myHandler);
                this.myRangeEnd = logEntry.getRevision() - 1L;
                if (logEntry.getRevision() - copyFromRevision[0] > 1L) {
                    this.maybeCropAndSendSegment(null, this.myStartRevision, copyFromRevision[0] + 1L, this.myRangeEnd, this.myHandler);
                    this.myRangeEnd = copyFromRevision[0];
                }
                this.myLastPath = prevPath;
            }
        }

        public void maybeCropAndSendSegment(String path, long startRevision, long rangeStart, long rangeEnd, ISVNLocationSegmentHandler handler) throws SVNException {
            long segmentRangeStart = rangeStart;
            long segmentRangeEnd = rangeEnd;
            if (segmentRangeStart <= startRevision) {
                if (segmentRangeEnd > startRevision) {
                    segmentRangeEnd = startRevision;
                }
                if (handler != null) {
                    handler.handleLocationSegment(new SVNLocationSegment(segmentRangeStart, segmentRangeEnd, path));
                    this.myCount += segmentRangeEnd - segmentRangeStart + 1L;
                }
            }
        }
    }

    private static class FileRevisionsLogHandler
    implements ISVNLogEntryHandler {
        private LinkedList myRevisions = new LinkedList();
        private String myPath;

        public FileRevisionsLogHandler(String path) {
            this.myPath = path;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            Revision rev = new Revision();
            rev.myPath = this.myPath;
            rev.myRevision = logEntry.getRevision();
            rev.myProperties = logEntry.getRevisionProperties();
            this.myRevisions.addFirst(rev);
            this.myPath = SVNRepository.getPreviousLogPath(null, null, logEntry.getChangedPaths(), this.myPath, SVNNodeKind.FILE, logEntry.getRevision());
        }

        public LinkedList getRevisions() {
            return this.myRevisions;
        }
    }

    private static class DeletedRevisionLogHandler
    implements ISVNLogEntryHandler {
        private String myPath;
        private long myDeletedRevision;

        public DeletedRevisionLogHandler(String path) {
            this.myPath = path;
            this.myDeletedRevision = -1L;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            Map changedPaths = logEntry.getChangedPaths();
            Iterator changedPathsIter = changedPaths.keySet().iterator();
            while (changedPathsIter.hasNext()) {
                String path = (String)changedPathsIter.next();
                SVNLogEntryPath change = (SVNLogEntryPath)changedPaths.get(path);
                if (!this.myPath.equals(path) || change.getType() != 'D' && change.getType() != 'R') continue;
                this.myDeletedRevision = logEntry.getRevision();
            }
        }

        public long getDeletedRevision() {
            return this.myDeletedRevision;
        }
    }
}

