/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;
import org.openide.util.ImageUtilities;

class TimelineIconPainter
extends TimelineXYPainter {
    private static final String IMAGE_PATH = "org/netbeans/modules/profiler/snaptracer/impl/resources/genericAction.png";
    private static final Icon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/snaptracer/impl/resources/genericAction.png", (boolean)true);
    private static final int ICON_EXTENT = 8;
    protected final Color color;
    protected final IdeSnapshot snapshot;

    TimelineIconPainter(Color color, IdeSnapshot snapshot) {
        super(8, true, 1.0);
        this.color = color;
        this.snapshot = snapshot;
    }

    @Override
    protected void paint(XYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        if (context.getViewWidth() == 0L) {
            return;
        }
        int[][] visibleBounds = context.getVisibleBounds(dirtyArea);
        int firstFirst = visibleBounds[0][0];
        int firstIndex = firstFirst;
        if (firstIndex == -1) {
            firstIndex = visibleBounds[0][1];
        }
        if (firstIndex == -1) {
            return;
        }
        int minX = dirtyArea.x - 8;
        while (context.getViewX((double)item.getXValue(firstIndex)) > (double)minX && firstIndex > 0) {
            --firstIndex;
        }
        int endIndex = item.getValuesCount() - 1;
        int lastFirst = visibleBounds[1][0];
        int lastIndex = lastFirst;
        if (lastIndex == -1) {
            lastIndex = visibleBounds[1][1];
        }
        if (lastIndex == -1) {
            lastIndex = endIndex;
        }
        int maxX = dirtyArea.x + dirtyArea.width + 8;
        while (context.getViewX((double)item.getXValue(lastIndex)) < (double)maxX && lastIndex < endIndex) {
            ++lastIndex;
        }
        g.setColor(this.color);
        for (int index = firstIndex; index <= lastIndex; ++index) {
            long dataY = item.getYValue(index);
            if (dataY == 0L) continue;
            long dataX = item.getXValue(index);
            int viewX = Utils.checkedInt((double)context.getViewX((double)dataX));
            Icon icon = this.snapshot.getLogInfoForValue(dataY).getIcon();
            if (icon == null) {
                icon = ICON;
            }
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            icon.paintIcon(null, g, viewX - iconWidth / 2, (context.getViewportHeight() - iconHeight) / 2);
        }
    }

    @Override
    protected Color getDefiningColor() {
        return this.color;
    }

    @Override
    public LongRect getItemBounds(ChartItem item) {
        XYItem xyItem = (XYItem)item;
        return this.getDataBounds(xyItem.getBounds());
    }

    @Override
    public LongRect getItemBounds(ChartItem item, ChartContext context) {
        XYItem xyItem = (XYItem)item;
        return this.getViewBounds(xyItem.getBounds(), context);
    }

    @Override
    public boolean isBoundsChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        return !LongRect.equals((LongRect)change.getOldValuesBounds(), (LongRect)change.getNewValuesBounds());
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        LongRect dirtyBounds = change.getDirtyValuesBounds();
        return dirtyBounds.width != 0L && dirtyBounds.height != 0L;
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange itemChange, ChartContext context) {
        XYItemChange change = (XYItemChange)itemChange;
        return this.getViewBounds(change.getDirtyValuesBounds(), context);
    }

    @Override
    public boolean supportsHovering(ChartItem item) {
        return true;
    }

    @Override
    public boolean supportsSelecting(ChartItem item) {
        return true;
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        XYItemSelection sel = (XYItemSelection)selection;
        XYItem item = sel.getItem();
        int selectedValueIndex = sel.getValueIndex();
        if (selectedValueIndex == -1 || selectedValueIndex >= item.getValuesCount()) {
            return new LongRect(0L, 0L, (long)context.getViewportWidth(), (long)context.getViewportHeight());
        }
        return this.getViewBounds(item, selectedValueIndex, context);
    }

    @Override
    public XYItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        int index;
        SynchronousXYChartContext contx = (SynchronousXYChartContext)context;
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        int nearestTimestampIndex = contx.getNearestTimestampIndex(viewX, viewY);
        if (nearestTimestampIndex == -1) {
            return new XYItemSelection.Default((XYItem)xyItem, nearestTimestampIndex, Integer.MAX_VALUE);
        }
        int minX = viewX - 8;
        int maxX = viewX + 8;
        int itemX = Utils.checkedInt((double)contx.getViewX((double)xyItem.getXValue(nearestTimestampIndex)));
        if (itemX > maxX || itemX < minX) {
            return new XYItemSelection.Default((XYItem)xyItem, nearestTimestampIndex, Integer.MAX_VALUE);
        }
        int closest = -1;
        for (index = nearestTimestampIndex; index < xyItem.getValuesCount() && Utils.checkedInt((double)contx.getViewX((double)xyItem.getXValue(index))) <= maxX; ++index) {
            if (xyItem.getYValue(index) == 0L) continue;
            closest = index;
        }
        if (closest != -1) {
            return new XYItemSelection.Default((XYItem)xyItem, closest, Integer.MAX_VALUE);
        }
        for (index = nearestTimestampIndex - 1; index >= 0 && Utils.checkedInt((double)contx.getViewX((double)xyItem.getXValue(index))) >= minX; --index) {
            if (xyItem.getYValue(index) == 0L) continue;
            closest = index;
        }
        if (closest != -1) {
            return new XYItemSelection.Default((XYItem)xyItem, closest, Integer.MAX_VALUE);
        }
        return new XYItemSelection.Default((XYItem)xyItem, nearestTimestampIndex, Integer.MAX_VALUE);
    }

    @Override
    public double getItemView(double dataY, XYItem item, ChartContext context) {
        return -1.0;
    }

    @Override
    public double getItemValue(double viewY, XYItem item, ChartContext context) {
        return -1.0;
    }

    @Override
    public double getItemValueScale(XYItem item, ChartContext context) {
        return -1.0;
    }

    private LongRect getDataBounds(LongRect itemBounds) {
        LongRect bounds = new LongRect(itemBounds);
        bounds.y = 0L;
        bounds.height = 1000L;
        return bounds;
    }

    private LongRect getViewBounds(LongRect itemBounds, ChartContext context) {
        boolean isData = itemBounds.height != 0L;
        LongRect viewBounds = context.getViewRect(itemBounds);
        if (isData) {
            viewBounds.y = Utils.checkedInt((double)context.getViewY((double)(context.getDataHeight() / 2L)));
            viewBounds.height = 0L;
            LongRect.addBorder((LongRect)viewBounds, (long)8L);
        } else {
            LongRect.clear((LongRect)viewBounds);
        }
        return viewBounds;
    }

    private LongRect getViewBounds(XYItem item, int valueIndex, ChartContext context) {
        long xValue = item.getXValue(valueIndex);
        LongRect viewBounds = new LongRect((long)Utils.checkedInt((double)context.getViewX((double)xValue)), (long)Utils.checkedInt((double)context.getViewY((double)(context.getDataHeight() / 2L))), 0L, 0L);
        if (item.getYValue(valueIndex) != 0L) {
            LongRect.addBorder((LongRect)viewBounds, (long)8L);
        }
        return viewBounds;
    }
}

