/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.logs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.profiler.snaptracer.logs.LogRecords;

public final class LogReader {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());
    private File logFile;
    private NavigableMap<Long, LogRecord> recordList;

    public LogReader(File f) {
        this.logFile = f;
        this.recordList = new TreeMap<Long, LogRecord>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream is = new FileInputStream(this.logFile);
        try {
            LogRecords.scan(is, new LogHandler());
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public LogRecord getRecordFor(long time) {
        return this.recordList.ceilingEntry(new Long(time)).getValue();
    }

    class LogHandler
    extends Handler {
        LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            LogReader.this.recordList.put(new Long(record.getMillis()), record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

