/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.netbeans.modules.dlight.util.ui.Renderer;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class DualPaneSupport<T>
extends JSplitPane {
    private static final String SWITCH_TO_LEFT = "switchToLeftComponent";
    private static final String SWITCH_TO_RIGHT = "switchToRightComponent";
    private JComponent detailsComponent;
    private Renderer<T> detailsRenderer;
    private final JComponent masterComponent;

    public DualPaneSupport(JComponent masterComponent, Renderer<T> detailsRenderer) {
        super(1);
        this.detailsRenderer = detailsRenderer;
        this.detailsComponent = null;
        this.masterComponent = masterComponent;
        this.setResizeWeight(0.7);
        this.setContinuousLayout(true);
        this.setLeftComponent(masterComponent);
        this.setFocusCycleRoot(true);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(37, 8), SWITCH_TO_LEFT);
        inputMap.put(KeyStroke.getKeyStroke(39, 8), SWITCH_TO_RIGHT);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(SWITCH_TO_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualPaneSupport.this.focus(DualPaneSupport.this.getLeftComponent());
            }
        });
        actionMap.put(SWITCH_TO_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DualPaneSupport.this.focus(DualPaneSupport.this.getRightComponent());
            }
        });
    }

    private void focus(Component component) {
        while (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getView();
        }
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    @Override
    public void requestFocus() {
        this.masterComponent.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.masterComponent.requestFocusInWindow();
    }

    public void showDetailsFor(T item) {
        boolean keepDividerPos = this.detailsComponent == null == (item == null);
        this.detailsComponent = null;
        if (item == null) {
            this.detailsComponent = new JLabel(NbBundle.getMessage(DualPaneSupport.class, (String)"DualPaneSupport.NoSelection"), 0);
        } else if (this.detailsRenderer != null) {
            this.detailsComponent = this.detailsRenderer.render(item);
        }
        if (this.detailsComponent == null) {
            this.detailsComponent = new JLabel(NbBundle.getMessage(DualPaneSupport.class, (String)"DualPaneSupport.NoDetails"), 0);
        }
        int oldDividerPos = keepDividerPos ? this.getDividerLocation() : 0;
        this.setRightComponent(this.detailsComponent);
        if (keepDividerPos) {
            this.setDividerLocation(oldDividerPos);
        }
    }

    public static <V> DualPaneSupport<V> forExplorerManager(JComponent component, ExplorerManager explorerManager, Renderer<V> detailsRenderer, final DataAdapter<Node, V> dataAdapter) {
        final DualPaneSupport<V> dualPaneSupport = new DualPaneSupport<V>(component, detailsRenderer);
        explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedNodes")) {
                    Node[] selectedNodes = (Node[])evt.getNewValue();
                    if (selectedNodes != null && 0 < selectedNodes.length) {
                        Object data = dataAdapter.convert(selectedNodes[0]);
                        dualPaneSupport.showDetailsFor(data);
                    } else {
                        dualPaneSupport.showDetailsFor(null);
                    }
                }
            }
        });
        dualPaneSupport.showDetailsFor(null);
        return dualPaneSupport;
    }

    public static interface DataAdapter<U, V> {
        public V convert(U var1);
    }
}

