/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class TextFilterPanel
extends JPanel {
    private static final int FIRING_DELAY = 500;
    private final RequestProcessor.Task filterTask;
    private final ChangeSupport cs;
    private final LinkedList<String> model;
    private JButton btnClean;
    private JComboBox cmbFilter;
    private JLabel lblFilter;

    public TextFilterPanel() {
        this.initComponents();
        this.cs = new ChangeSupport((Object)this);
        this.model = new LinkedList();
        this.updateModel();
        this.filterTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                TextFilterPanel.this.cs.fireChange();
            }
        });
        this.cmbFilter.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    TextFilterPanel.this.updateModel();
                    TextFilterPanel.this.updateFilter(true);
                } else {
                    TextFilterPanel.this.updateFilter(false);
                }
            }
        });
        this.cmbFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFilterPanel.this.updateFilter(true);
            }
        });
        this.cmbFilter.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TextFilterPanel.this.updateModel();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void updateFilter(boolean immediately) {
        this.filterTask.schedule(immediately ? 0 : 500);
    }

    private void updateModel() {
        String text = this.getText();
        if (!text.isEmpty()) {
            this.model.remove(text);
            this.model.addFirst(text);
            if (this.model.size() > 5) {
                this.model.removeLast();
            }
        }
        this.cmbFilter.setModel(new DefaultComboBoxModel<String>(this.model.toArray(new String[this.model.size()])));
    }

    public String getText() {
        return this.cmbFilter.getEditor().getItem().toString();
    }

    public void addWeakChangeListener(ChangeListener l) {
        this.cs.addChangeListener(WeakListeners.change((ChangeListener)l, (Object)this));
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private void initComponents() {
        this.lblFilter = new JLabel();
        this.cmbFilter = new JComboBox();
        this.btnClean = new JButton();
        this.lblFilter.setFont(this.lblFilter.getFont().deriveFont(this.lblFilter.getFont().getStyle() | 1));
        this.lblFilter.setLabelFor(this.cmbFilter);
        this.lblFilter.setText(NbBundle.getMessage(TextFilterPanel.class, (String)"TextFilterPanel.lblFilter.text"));
        this.cmbFilter.setEditable(true);
        this.btnClean.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/dlight/util/resources/clean.png")));
        this.btnClean.setText(NbBundle.getMessage(TextFilterPanel.class, (String)"TextFilterPanel.btnClean.text"));
        this.btnClean.setContentAreaFilled(false);
        this.btnClean.setFocusPainted(false);
        this.btnClean.setFocusable(false);
        this.btnClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextFilterPanel.this.btnCleanActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbFilter, 0, 215, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClean, -2, 25, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblFilter).addComponent(this.cmbFilter, -2, -1, -2).addComponent(this.btnClean)));
    }

    private void btnCleanActionPerformed(ActionEvent evt) {
        this.cmbFilter.getEditor().setItem(null);
        this.updateFilter(true);
    }
}

