/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform;

import java.lang.constant.Constable;
import java.util.Map;

public class CDCDevice {
    private String name;
    private String description;
    private CDCProfile[] profiles;
    private Screen[] screens;

    public CDCDevice() {
        this("Default", "Default device");
    }

    public CDCDevice(String name, String description) {
        this(name, description, null, null);
    }

    public CDCDevice(String name, String description, CDCProfile[] profiles, Screen[] screens) {
        this.name = name;
        this.description = description;
        this.profiles = profiles;
        this.screens = screens;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CDCProfile[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(CDCProfile[] profiles) {
        this.profiles = profiles;
    }

    public Screen[] getScreens() {
        return this.screens;
    }

    public void setScreens(Screen[] screens) {
        this.screens = screens;
    }

    public String toString() {
        return this.getName();
    }

    public static class Screen {
        private Integer width;
        private Integer height;
        private Integer bitDepth;
        private Boolean color = Boolean.TRUE;
        private Boolean touch = Boolean.FALSE;
        private Boolean main = Boolean.TRUE;

        public Screen(String width, String height, String bitDepth, String color, String touch, String main) {
            Constable o;
            try {
                o = new Integer(width);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.width = o;
            try {
                o = new Integer(height);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.height = o;
            try {
                o = new Integer(bitDepth);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.bitDepth = o;
            try {
                o = new Boolean(color);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.color = (Boolean)o;
            try {
                o = new Boolean(touch);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.touch = (Boolean)o;
            try {
                o = new Boolean(main);
            }
            catch (NumberFormatException e) {
                o = null;
            }
            this.main = (Boolean)o;
        }

        public Integer getBitDepth() {
            return this.bitDepth;
        }

        public Boolean getColor() {
            return this.color;
        }

        public Integer getHeight() {
            return this.height;
        }

        public Boolean getTouch() {
            return this.touch;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Boolean istMain() {
            return this.main;
        }
    }

    public static class CDCProfile {
        private String name;
        private String version;
        private String description;
        private Map<String, String> executionModes;
        private String bootClassPath;
        private String runClassPath;
        private boolean isDefault;

        public CDCProfile(String name, String description, String version, Map<String, String> executionModes, String bootClassPath, String runClassPath, boolean isDefault) {
            this.name = name;
            this.version = version;
            this.description = description;
            this.executionModes = executionModes;
            this.bootClassPath = bootClassPath;
            this.runClassPath = runClassPath;
            this.isDefault = isDefault;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, String> getExecutionModes() {
            return this.executionModes;
        }

        public void setExecutionModes(Map<String, String> executionModes) {
            this.executionModes = executionModes;
        }

        public String getBootClassPath() {
            return this.bootClassPath;
        }

        public void setBootClassPath(String bootClassPath) {
            this.bootClassPath = bootClassPath;
        }

        public String getRunClassPath() {
            return this.runClassPath;
        }

        public void setRunClassPath(String runClassPath) {
            this.runClassPath = runClassPath;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public String toString() {
            return this.getName();
        }
    }
}

