/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class TokenReplacer {
    private Map<String, String> tokens = new HashMap<String, String>();
    private final ClientStubsGenerator clientStubsGenerator;

    TokenReplacer(ClientStubsGenerator clientStubsGenerator) {
        this.clientStubsGenerator = clientStubsGenerator;
    }

    public Map<String, String> getTokens() {
        return Collections.unmodifiableMap(this.tokens);
    }

    public void addToken(String string, String string2) {
        this.tokens.put(string, string2);
    }

    public void setTokens(Map<String, String> map) {
        this.tokens = map;
    }

    public void replaceTokens(FileObject fileObject) throws IOException {
        this.replaceTokens(fileObject, this.getTokens());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTokens(FileObject fileObject, Map<String, String> map) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                string = this.replaceTokens(string, "", "", map);
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), this.clientStubsGenerator.getBaseEncoding());
            try {
                outputStreamWriter.write(stringBuffer.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    protected ClientStubsGenerator getGenerator() {
        return this.clientStubsGenerator;
    }

    private String replaceTokens(String string, String string2, String string3, Map<String, String> map) {
        String string4 = string;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string5 = entry.getKey();
            String string6 = entry.getValue();
            if (string5 == null || string6 == null) continue;
            string4 = string4.replaceAll(string5, string6);
        }
        return string4;
    }
}

