/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.rest.support.Utils;

public class ParameterInfo {
    private String name;
    private Class type;
    private String typeName;
    private Object defaultValue;
    private boolean isQueryParam;
    private QName qname;

    public ParameterInfo(String name, Class type) {
        this(name, type, null);
    }

    public ParameterInfo(QName qname, Class type, String typeName) {
        this(qname.getLocalPart(), type, typeName);
        this.qname = qname;
    }

    public ParameterInfo(String name, Class type, String typeName) {
        this.name = name;
        this.type = type;
        this.typeName = typeName;
        this.defaultValue = null;
        this.isQueryParam = ParameterInfo.isQualifiedParameterType(type);
    }

    private static boolean isQualifiedParameterType(Class type) {
        return type.isPrimitive() || type.equals(String.class) || Utils.getValueOfMethod(type) != null || Utils.getConstructorWithStringParam(type) != null;
    }

    public String getName() {
        return this.name;
    }

    public QName getQName() {
        if (this.qname == null) {
            this.qname = new QName(this.name);
        }
        return this.qname;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        if (this.typeName == null) {
            return this.type.getName();
        }
        return this.typeName;
    }

    public String getSimpleTypeName() {
        return this.type.getSimpleName();
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = this.generateDefaultValue();
        }
        return this.defaultValue;
    }

    public boolean isQueryParam() {
        return this.isQueryParam;
    }

    public void setIsQueryParam(boolean flag) {
        this.isQueryParam = flag;
    }

    private Object generateDefaultValue() {
        if (this.type == Integer.class || this.type == Short.class || this.type == Long.class || this.type == Float.class || this.type == Double.class) {
            try {
                return this.type.getConstructor(String.class).newInstance("0");
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (this.type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (this.type == Character.class) {
            return new Character('\u0000');
        }
        return null;
    }
}

