/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import javax.swing.JComponent;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.ContainerItemSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.SingletonSetupPanelVisual;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

final class PatternResourcesSetupPanel
extends AbstractPanel {
    private JComponent component;
    private Pattern currentPattern = Pattern.CONTAINER;
    private String[] allWizardSteps;
    private int indexInAllSteps = 2;

    public PatternResourcesSetupPanel(String name, WizardDescriptor wizardDescriptor) {
        super(name, wizardDescriptor);
    }

    @Override
    public boolean isFinishPanel() {
        return true;
    }

    public void setCurrentPattern(Pattern pattern) {
        if (this.currentPattern != pattern) {
            this.component = null;
            this.currentPattern = pattern;
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = this.currentPattern.createUI(this.panelName);
            if (this.allWizardSteps != null) {
                this.component.putClientProperty("WizardPanel_contentData", this.allWizardSteps);
                this.component.putClientProperty("WizardPanel_contentSelectedIndex", this.indexInAllSteps);
            }
            this.component.setName(this.panelName);
            ((AbstractPanel.Settings)((Object)this.component)).addChangeListener(this);
        }
        return this.component;
    }

    void saveStepsAndIndex() {
        if (this.component != null) {
            this.allWizardSteps = (String[])this.component.getClientProperty("WizardPanel_contentData");
            this.indexInAllSteps = (Integer)this.component.getClientProperty("WizardPanel_contentSelectedIndex");
        }
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static enum Pattern {
        CONTAINER(ContainerItemSetupPanelVisual.class),
        STANDALONE(SingletonSetupPanelVisual.class),
        CLIENTCONTROLLED(ContainerItemSetupPanelVisual.class);

        private Class<? extends JComponent> componentClass;

        private Pattern(Class<? extends JComponent> componentClass) {
            this.componentClass = componentClass;
        }

        public JComponent createUI(String name) {
            try {
                return this.componentClass.getConstructor(String.class).newInstance(name);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

