/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ClassUtils;

public class UserAggregate
extends DbObjectBase {
    private String className;
    private Class javaClass;

    public UserAggregate(Database database, int n, String string, String string2, boolean bl) throws SQLException {
        this.initDbObjectBase(database, n, string, "function");
        this.className = string2;
        if (!bl) {
            this.getInstance();
        }
    }

    public AggregateFunction getInstance() throws SQLException {
        if (this.javaClass == null) {
            this.javaClass = ClassUtils.loadUserClass(this.className);
        }
        try {
            Object t = this.javaClass.newInstance();
            AggregateFunction aggregateFunction = (AggregateFunction)t;
            return aggregateFunction;
        }
        catch (Exception exception) {
            throw Message.convert(exception);
        }
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.getInternalError();
    }

    public String getDropSQL() {
        return "DROP AGGREGATE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE FORCE AGGREGATE ");
        stringBuffer.append(this.getSQL());
        stringBuffer.append(" FOR ");
        stringBuffer.append(Parser.quoteIdentifier(this.className));
        return stringBuffer.toString();
    }

    public int getType() {
        return 14;
    }

    public synchronized void removeChildrenAndResources(Session session) throws SQLException {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.javaClass = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getJavaClassName() {
        return this.className;
    }
}

