/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.DiffPanel;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryTopComponent;
import org.netbeans.modules.localhistory.ui.view.StoreEntryNode;
import org.netbeans.modules.localhistory.utils.FileUtils;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class LocalHistoryDiffView
implements PropertyChangeListener,
ActionListener,
VersioningListener {
    private final LocalHistoryTopComponent master;
    private DiffPanel panel;
    private Component diffComponent;
    private DiffController diffView;
    private DiffPrepareTask prepareTask = null;
    private boolean selected;

    public LocalHistoryDiffView(LocalHistoryTopComponent master) {
        this.master = master;
        this.panel = new DiffPanel();
        this.panel.nextButton.addActionListener(this);
        this.panel.prevButton.addActionListener(this);
        LocalHistory.getInstance().addVersioningListener(this);
        this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)"MSG_DiffPanel_NoVersion"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.disableNavigationButtons();
            this.selectionChanged(evt);
        } else if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            this.refreshNavigationButtons();
        }
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() != LocalHistory.EVENT_FILE_CREATED) {
            return;
        }
        File file = (File)event.getParams()[0];
        if (file == null || this.prepareTask == null || !this.selected || !file.equals(this.prepareTask.entry.getFile())) {
            return;
        }
        LocalHistoryDiffView.scheduleTask(this.prepareTask);
    }

    JPanel getPanel() {
        return this.panel;
    }

    private void selectionChanged(PropertyChangeEvent evt) {
        StoreEntry se;
        Node[] newSelection = (Node[])evt.getNewValue();
        if (newSelection != null && newSelection.length == 1 && (se = (StoreEntry)newSelection[0].getLookup().lookup(StoreEntry.class)) != null) {
            this.selected = true;
            this.refreshDiffPanel(se);
            return;
        }
        this.selected = false;
        String msgKey = newSelection == null || newSelection.length == 0 ? "MSG_DiffPanel_NoVersion" : "MSG_DiffPanel_IllegalSelection";
        this.showNoContent(NbBundle.getMessage(LocalHistoryDiffView.class, (String)msgKey));
    }

    private void refreshDiffPanel(StoreEntry se) {
        this.prepareTask = new DiffPrepareTask(se);
        LocalHistoryDiffView.scheduleTask(this.prepareTask);
    }

    private static void scheduleTask(Runnable runnable) {
        RequestProcessor.Task task = LocalHistory.getInstance().getParallelRequestProcessor().create(runnable);
        task.schedule(0);
    }

    private static void extractHistoryFile(StoreEntry entry, File tmpHistoryFile) throws IOException {
        File file = entry.getFile();
        tmpHistoryFile.deleteOnExit();
        FileUtils.copy(entry.getStoreFileInputStream(), tmpHistoryFile);
        Utils.associateEncoding((File)file, (File)tmpHistoryFile);
    }

    private void showNoContent(String s) {
        this.setDiffComponent((Component)new NoContentPanel(s));
    }

    private void setDiffComponent(Component component) {
        if (this.diffComponent != null) {
            this.panel.diffPanel.remove(this.diffComponent);
        }
        this.panel.diffPanel.add(component, "Center");
        this.diffComponent = component;
        this.panel.diffPanel.revalidate();
        this.panel.diffPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.nextButton) {
            this.onNextButton();
        } else if (evt.getSource() == this.panel.prevButton) {
            this.onPrevButton();
        }
    }

    private void onNextButton() {
        if (this.diffView == null) {
            return;
        }
        int nextDiffernce = this.diffView.getDifferenceIndex() + 1;
        if (nextDiffernce < this.diffView.getDifferenceCount()) {
            this.setCurrentDifference(nextDiffernce);
        }
    }

    private void onPrevButton() {
        if (this.diffView == null) {
            return;
        }
        int prevDiffernce = this.diffView.getDifferenceIndex() - 1;
        if (prevDiffernce > -1) {
            this.setCurrentDifference(prevDiffernce);
        }
    }

    private void setCurrentDifference(int idx) {
        this.diffView.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, idx);
        this.refreshNavigationButtons();
    }

    private void disableNavigationButtons() {
        this.panel.prevButton.setEnabled(false);
        this.panel.nextButton.setEnabled(false);
    }

    private void refreshNavigationButtons() {
        int currentDifference = this.diffView.getDifferenceIndex();
        this.panel.prevButton.setEnabled(currentDifference > 0);
        this.panel.nextButton.setEnabled(currentDifference < this.diffView.getDifferenceCount() - 1);
    }

    private class LHStreamSource
    extends StreamSource {
        private final File file;
        private final String title;
        private final String mimeType;

        public LHStreamSource(File file, String title, String mimeType) {
            this.file = file;
            this.title = title;
            this.mimeType = mimeType;
        }

        public boolean isEditable() {
            FileObject fo = FileUtils.toFileObject(this.file);
            return this.isPrimary(fo);
        }

        private boolean isPrimary(FileObject fo) {
            if (fo != null) {
                try {
                    DataObject dao = DataObject.find((FileObject)fo);
                    return fo.equals(dao.getPrimaryFile());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return true;
        }

        public Lookup getLookup() {
            FileObject fo = FileUtils.toFileObject(this.file);
            if (fo != null && this.isPrimary(fo)) {
                return Lookups.fixed((Object[])new Object[]{fo});
            }
            return Lookups.fixed((Object[])new Object[0]);
        }

        public String getName() {
            return this.title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            return new FileReader(this.file);
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            return null;
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final StoreEntry entry;

        public DiffPrepareTask(StoreEntry se) {
            this.entry = se;
        }

        @Override
        public void run() {
            final File file = this.entry.getFile();
            File tempFolder = Utils.getTempFolder();
            final File tmpHistoryFile = new File(tempFolder, file.getName());
            LinkedList<File> siblingTmpFiles = new LinkedList<File>();
            try {
                LocalHistoryDiffView.extractHistoryFile(this.entry, tmpHistoryFile);
                List<StoreEntry> siblings = this.entry.getSiblingEntries();
                for (StoreEntry siblingEntry : siblings) {
                    File tmpHistorySiblingFile = new File(tempFolder, siblingEntry.getFile().getName());
                    siblingTmpFiles.add(tmpHistorySiblingFile);
                    LocalHistoryDiffView.extractHistoryFile(siblingEntry, tmpHistorySiblingFile);
                }
            }
            catch (IOException ioe) {
                LocalHistory.LOG.log(Level.SEVERE, null, ioe);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        StreamSource ss2;
                        LHStreamSource ss1 = new LHStreamSource(tmpHistoryFile, DiffPrepareTask.this.entry.getFile().getName() + " " + StoreEntryNode.getFormatedDate(DiffPrepareTask.this.entry), DiffPrepareTask.this.entry.getMIMEType());
                        if (file.exists()) {
                            String title = NbBundle.getMessage(LocalHistoryDiffView.class, (String)"LBL_Diff_CurrentFile");
                            ss2 = new LHStreamSource(file, title, DiffPrepareTask.this.entry.getMIMEType());
                        } else {
                            String title = NbBundle.getMessage(LocalHistoryDiffView.class, (String)"LBL_Diff_FileDeleted");
                            ss2 = StreamSource.createSource((String)"currentfile", (String)title, (String)DiffPrepareTask.this.entry.getMIMEType(), (Reader)new StringReader(""));
                        }
                        LocalHistoryDiffView.this.diffView = DiffController.create((StreamSource)ss1, (StreamSource)ss2);
                        LocalHistoryDiffView.this.diffView.addPropertyChangeListener((PropertyChangeListener)LocalHistoryDiffView.this);
                        JComponent c = LocalHistoryDiffView.this.diffView.getJComponent();
                        LocalHistoryDiffView.this.setDiffComponent(c);
                        LocalHistoryDiffView.this.master.setDiffView(c);
                        if (LocalHistoryDiffView.this.diffView.getDifferenceCount() > 0) {
                            LocalHistoryDiffView.this.setCurrentDifference(0);
                        } else {
                            LocalHistoryDiffView.this.refreshNavigationButtons();
                        }
                        LocalHistoryDiffView.this.panel.revalidate();
                        LocalHistoryDiffView.this.panel.repaint();
                    }
                    catch (IOException ioe) {
                        LocalHistory.LOG.log(Level.SEVERE, null, ioe);
                    }
                }
            });
        }
    }
}

