/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DisplayTableSorter
extends AbstractTableModel
implements TableModelListener {
    private int[] index = null;
    private int sort = 0;
    protected TableModel model;
    private static final boolean debug = false;

    public DisplayTableSorter(TableModel model) {
        this.setModel(model);
        this.resetIndices();
    }

    public void sort(int sort) {
        this.sort = sort;
        if (sort == 0) {
            this.tableChanged(new TableModelEvent(this));
            return;
        }
        this.resetIndices();
        this.sort((int[])this.index.clone(), this.index, 0, this.index.length);
        this.tableChanged(new TableModelEvent(this));
    }

    public void sort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.sort(to, from, low, middle);
        this.sort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public int compare(int row1, int row2) {
        String str2;
        String str1 = (String)this.model.getValueAt(row1, 0);
        int result = str1.compareTo(str2 = (String)this.model.getValueAt(row2, 0));
        if (result == 0) {
            return 0;
        }
        boolean ascending = this.sort == 1;
        return ascending ? result : -result;
    }

    public void resetIndices() {
        int rowCount = this.getRowCount();
        this.index = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.index[row] = row;
        }
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel model) {
        this.model = model;
        model.addTableModelListener(this);
    }

    public Object getValueAt(int aRow, int aColumn) {
        if (this.sort == 0) {
            return this.model.getValueAt(aRow, aColumn);
        }
        return this.model.getValueAt(this.index[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        if (this.sort == 0) {
            this.model.setValueAt(aValue, aRow, aColumn);
            return;
        }
        this.model.setValueAt(aValue, this.index[aRow], aColumn);
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model == null ? 0 : this.model.getColumnCount();
    }

    public String getColumnName(int aColumn) {
        return this.model.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return this.model.getColumnClass(aColumn);
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, column);
    }

    public void tableChanged(TableModelEvent e) {
        this.fireTableChanged(e);
    }

    private void log(String s) {
        System.out.println("DisplayTableSorter::" + s);
    }
}

