/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.NbBundle;

public abstract class RemoteConnectionSupport {
    protected final ExecutionEnvironment executionEnvironment;
    private int exit_status;
    private boolean cancelled = false;
    private boolean failed = false;
    private boolean connected = true;
    private String failureReason;

    public RemoteConnectionSupport(ExecutionEnvironment env) {
        this.executionEnvironment = env;
        this.exit_status = -1;
        this.failureReason = "";
        RemoteUtil.LOGGER.log(Level.FINEST, "RCS<Init>: Starting {0} on {1}", new Object[]{this.getClass().getName(), this.executionEnvironment});
        if (!ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
            this.connected = false;
            try {
                ConnectionManager.getInstance().connectTo(this.executionEnvironment);
                this.connected = true;
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.WARNING, "RCS<Init>: Got {0} [{1}]", new Object[]{ex.getClass().getSimpleName(), ex.getMessage()});
                RemoteUtil.LOGGER.log(Level.FINE, "Caused by:", ex);
            }
            catch (CancellationException ex) {
                this.cancelled = true;
            }
            if (!ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
                RemoteUtil.LOGGER.log(Level.FINE, "RCS<Init>: Connection failed on {0}", this.executionEnvironment);
            }
        }
    }

    public static String getMessage(IOException e) {
        String reason = e.getMessage();
        String result = e instanceof UnknownHostException ? NbBundle.getMessage(RemoteConnectionSupport.class, (String)"REASON_UnknownHost", (Object)e.getMessage()) : (reason.startsWith("Auth fail") ? NbBundle.getMessage(RemoteConnectionSupport.class, (String)"REASON_AuthFailed") : reason);
        return result;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public int getExitStatus() {
        return this.exit_status;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isFailedOrCancelled() {
        return this.failed || this.cancelled;
    }

    public void setFailed(String reason) {
        this.failed = true;
        this.failureReason = reason;
    }

    protected void setExitStatus(int exit_status) {
        this.exit_status = exit_status;
    }

    public String getUser() {
        return this.executionEnvironment.getUser();
    }

    public String getHost() {
        return this.executionEnvironment.getHost();
    }
}

