/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostVisualPanel1;
import org.netbeans.modules.cnd.remote.ui.wizard.SelectHostWizardPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class SelectHostVisualPanel
extends JPanel {
    private final SelectHostWizardPanel controller;
    private final boolean allowLocal;
    private final DefaultListModel model;
    private final CreateHostVisualPanel1 createHostPanel;
    private final AtomicBoolean setupNewHost;
    private RequestProcessor.Task focusTask;
    private static final String LAST_SELECTED_HOST_KEY = "last-selected-remote-host";
    private ButtonGroup buttonGroup;
    private JScrollPane existentHostScroller;
    private JList lstDevHosts;
    private JPanel newHostPane;
    private JRadioButton rbExistent;
    private JRadioButton rbNew;

    public SelectHostVisualPanel(SelectHostWizardPanel controller, boolean allowLocal, CreateHostVisualPanel1 createHostPanel, AtomicBoolean setupNewHost) {
        this.setName(NbBundle.getMessage(SelectHostVisualPanel.class, (String)"SelectHostVisualPanel.title"));
        this.controller = controller;
        this.setupNewHost = setupNewHost;
        this.allowLocal = allowLocal;
        this.createHostPanel = createHostPanel;
        this.initComponents();
        this.newHostPane.add((Component)createHostPanel, "Center");
        this.rbNew.setSelected(setupNewHost.get());
        this.rbExistent.setSelected(!setupNewHost.get());
        this.model = new DefaultListModel();
        this.rbNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectHostVisualPanel.this.requestFocusInEDT(SelectHostVisualPanel.this.createHostPanel);
            }
        });
        this.rbExistent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectHostVisualPanel.this.requestFocusInEDT(SelectHostVisualPanel.this.lstDevHosts);
            }
        });
    }

    private void requestFocusInEDT(final Component c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.requestFocus();
            }
        });
    }

    private boolean setDefaultHostSelection() {
        if (this.model.size() > 0) {
            ServerRecord defRec = ServerList.getDefaultRecord();
            if (defRec.isRemote()) {
                this.lstDevHosts.setSelectedValue(defRec, true);
                return true;
            }
            String hostKey = NbPreferences.forModule(this.getClass()).get(LAST_SELECTED_HOST_KEY, null);
            if (hostKey == null) {
                this.lstDevHosts.setSelectedIndex(0);
                return true;
            }
            for (int i = 0; i < this.model.getSize(); ++i) {
                ServerRecord record = (ServerRecord)this.model.get(i);
                if (!hostKey.equals(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)record.getExecutionEnvironment()))) continue;
                this.lstDevHosts.setSelectedIndex(i);
                return true;
            }
        }
        return false;
    }

    private void rememberHostSelection() {
        ServerRecord record = (ServerRecord)this.lstDevHosts.getSelectedValue();
        if (record != null) {
            String hostKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)record.getExecutionEnvironment());
            NbPreferences.forModule(this.getClass()).put(LAST_SELECTED_HOST_KEY, hostKey);
        }
    }

    private void initServerList() {
        this.model.clear();
        for (ServerRecord rec : ServerList.getRecords()) {
            if (!rec.isRemote() && !this.allowLocal) continue;
            this.model.addElement(rec);
        }
        boolean fire = false;
        if (this.model.isEmpty()) {
            if (!this.rbNew.isSelected()) {
                this.rbNew.setSelected(true);
                this.rbExistent.setSelected(false);
                fire = true;
            }
            this.rbExistent.setEnabled(false);
        }
        this.lstDevHosts.setModel(this.model);
        this.lstDevHosts.setCellRenderer(new HostListCellRenderer());
        fire = this.setDefaultHostSelection();
        this.lstDevHosts.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SelectHostVisualPanel.this.fireChange();
                }
            }
        });
        if (fire) {
            this.fireChange();
        }
    }

    public boolean getSetupNewHost() {
        return this.rbNew.isSelected();
    }

    private void fireChange() {
        this.controller.stateChanged(new ChangeEvent(this));
    }

    void onReadSettings() {
        this.initServerList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectHostVisualPanel.this.modeChanged();
            }
        });
    }

    void onStoreSettings() {
        this.rememberHostSelection();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.rbExistent = new JRadioButton();
        this.rbNew = new JRadioButton();
        this.newHostPane = new JPanel();
        this.existentHostScroller = new JScrollPane();
        this.lstDevHosts = new JList();
        this.setMaximumSize(new Dimension(534, 409));
        this.setPreferredSize(new Dimension(534, 409));
        this.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.rbExistent);
        Mnemonics.setLocalizedText((AbstractButton)this.rbExistent, (String)NbBundle.getMessage(SelectHostVisualPanel.class, (String)"SelectHostVisualPanel.rbExistent.text"));
        this.rbExistent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectHostVisualPanel.this.selectExistentHostActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.rbExistent, gridBagConstraints);
        this.buttonGroup.add(this.rbNew);
        Mnemonics.setLocalizedText((AbstractButton)this.rbNew, (String)NbBundle.getMessage(SelectHostVisualPanel.class, (String)"SelectHostVisualPanel.rbNew.text"));
        this.rbNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectHostVisualPanel.this.setupNewHostActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.rbNew, gridBagConstraints);
        this.newHostPane.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.newHostPane, gridBagConstraints);
        this.lstDevHosts.setSelectionMode(0);
        this.existentHostScroller.setViewportView(this.lstDevHosts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.existentHostScroller, gridBagConstraints);
    }

    private void selectExistentHostActionPerformed(ActionEvent evt) {
        this.setupNewHost.set(false);
        this.modeChanged();
        this.fireChange();
    }

    private void setupNewHostActionPerformed(ActionEvent evt) {
        this.setupNewHost.set(true);
        this.modeChanged();
        this.fireChange();
    }

    private void modeChanged() {
        if (this.setupNewHost.get()) {
            this.lstDevHosts.setEnabled(false);
            this.createHostPanel.setEnabled(true);
        } else {
            this.lstDevHosts.setEnabled(true);
            this.createHostPanel.setEnabled(false);
        }
    }

    public boolean isExistent() {
        return this.rbExistent.isSelected();
    }

    public ExecutionEnvironment getSelectedHost() {
        if (this.rbExistent.isSelected()) {
            ServerRecord record = (ServerRecord)this.lstDevHosts.getSelectedValue();
            return record == null ? null : record.getExecutionEnvironment();
        }
        return null;
    }

    void enableControls(boolean enable) {
        this.rbExistent.setEnabled(enable);
        this.rbExistent.setEnabled(enable);
        this.lstDevHosts.setEnabled(enable);
        this.createHostPanel.setEnabled(enable);
    }

    private final class HostListCellRenderer
    extends DefaultListCellRenderer {
        private HostListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel out = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                ServerRecord rec = (ServerRecord)value;
                out.setText(rec.getDisplayName());
            }
            return out;
        }
    }
}

