/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.InputOutput;

public class DbgActionHandler
implements ProjectActionHandler {
    private Collection<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    protected ProjectActionEvent pae;

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes) {
        this.pae = pae;
    }

    public void addExecutionListener(ExecutionListener l) {
        this.listeners.add(l);
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return false;
    }

    public void cancel() {
    }

    public void execute(final InputOutput io) {
        final String executable = this.pae.getExecutable();
        final DebuggerManager dm = DebuggerManager.get();
        dm.setIO(io);
        String hostName = CndRemote.userhostFromConfiguration((Configuration)this.pae.getConfiguration());
        CndRemote.validate(hostName, new Runnable(){

            public void run() {
                DbgActionHandler.this.doExecute(executable, dm, io);
            }
        });
    }

    private void doExecute(final String executable, final DebuggerManager dm, InputOutput io) {
        MakeConfiguration configuration = this.pae.getConfiguration();
        RunProfile profile = this.pae.getProfile();
        this.executionStarted();
        Runnable loadProgram = new Runnable((Configuration)configuration, io, profile){
            final /* synthetic */ Configuration val$configuration;
            final /* synthetic */ InputOutput val$io;
            final /* synthetic */ RunProfile val$profile;
            {
                this.val$configuration = configuration;
                this.val$io = inputOutput;
                this.val$profile = runProfile;
            }

            public void run() {
                if (DbgActionHandler.this.pae.getType() == ProjectActionEvent.PredefinedType.DEBUG) {
                    dm.setAction(1);
                    dm.removeAction(2);
                    DebuggerManager.get().debug(executable, this.val$configuration, CndRemote.userhostFromConfiguration(this.val$configuration), this.val$io, DbgActionHandler.this, this.val$profile);
                } else if (DbgActionHandler.this.pae.getType() == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO) {
                    dm.setAction(2);
                    dm.removeAction(1);
                    DebuggerManager.get().debug(executable, this.val$configuration, CndRemote.userhostFromConfiguration(this.val$configuration), this.val$io, DbgActionHandler.this, this.val$profile);
                } else assert (false);
            }
        };
        SwingUtilities.invokeLater(loadProgram);
    }

    private void executionStarted() {
        for (ExecutionListener listener : this.listeners) {
            listener.executionStarted(-1);
        }
    }

    public void executionFinished(int rc) {
        for (ExecutionListener listener : this.listeners) {
            listener.executionFinished(rc);
        }
    }

    private static DataNode findDebuggableNode(String filePath) {
        FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(filePath)));
        if (fo == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dataObject == null) {
            return null;
        }
        Node node = dataObject.getNodeDelegate();
        if (node == null) {
            return null;
        }
        if (!(node instanceof DataNode)) {
            return null;
        }
        return (DataNode)node;
    }
}

