/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.debugger.common2.DbgActionHandler;
import org.netbeans.modules.cnd.debugger.common2.DbgGuiModule;
import org.netbeans.modules.cnd.debugger.common2.debugger.ActionEnabler;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DialogManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Error;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelListenerSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.RoutingToken;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ProjectSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTargetList;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.ConsoleTopComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.PioTopComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.EngineProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.GlobalOptionSet;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHost;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.debugger.common2.utils.InfoPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.ItemSelectorDialog;
import org.netbeans.modules.cnd.debugger.common2.utils.ItemSelectorResult;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionClient;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionLayers;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.spi.viewmodel.ModelListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebuggerManager
extends DebuggerManagerAdapter {
    private static final boolean standalone = "on".equals(System.getProperty("spro.dbxtool"));
    private NativeDebugger currentDebugger;
    private InputOutput io;
    private ChangeListener changeListener;
    private static ActionEnabler actionEnabler;
    private ModelChangeDelegator sessionUpdater = new ModelChangeDelegator();
    private final Map<Watch, NativeWatch> watchMap = new HashMap<Watch, NativeWatch>();
    private static DebugTargetList debugtargetlist;
    private static final Preferences prefs;
    private static final String PREFIX = "Doption.";
    private static final String PREF_DONOTSHOWAGAIN = "Doption.doNotShowAgain";
    private CustomizableHostList hostList = null;
    private WatchBag watchBag;
    private ModelListenerSupport watchModelListener = new ModelListenerSupport("watch");
    private ModelChangeDelegator watchUpdater = new ModelChangeDelegator();
    private BreakpointBag breakpointBag;
    private ModelListenerSupport breakpointModelListener = new ModelListenerSupport("breakpoint");
    private ModelChangeDelegator breakpointUpdater = new ModelChangeDelegator();
    private boolean isfixing = false;
    private DialogManager currentDialog;
    private static StatusDisplayer statusDisplayer;
    private ProgressMonitor progressMonitor = null;
    private static boolean last_stopAfterFork;
    private OptionSet globalOptions = null;
    private int action = 0;
    public static final int RUN = 1;
    public static final int STEP = 2;
    public static final int ATTACH = 4;
    public static final int CORE = 8;
    public static final int LOAD = 16;
    public static final int CONNECT = 32;

    private DebuggerManager() {
        DebuggerManager.delegate().addDebuggerListener((DebuggerManagerListener)this);
    }

    public static DebuggerManager get() {
        return LazyInitializer.singleton;
    }

    public static boolean isStartModel() {
        String flowModel = System.getProperty("cnd.debuggerflowmodel");
        if ("Start".equals(flowModel)) {
            return true;
        }
        return !"LoadRun".equals(flowModel);
    }

    public static boolean isChoosableEngine() {
        boolean ret = false;
        String engine_state = System.getProperty("debug.engine");
        ret = "on".equalsIgnoreCase(engine_state);
        return ret;
    }

    public static boolean is64Debuggee(NativeDebuggerInfo ndi, Host host) {
        int act = ndi.getAction();
        String debuggee = null;
        Executor executor = Executor.getDefault(Catalog.get("File"), host, 0);
        if ((act & 8) != 0) {
            debuggee = ndi.getCorefile();
        } else if ((act & 4) != 0) {
            debuggee = executor.readlink(ndi.getPid());
            if (debuggee == null) {
                return false;
            }
        } else {
            debuggee = ndi.getTarget();
        }
        if (debuggee == null || debuggee.length() == 0) {
            return host.isLinux64();
        }
        return executor.is_64(debuggee);
    }

    public static boolean isPerTargetBpts() {
        if (!DebuggerManager.isStandalone()) {
            return false;
        }
        String perTargetBpts = System.getProperty("dbxgui.pertargetbpts");
        if ("true".equals(perTargetBpts)) {
            return true;
        }
        return !"false".equals(perTargetBpts);
    }

    public static boolean isAsyncStart() {
        return false;
    }

    public Collection<NativeDebugger> nativeDebuggers() {
        ArrayList<NativeDebugger> list = new ArrayList<NativeDebugger>();
        NativeSession[] sessions = this.getSessions();
        for (int sx = 0; sx < sessions.length; ++sx) {
            NativeSession s = sessions[sx];
            DebuggerEngine engine = s.coreSession().getCurrentEngine();
            NativeDebugger debugger = (NativeDebugger)engine.lookupFirst(null, NativeDebugger.class);
            if (debugger == null) continue;
            list.add(debugger);
        }
        return list;
    }

    public void spreadWatchCreation(NativeDebugger origin, NativeWatch nativeWatch) {
        if (Log.Watch.pathway) {
            System.out.println("Spreading watch creation ...");
        }
        for (NativeSession s : this.getSessions()) {
            DebuggerEngine engine = s.coreSession().getCurrentEngine();
            NativeDebugger debugger = (NativeDebugger)engine.lookupFirst(null, NativeDebugger.class);
            if (debugger == null) {
                if (!Log.Watch.pathway) continue;
                System.out.println("\t... null debugger");
                continue;
            }
            if (debugger == origin) {
                if (!Log.Watch.pathway) continue;
                System.out.println("\t... origin debugger (skipped)");
                continue;
            }
            if (Log.Watch.pathway) {
                System.out.println("\t... " + debugger);
            }
            debugger.spreadWatchCreation(nativeWatch);
        }
    }

    private void notifyUnsavedFiles(NativeDebugger debugger, List<String> fileNames) {
        String[] file = new String[fileNames.size()];
        file = fileNames.toArray(file);
        if (debugger != null) {
            debugger.notifyUnsavedFiles(file);
        } else {
            for (NativeSession s : this.getSessions()) {
                DebuggerEngine engine = s.coreSession().getCurrentEngine();
                NativeDebugger nd = (NativeDebugger)engine.lookupFirst(null, NativeDebugger.class);
                if (nd == null) continue;
                nd.notifyUnsavedFiles(file);
            }
        }
    }

    private void notifyUnsavedFiles(NativeDebugger debugger, Set<DataObject> set) {
        ArrayList<String> filesNames = new ArrayList<String>();
        for (DataObject dao : set) {
            File f;
            FileObject fo = dao.getPrimaryFile();
            if (fo == null || (f = FileUtil.toFile((FileObject)fo)) == null) continue;
            try {
                filesNames.add(f.getCanonicalPath());
            }
            catch (Exception ex) {
                filesNames.add(f.getPath());
            }
        }
        this.notifyUnsavedFiles(debugger, filesNames);
    }

    public void initialUnsavedFiles(NativeDebugger debugger) {
        DataObject.Registry registry = DataObject.getRegistry();
        this.notifyUnsavedFiles(debugger, registry.getModifiedSet());
    }

    private void init() {
        DataObject.Registry registry = DataObject.getRegistry();
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Object source = evt.getSource();
                if (!(source instanceof Set)) {
                    throw new UnsupportedOperationException(evt.toString());
                }
                Set set = (Set)source;
                DebuggerManager.this.notifyUnsavedFiles(null, set);
            }
        };
        ChangeListener weakChangeListener = WeakListeners.change((ChangeListener)this.changeListener, (Object)registry);
        registry.addChangeListener(weakChangeListener);
        this.notifyUnsavedFiles(null, registry.getModifiedSet());
    }

    public static boolean isStandalone() {
        return standalone;
    }

    private static org.netbeans.api.debugger.DebuggerManager delegate() {
        return org.netbeans.api.debugger.DebuggerManager.getDebuggerManager();
    }

    public void shutDown() {
        for (NativeDebugger nativeDebugger : this.nativeDebuggers()) {
            nativeDebugger.shutDown();
        }
    }

    public void saveGlobalState() {
        Session[] coreSessions = DebuggerManager.delegate().getSessions();
        assert (coreSessions == null || coreSessions.length == 0) : "Still have sessions when shutting down";
        if (this.breakpointBag != null && DebuggerOption.SAVE_BREAKPOINTS.isEnabled(this.globalOptions())) {
            this.breakpointBag.save();
        }
        if (this.watchBag != null) {
            this.watchBag.save();
        }
        if (DebuggerManager.isStandalone()) {
            DebugTargetList.saveList();
            CustomizableHostList.saveList();
        }
    }

    static ActionEnabler actionEnabler() {
        if (actionEnabler == null) {
            actionEnabler = new ActionEnabler();
        }
        return actionEnabler;
    }

    public void registerSessionModel(ModelListenerSupport model) {
        this.sessionUpdater.setListener(model);
    }

    public ModelListener sessionUpdater() {
        return this.sessionUpdater;
    }

    public NativeSession[] getSessions() {
        ArrayList<NativeSession> nativeSessions = new ArrayList<NativeSession>();
        Session[] coreSessions = DebuggerManager.delegate().getSessions();
        for (int sx = 0; sx < coreSessions.length; ++sx) {
            NativeSession ds = NativeSession.map(coreSessions[sx]);
            if (ds == null) continue;
            nativeSessions.add(ds);
        }
        return nativeSessions.toArray(new NativeSession[nativeSessions.size()]);
    }

    public int sessionCount() {
        return DebuggerManager.delegate().getSessions().length;
    }

    public void setCurrentSession(Session s) {
        DebuggerManager.delegate().setCurrentSession(s);
    }

    public void setCurrentDebugger(NativeDebugger d) {
        this.currentDebugger = d;
    }

    public NativeDebugger currentDebugger() {
        return this.currentDebugger;
    }

    public NativeDebugger currentNativeDebugger() {
        return this.currentDebugger;
    }

    private void switchOutput(final NativeDebugger od, final NativeDebugger nd) {
        boolean redundant;
        boolean bl = redundant = od == nd;
        if (od != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    od.deactivate(redundant);
                }
            });
        }
        if (nd != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    nd.activate(redundant);
                }
            });
        }
        this.currentDebugger = nd;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("currentSession".equals(e.getPropertyName())) {
            if (Log.Start.debug) {
                System.out.printf("DebuggerManager.PROP_CURRENT_SESSION\n", new Object[0]);
            }
            NativeDebugger odebugger = null;
            Session osession = (Session)e.getOldValue();
            if (osession != null) {
                DebuggerEngine oengine = osession.getCurrentEngine();
                odebugger = (NativeDebugger)oengine.lookupFirst(null, NativeDebugger.class);
            }
            NativeDebugger ndebugger = null;
            Session nsession = (Session)e.getNewValue();
            if (nsession != null) {
                DebuggerEngine nengine = nsession.getCurrentEngine();
                ndebugger = (NativeDebugger)nengine.lookupFirst(null, NativeDebugger.class);
            }
            this.switchOutput(odebugger, ndebugger);
        }
    }

    public NativeWatch mapWatch(Watch watch) {
        NativeWatch nativeWatch = this.watchMap.get(watch);
        if (nativeWatch != null) assert (nativeWatch.watch() == watch);
        return nativeWatch;
    }

    public void watchMap(NativeWatch nativeWatch) {
        assert (nativeWatch.watch() != null);
        this.watchMap.put(nativeWatch.watch(), nativeWatch);
    }

    public void watchAdded(Watch watch) {
        if (Log.Watch.pathway) {
            System.out.printf("DebuggerManager.watchAdded('%s')\n", watch.getExpression());
        }
        if (watch.getExpression() == null) {
            if (Log.Watch.pathway) {
                System.out.printf("\tnull expression\n", new Object[0]);
            }
        } else {
            if (Log.Watch.pathway) {
                System.out.printf("\tproceeding\n", new Object[0]);
            }
            NativeWatch nativeWatch = new NativeWatch(watch);
            this.watchMap(nativeWatch);
            this.watchBag().restore(nativeWatch);
            if (!this.watchBag().isRestoring()) {
                this.spreadWatchCreation(null, nativeWatch);
            }
        }
    }

    public void watchRemoved(Watch watch) {
        if (Log.Watch.pathway) {
            System.out.printf("DebuggerManager.watchRemoved('%s')\n", watch.getExpression());
        }
        NativeWatch removed = this.watchMap.remove(watch);
        assert (removed == null || removed.watch() == watch);
        this.watchBag().remove(removed);
    }

    private Start startDebuggerDialog(String programInfo, String hostname) {
        if (DebuggerOption.SESSION_REUSE.isEnabled(this.globalOptions())) {
            return Start.REUSE;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 8));
        String title = Catalog.get("TITLE_StartNewSession");
        String msg = Catalog.format("FMT_StartNewSession", programInfo, hostname);
        JTextArea textArea = new JTextArea(msg);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        textArea.setOpaque(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        Catalog.setAccessibleName(panel, "ACSD_StartNewSession");
        panel.getAccessibleContext().setAccessibleDescription(textArea.getText());
        panel.add((Component)textArea, "Center");
        JCheckBox checkBox = new JCheckBox();
        checkBox.setText(Catalog.get("CTL_session_reuse"));
        checkBox.setMnemonic(Catalog.get("CTL_session_reuse_Mnemonic").charAt(0));
        checkBox.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_session_reuse"));
        checkBox.setSelected(DebuggerOption.SESSION_REUSE.isEnabled(this.globalOptions()));
        panel.add((Component)checkBox, "South");
        panel.setPreferredSize(new Dimension(100, 130));
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)panel, title);
        JButton b_reuse = new JButton(Catalog.get("CTL_FinishAndStart"));
        b_reuse.setMnemonic(Catalog.get("CTL_FinishAndStart_Mnemonic").charAt(0));
        b_reuse.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_FinishAndStart"));
        JButton b_new = new JButton(Catalog.get("CTL_StartNewSession"));
        b_new.setMnemonic(Catalog.get("CTL_StartNewSession_Mnemonic").charAt(0));
        b_new.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_StartNewSession"));
        descriptor.setOptions(new Object[]{b_reuse, b_new, NotifyDescriptor.CANCEL_OPTION});
        Object pressedButton = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        DebuggerOption.SESSION_REUSE.setEnabled(new OptionLayers(this.globalOptions), checkBox.isSelected());
        if (pressedButton == b_new) {
            return Start.NEW;
        }
        if (pressedButton == b_reuse) {
            return Start.REUSE;
        }
        return Start.CANCEL;
    }

    private static CompilerSet compilerSet(Configuration makeConfiguration) {
        if (makeConfiguration instanceof MakeConfiguration && ((MakeConfiguration)makeConfiguration).getCompilerSet() != null) {
            return ((MakeConfiguration)makeConfiguration).getCompilerSet().getCompilerSet();
        }
        return null;
    }

    public static EngineType debuggerType(Configuration configuration) {
        ToolchainManager.DebuggerDescriptor descriptor;
        EngineType typeForTool;
        Tool debugger;
        CompilerSet compilerSet;
        EngineType ret = EngineTypeManager.getOverrideEngineType();
        if (ret != null) {
            return ret;
        }
        EngineProfile engineProfile = (EngineProfile)configuration.getAuxObject("nativedebugger");
        ret = engineProfile == null ? EngineTypeManager.getInherited() : engineProfile.getEngineType();
        if (ret.isInherited() && (compilerSet = DebuggerManager.compilerSet(configuration)) != null && (debugger = compilerSet.getTool((ToolKind)PredefinedToolKind.DebuggerTool)) != null && (typeForTool = EngineTypeManager.getEngineTypeForDebuggerDescriptor(descriptor = (ToolchainManager.DebuggerDescriptor)debugger.getDescriptor())) != null) {
            ret = typeForTool;
        }
        if (ret.isInherited()) {
            ret = EngineTypeManager.getFallbackEnineType();
        }
        return ret;
    }

    private NativeDebuggerInfo makeNativeDebuggerInfo(EngineType debuggerType) {
        NativeDebuggerInfo.Factory factory;
        NativeDebuggerInfo info = null;
        Collection factories = Lookup.getDefault().lookupAll(NativeDebuggerInfo.Factory.class);
        Iterator i$ = factories.iterator();
        while (i$.hasNext() && (info = (factory = (NativeDebuggerInfo.Factory)i$.next()).create(debuggerType)) == null) {
        }
        assert (info != null) : "unknown debugger type " + debuggerType;
        return info;
    }

    private Start getExistingDebugger(NativeDebuggerInfo ndi) {
        Start start = Start.CANCEL;
        if (this.currentDebugger != null) {
            String currentHostName = this.currentDebugger.session().getSessionHost();
            String desiredHostName = ndi.getHostName();
            EngineType currentEngine = this.currentDebugger.getNDI().debuggerType();
            EngineType desiredEngine = ndi.debuggerType();
            if (Log.Startup.debug) {
                System.out.printf("getExistingDebugger():\n", new Object[0]);
                System.out.printf("\tcurrentHostName %s\n", currentHostName);
                System.out.printf("\tdesiredHostName %s\n", desiredHostName);
            }
            if (currentEngine != null && !currentEngine.equals(desiredEngine)) {
                start = Start.NEW;
            } else if (ndi.isCaptured()) {
                start = Start.NEW;
            } else if (IpeUtils.sameString(currentHostName, desiredHostName)) {
                Host currentHost = this.currentDebugger.getHost();
                if (!this.currentDebugger.state().isLoaded) {
                    start = !currentHost.isLinux() ? Start.REUSE : Start.NEW;
                } else {
                    CustomizableHost desiredHost = this.getHostList().getHostByName(desiredHostName);
                    if (desiredHost != null && desiredHost.isLinux()) {
                        start = Start.NEW;
                    } else {
                        String programInfo = this.currentDebugger.session().toString();
                        start = this.startDebuggerDialog(programInfo, desiredHostName);
                    }
                }
            } else {
                start = Start.NEW;
            }
        } else {
            start = Start.NEW;
        }
        if (start == Start.CANCEL) {
            return start;
        }
        if (start == Start.NEW) {
            return start;
        }
        return Start.REUSE;
    }

    private void startDebugger(Start start, NativeDebuggerInfo ndi) {
        if (start == Start.CANCEL) {
            return;
        }
        if (start == Start.NEW) {
            if (this.currentDebugger != null) {
                DebuggerManager.openComponent("sessionsView", true);
            }
            this.debugNoAsk(ndi);
        } else {
            this.currentDebugger.reuse(ndi);
        }
    }

    public void debugNoAsk(NativeDebuggerInfo ndi) {
        final DebuggerInfo di = DebuggerInfo.create((String)ndi.getID(), (Object[])new Object[]{ndi});
        if (DebuggerManager.isAsyncStart()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    DebuggerManager.delegate().startDebugging(di);
                }
            });
        } else {
            DebuggerManager.delegate().startDebugging(di);
        }
    }

    public void debugProject(DebugTarget dt, String projectFolder, String processName) {
        Project project = null;
        if (projectFolder != null && processName != null) {
            project = ProjectSupport.matchProject(projectFolder, processName);
        }
        if (project == null) {
            try {
                project = dt.createProject();
            }
            catch (Exception e) {
                project = null;
            }
        }
        if (project != null) {
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, (ProjectActionEvent.Type)ProjectActionEvent.PredefinedType.DEBUG_STEPINTO, dt.getExecutable(), ConfigurationSupport.getProjectActiveConfiguration((Project)project), null, false);
            ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
        } else {
            System.out.println("    project is null        ");
        }
    }

    public void debugTarget(DebugTarget debugtarget, boolean runFirst, boolean use32bitEngine) {
        MakeConfiguration conf = debugtarget.getConfig();
        String execPath = debugtarget.getExecutable();
        NativeDebuggerInfo ndi = this.makeNativeDebuggerInfo(DebuggerManager.debuggerType((Configuration)conf));
        ndi.setDebugTarget(debugtarget);
        if (execPath == null || execPath.equals("") || execPath.equals(" ")) {
            conf.getProfile().setRunDir(System.getenv("PWD"));
        }
        if (execPath != null) {
            conf.getMakefileConfiguration().getOutput().setValue(execPath);
        }
        ndi.setTarget(execPath);
        ndi.setHostName(debugtarget.getHostName());
        ndi.setConfiguration((Configuration)conf);
        ndi.set32bitEngine(use32bitEngine);
        if (runFirst) {
            ndi.setAction(1);
        } else if (DebuggerManager.isStandalone() || !DebuggerOption.RUN_AUTOSTART.isEnabled(this.globalOptions())) {
            ndi.setAction(16);
        } else {
            ndi.setAction(this.getAction());
        }
        if (DebuggerManager.isStandalone()) {
            this.startDebugger(this.getExistingDebugger(ndi), ndi);
        } else {
            this.startDebugger(Start.NEW, ndi);
        }
    }

    private static boolean isDoNotShowAgain() {
        return prefs.getBoolean(PREF_DONOTSHOWAGAIN, false);
    }

    private static void setDoNotShowAgain(boolean doNotShowAgain) {
        prefs.putBoolean(PREF_DONOTSHOWAGAIN, doNotShowAgain);
    }

    private static void refDbxtool(String msg) {
        InfoPanel panel = new InfoPanel(msg);
        NotifyDescriptor.Confirmation dlg = new NotifyDescriptor.Confirmation((Object)panel, Catalog.get("INFORMATION"), -1);
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg);
        DebuggerManager.setDoNotShowAgain(panel.dontShowAgain());
        if (answer == NotifyDescriptor.CLOSED_OPTION) {
            return;
        }
    }

    public CustomizableHostList getHostList() {
        if (!DebuggerManager.isStandalone()) {
            return null;
        }
        if (this.hostList == null) {
            this.hostList = CustomizableHostList.getInstance();
        }
        return this.hostList;
    }

    public DebugTarget getDTByKey(String key) {
        if (debugtargetlist == null) {
            return null;
        }
        DebugTarget dt = null;
        int dtIndex = debugtargetlist.recordByKey(key);
        if (dtIndex != -1) {
            dt = (DebugTarget)debugtargetlist.getRecordAt(dtIndex);
        }
        return dt;
    }

    public DebugTargetList getDebugTargetList() {
        return debugtargetlist;
    }

    public void addRecentDebugTarget(String progname, boolean from_unload) {
        int foundAt;
        if (!DebuggerManager.isStandalone() || progname == null || progname.length() == 0) {
            return;
        }
        String corefile = this.currentDebugger.session().getCorefile();
        DebugTarget dt = this.currentDebugger.getNDI().getDebugTarget();
        if (dt != null) {
            if (corefile != null) {
                dt.setExecutable(progname);
            } else if (!dt.getExecutable().equals(progname) && !from_unload) {
                dt.setExecutable(progname);
            }
        }
        if ((foundAt = debugtargetlist.recordByKey(dt.getKey())) != -1) {
            debugtargetlist.replaceRecordAt(dt, foundAt);
            debugtargetlist.moveToFront(foundAt);
        } else {
            debugtargetlist.addRecord(dt);
        }
    }

    public void debug(String executable, Configuration configuration, String host, InputOutput io, DbgActionHandler dah, RunProfile profile) {
        NativeDebuggerInfo ndi = this.makeNativeDebuggerInfo(DebuggerManager.debuggerType(configuration));
        ndi.setTarget(executable);
        ndi.setHostName(host);
        ndi.setConfiguration(configuration);
        ndi.setProfile(profile);
        ndi.setInputOutput(io);
        ndi.setDah(dah);
        if (DebuggerManager.isStandalone() || !DebuggerOption.RUN_AUTOSTART.isEnabled(this.globalOptions())) {
            ndi.setAction(16);
        } else {
            ndi.setAction(this.getAction());
        }
        this.startDebugger(Start.NEW, ndi);
    }

    public void attach(DebugTarget dt) {
        MakeConfiguration conf = dt.getConfig();
        NativeDebuggerInfo ndi = this.makeNativeDebuggerInfo(DebuggerManager.debuggerType((Configuration)conf));
        ndi.setDebugTarget(dt);
        ndi.setPid(dt.getPid());
        Host host = Host.byName(dt.getHostName());
        Executor executor = Executor.getDefault(Catalog.get("File"), host, 0);
        EngineDescriptor engine = ndi.getEngineDescriptor();
        if (engine.hasCapability(EngineCapability.DERIVE_EXECUTABLE)) {
            ndi.setTarget("-");
        } else {
            String execPath = ndi.getTarget();
            if (host.getPlatform() != Platform.Windows_x86) {
                execPath = executor.readlink(dt.getPid());
            }
            ndi.setTarget(execPath);
        }
        ndi.setConfiguration((Configuration)conf);
        ndi.setHostName(dt.getHostName());
        ndi.setAction(4);
        ndi.setCaptureInfo(dt.getCaptureInfo());
        if (DebuggerManager.isStandalone()) {
            this.startDebugger(this.getExistingDebugger(ndi), ndi);
        } else {
            this.startDebugger(Start.NEW, ndi);
        }
    }

    public void debugCore(DebugTarget dt) {
        MakeConfiguration conf = dt.getConfig();
        NativeDebuggerInfo ndi = this.makeNativeDebuggerInfo(DebuggerManager.debuggerType((Configuration)conf));
        ndi.setDebugTarget(dt);
        ndi.setTarget(dt.getExecutable());
        ndi.setHostName(dt.getHostName());
        ndi.setCorefile(dt.getCorefile());
        ndi.setConfiguration((Configuration)conf);
        ndi.setAction(8);
        if (DebuggerManager.isStandalone()) {
            this.startDebugger(this.getExistingDebugger(ndi), ndi);
        } else {
            this.startDebugger(Start.NEW, ndi);
        }
    }

    public void restoreDT() {
        if (DebuggerManager.isStandalone() && debugtargetlist == null) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            debugtargetlist = DebugTargetList.getInstance();
        }
    }

    public WatchBag watchBag() {
        if (this.watchBag == null) {
            this.watchBag = new WatchBag();
            this.watchBag.restore();
        }
        return this.watchBag;
    }

    public void postDeleteAllWatches() {
        for (NativeDebugger debugger : this.nativeDebuggers()) {
            debugger.postDeleteAllWatches();
        }
    }

    public ModelListenerSupport watchModelListener() {
        return this.watchModelListener;
    }

    public ModelChangeDelegator watchUpdater() {
        return this.watchUpdater;
    }

    public BreakpointBag breakpointBag() {
        if (this.breakpointBag == null) {
            this.breakpointBag = new BreakpointBag();
            if (DebuggerOption.SAVE_BREAKPOINTS.isEnabled(this.globalOptions())) {
                this.breakpointBag.restore();
            }
        }
        return this.breakpointBag;
    }

    public ModelListenerSupport breakpointModelListener() {
        return this.breakpointModelListener;
    }

    public ModelChangeDelegator breakpointUpdater() {
        return this.breakpointUpdater;
    }

    public Watch createWatch(String expression) {
        return DebuggerManager.delegate().createWatch(expression);
    }

    public Watch[] getWatches() {
        return DebuggerManager.delegate().getWatches();
    }

    public void removeBreakpoint(NativeBreakpoint b) {
        DebuggerManager.delegate().removeBreakpoint((Breakpoint)b);
    }

    public void addBreakpoint(NativeBreakpoint b) {
        DebuggerManager.delegate().addBreakpoint((Breakpoint)b);
    }

    public void handleExec64() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(Catalog.get("EXEC64MSG")), "North");
        JCheckBox jc = new JCheckBox(Catalog.get("OPTION_EXEC64"));
        jc.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_OPTION_EXEC64"));
        panel.add((Component)jc, "South");
        jc.setSelected(!DebuggerOption.OPTION_EXEC32.isEnabled(this.currentDebugger.optionLayers()));
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, Catalog.get("DebuggerError"), true, new Object[]{jc, DialogDescriptor.OK_OPTION}, (Object)jc, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setMessageType(2);
        dlg.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION});
        dialog.setVisible(true);
        if (jc.isSelected()) {
            DebuggerOption.OPTION_EXEC32.setCurrValue(this.currentDebugger.optionLayers(), "off");
            DebugTarget dt = this.currentDebugger.getNDI().getDebugTarget();
            NativeDebuggerInfo ndi = this.currentDebugger.getNDI();
            ndi.setConfiguration((Configuration)dt.getConfig());
            this.currentDebugger.postKill();
            this.startDebugger(Start.NEW, ndi);
        }
    }

    public void handleExec32() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(Catalog.get("EXEC32MSG")), "North");
        JCheckBox jc = new JCheckBox(Catalog.get("OPTION_EXEC32"));
        jc.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_OPTION_EXEC32"));
        panel.add((Component)jc, "South");
        jc.setSelected(DebuggerOption.OPTION_EXEC32.isEnabled(this.currentDebugger.optionLayers()));
        DialogDescriptor dlg = new DialogDescriptor((Object)panel, Catalog.get("DebuggerError"), true, new Object[]{jc, DialogDescriptor.OK_OPTION}, (Object)jc, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dlg.setMessageType(2);
        dlg.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION});
        dialog.setVisible(true);
        if (jc.isSelected()) {
            DebuggerOption.OPTION_EXEC32.setCurrValue(this.currentDebugger.optionLayers(), "on");
            DebugTarget dt = this.currentDebugger.getNDI().getDebugTarget();
            NativeDebuggerInfo ndi = this.currentDebugger.getNDI();
            ndi.setConfiguration((Configuration)dt.getConfig());
            this.currentDebugger.postKill();
            this.startDebugger(Start.NEW, ndi);
        }
    }

    private boolean error_sourceModified(NativeDebugger origin, String msg) {
        origin.setSrcOODMessage(msg);
        return false;
    }

    private void error_BadCore(String explanation, boolean canForce) {
        Object[] options;
        Object def;
        JButton forceButton = new JButton();
        forceButton.setText(Catalog.get("CoreLoadAnyway"));
        Catalog.setAccessibleDescription(forceButton, "ACSD_CoreLoadAnyway");
        forceButton.setMnemonic(Catalog.getMnemonic("MNEM_CoreLoadAnyway"));
        if (canForce) {
            def = forceButton;
            options = new Object[]{forceButton, NotifyDescriptor.CANCEL_OPTION};
        } else {
            def = NotifyDescriptor.OK_OPTION;
            options = new Object[]{NotifyDescriptor.OK_OPTION};
        }
        DialogDescriptor dlg = new DialogDescriptor((Object)explanation, Catalog.get("CorefileError"), true, options, def, 0, null, null);
        dlg.setMessageType(0);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dlg);
        dialog.setVisible(true);
        Object pressedButton = dlg.getValue();
        if (pressedButton == forceButton) {
            // empty if block
        }
    }

    private void error_runFailed(NativeDebugger originatingDebugger) {
        originatingDebugger.runFailed();
    }

    public void error(int rt, final Error error, NativeDebugger originatingDebugger) {
        if (error.isRedundantPathmap()) {
            return;
        }
        if (RoutingToken.BREAKPOINTS.isSameSubsystem(rt) && error.maxSeverity() == Error.Severity.ERROR ? originatingDebugger.bm().noteBreakpointError(rt, error) : RoutingToken.WATCHES.isSameSubsystem(rt) && error.maxSeverity() == Error.Severity.ERROR && originatingDebugger.watchError(rt, error)) {
            return;
        }
        boolean handled = false;
        if (error.errorToken() != null) {
            if (error.isBadcore()) {
                this.error_BadCore(Catalog.get("CoreNameMismatch"), true);
                handled = true;
            } else if (error.isBadcoreOod()) {
                this.error_BadCore(Catalog.get("CoreOld"), true);
                handled = true;
            } else if (error.isBadcoreNoprog()) {
                this.error_BadCore(Catalog.get("CoreNameExtract"), false);
                handled = true;
            } else if (error.isXExec32()) {
                handled = false;
            } else if (error.isXExec64()) {
                handled = false;
            } else if (error.isOodSrc()) {
                Host host = originatingDebugger.getHost();
                if (!this.isFixing() && host != null && !host.isLinux() && this.error_sourceModified(originatingDebugger, error.text())) {
                    this.setFixStatus(true);
                    this.currentDebugger().fix();
                }
                handled = true;
            } else if (error.isRunFailed()) {
                this.error_runFailed(originatingDebugger);
                handled = true;
            } else assert (false) : "Error cookie \"" + error.errorToken() + "\" not handled in Dbx.error";
        }
        if (!handled && error.maxSeverity() == Error.Severity.ERROR) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IpeUtils.postError(error.text());
                }
            });
        }
        this.refocusDialog();
    }

    private static JComponent errorWarning(String msg) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        Catalog.setAccessibleName(textArea, "ACSN_WarningArea");
        Catalog.setAccessibleDescription(textArea, "ACSD_WarningArea");
        textArea.setLineWrap(false);
        textArea.setEditable(false);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        textArea.setColumns(60);
        textArea.setRows(7);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(textArea);
        Catalog.setAccessibleDescription(scrollPane, "ACSD_Warning");
        textArea.setText(msg);
        return scrollPane;
    }

    public static void error(String msg) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)DebuggerManager.errorWarning(msg), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    public static void warning(String msg) {
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)DebuggerManager.errorWarning(msg), 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    public static void errorLoadBeforeBpt() {
        String msg = Catalog.get("ERR_no_set_til_session");
        NotifyDescriptor.Message n = new NotifyDescriptor.Message((Object)msg, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)n);
    }

    public ItemSelectorResult popup(int rt, String cookie, NativeDebugger originatingDebugger, String title, int nitems, String[] item, boolean cancelable, boolean multiple_selection) {
        return this.popupHelp(title, nitems, item, cancelable, multiple_selection);
    }

    public ItemSelectorResult popupHelp(String title, int nitems, String[] item, boolean cancelable, boolean multiple_selection) {
        ItemSelectorDialog isd = new ItemSelectorDialog();
        isd.showWindow(title, nitems, item, cancelable, multiple_selection);
        return isd.getResult();
    }

    public void setFixStatus(boolean f) {
        this.isfixing = f;
    }

    public boolean isFixing() {
        return this.isfixing;
    }

    public void registerDialog(DialogManager dialog) {
        if (this.currentDialog == dialog) {
            return;
        }
        if (this.currentDialog != null) {
            DbgGuiModule.logger.log(Level.WARNING, "DebuggerManager.registerDialog(): registering a dialog when previous one wasn't deregistered");
        }
        this.currentDialog = dialog;
    }

    public void deRegisterDialog(DialogManager dialog) {
        if (this.currentDialog == null) {
            return;
        }
        assert (this.currentDialog == dialog);
        this.currentDialog = null;
    }

    public void bringDownDialog() {
        if (this.currentDialog != null) {
            this.currentDialog.bringDown();
            this.deRegisterDialog(this.currentDialog);
        }
    }

    private void refocusDialog() {
        if (this.currentDialog != null) {
            this.currentDialog.refocus();
        }
    }

    public void setStatusText(String text) {
        if (statusDisplayer == null) {
            statusDisplayer = StatusDisplayer.getDefault();
        }
        statusDisplayer.setStatusText(text);
    }

    public String formatStatusText(String fmtKey, String[] args) {
        String msg = Catalog.format(fmtKey, new Object[]{args});
        this.setStatusText(msg);
        return msg;
    }

    public void updateProgress(final String message, final String note, final int progress) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateProgressSameThread(message, note, progress);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManager.this.updateProgressSameThread(message, note, progress);
                }
            });
        }
    }

    private void updateProgressSameThread(String message, String note, int progress) {
        StatusDisplayer.getDefault().setStatusText(message != null ? message : note);
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressMonitor(null, message != null ? message : note, note != null ? note : "", 0, 100);
            this.progressMonitor.setMillisToPopup(0);
            this.progressMonitor.setMillisToDecideToPopup(0);
            if (progress != -1) {
                this.progressMonitor.setProgress(progress);
            }
        } else {
            if (progress != -1) {
                this.progressMonitor.setProgress(progress);
            }
            if (note != null) {
                this.progressMonitor.setNote(note);
            }
        }
    }

    public void cancelProgress() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cancelProgressSameThread();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManager.this.cancelProgressSameThread();
                }
            });
        }
    }

    private void cancelProgressSameThread() {
        StatusDisplayer.getDefault().setStatusText("");
        if (this.progressMonitor != null) {
            this.progressMonitor.close();
            this.progressMonitor = null;
        }
    }

    boolean isProgressCancelled() {
        if (this.progressMonitor == null) {
            return false;
        }
        return this.progressMonitor.isCanceled();
    }

    public void aboutToFork(NativeDebugger debugger, String name) {
        FollowForkDialog d = new FollowForkDialog(debugger, name);
        d.show();
    }

    public OptionSet globalOptions() {
        if (this.globalOptions == null) {
            this.globalOptions = new GlobalOptionSet();
        }
        this.globalOptions.open();
        return this.globalOptions;
    }

    public void applyGlobalOptions() {
        OptionSet options = this.globalOptions();
        for (NativeDebugger debugger : this.nativeDebuggers()) {
            OptionClient client = debugger.getOptionClient();
            if (client == null) continue;
            options.applyTo(client);
        }
        options.doneApplying();
    }

    public void setAction(int i) {
        this.action |= i;
    }

    public void removeAction(int i) {
        this.action &= ~i;
    }

    public int getAction() {
        return this.action;
    }

    public void enableConsoleWindow() {
        if (this.currentNativeDebugger() == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManager.this.enableConsoleWindow();
                }
            });
            return;
        }
        ConsoleTopComponent.findInstance().open();
        if (DebuggerOption.FRONT_DBGWIN.isEnabled(this.globalOptions())) {
            ConsoleTopComponent.findInstance().requestActive();
        }
    }

    public void enablePioWindow() {
        if (this.currentNativeDebugger() == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManager.this.enablePioWindow();
                }
            });
            return;
        }
        PioTopComponent.findInstance().open();
        PioTopComponent.findInstance().requestActive();
    }

    public void setIO(InputOutput io) {
        this.io = io;
    }

    public InputOutput getIO() {
        return this.io;
    }

    public static TopComponent openComponent(String viewName, boolean activate) {
        TopComponent view = WindowManager.getDefault().findTopComponent(viewName);
        if (view == null) {
            throw new IllegalArgumentException(viewName);
        }
        view.open();
        if (activate) {
            view.requestActive();
        }
        return view;
    }

    static {
        debugtargetlist = null;
        prefs = NbPreferences.forModule(DebuggerManager.class);
        last_stopAfterFork = false;
    }

    private static class FollowForkDialog {
        private NativeDebugger origin;
        private Dialog dialog;
        private DialogDescriptor dlg;
        private JButton parentButton;
        private JButton childButton;
        private JButton bothButton;
        private JButton stopButton;
        private JCheckBox jc;

        public FollowForkDialog(NativeDebugger origin, String name) {
            this.origin = origin;
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            String msg = Catalog.get("ProcForkQuestion");
            JTextArea textArea = new JTextArea(msg);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setEditable(false);
            textArea.setEnabled(false);
            textArea.setOpaque(false);
            textArea.setFont(UIManager.getFont("Label.font"));
            textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
            panel.add((Component)textArea, "Center");
            this.jc = new JCheckBox(Catalog.get("ProcForkStopAfter"));
            this.jc.setSelected(last_stopAfterFork);
            Catalog.setAccessibleDescription(this.jc, "ACSD_FollowStopAfter");
            this.jc.setMnemonic(Catalog.getMnemonic("MNEM_FollowStopAfter"));
            panel.add((Component)this.jc, "South");
            this.parentButton = new JButton();
            this.parentButton.setText(Catalog.get("ProcForkParent"));
            Catalog.setAccessibleDescription(this.parentButton, "ACSD_FollowParent");
            this.parentButton.setMnemonic(Catalog.getMnemonic("MNEM_FollowParent"));
            this.childButton = new JButton();
            this.childButton.setText(Catalog.get("ProcForkChild"));
            Catalog.setAccessibleDescription(this.childButton, "ACSD_FollowChild");
            this.childButton.setMnemonic(Catalog.getMnemonic("MNEM_FollowChild"));
            this.bothButton = new JButton();
            this.bothButton.setText(Catalog.get("ProcForkBoth"));
            Catalog.setAccessibleDescription(this.bothButton, "ACSD_FollowBoth");
            this.bothButton.setMnemonic(Catalog.getMnemonic("MNEM_FollowBoth"));
            this.stopButton = new JButton();
            this.stopButton.setText(Catalog.get("ProcForkStop"));
            Catalog.setAccessibleDescription(this.stopButton, "ACSD_FollowStop");
            this.stopButton.setMnemonic(Catalog.getMnemonic("MNEM_FollowStop"));
            Host host = origin.getHost();
            if (host != null && host.isLinux()) {
                this.bothButton.setEnabled(false);
            }
            String title = Catalog.format("TTL_ProcForkHeader", name);
            this.dlg = new DialogDescriptor((Object)panel, title, true, (Object[])new JButton[]{this.parentButton, this.childButton, this.bothButton, this.stopButton}, (Object)this.parentButton, 0, null, null);
            this.dlg.setMessageType(1);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
            Catalog.setAccessibleDescription(this.dialog, "ACSD_Followfork");
        }

        public void show() {
            this.dialog.setVisible(true);
            FollowForkInfo ffi = this.getResult();
            this.origin.forkThisWay(ffi);
        }

        public FollowForkInfo getResult() {
            FollowForkInfo ffi = new FollowForkInfo();
            Object pressedButton = this.dlg.getValue();
            if (pressedButton == this.parentButton) {
                ffi.parent = true;
            } else if (pressedButton == this.childButton) {
                ffi.child = true;
            } else if (pressedButton == this.bothButton) {
                ffi.parent = true;
                ffi.child = true;
            } else if (pressedButton == this.stopButton) {
                // empty if block
            }
            if (this.jc.isSelected()) {
                ffi.stopAfterFork = true;
            }
            last_stopAfterFork = ffi.stopAfterFork;
            return ffi;
        }
    }

    public static final class FollowForkInfo {
        public boolean parent;
        public boolean child;
        public boolean stopAfterFork;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Start {
        NEW,
        CANCEL,
        REUSE;

    }

    private static final class LazyInitializer {
        private static final DebuggerManager singleton = new DebuggerManager();

        private LazyInitializer() {
        }

        static {
            LazyInitializer.singleton.init();
            singleton.breakpointBag();
        }
    }
}

